# Выдаленне файла з-пад GIT кантролю

Часам можа ўзнікнуць неабходнасць выдаліць файл з-пад GIT кантролю, але захаваць яго на кампутары. Гэта можа быць дасягнута з дапамогай наступнай каманды:

`` git rm <файл> --cached``

## Што ж адбылося?

GIT больш не кантралюе змены ў аддаленым файле. З пункту гледжання GIT, гэты файл адсутнічае, але калі вы паспрабуеце лакалізаваць гэты файл у файлавай сістэме, то вы ўбачыце, што ён усё яшчэ на месцы.

Звярніце ўвагу, што ў прыведзеным вышэй прыкладзе выкарыстоўваецца сцяг `--cached`. Калі мы не дадамо гэты сцяг, Git выдаліць файл не толькі з сховішча, але і з вашай файлавай сістэмы.

Калі вы здзейсніце змяненне з дапамогай `git commit -m" Remove file1.js "` і перанеслі яго ў аддаленае сховішча з дапамогай `git push origin master`, выдалены рэпазітар выдаліць файл.

## Дадатковая інфармацыя

- Калі вы хочаце выдаліць больш за адзін файл, гэта можна зрабіць, пералічыўшы ўсе файлы ў адной камандзе:

    `git rm file1.js file2.js file3.js --cached`

- Вы можаце выкарыстоўваць шаблон (*) для выдалення файлаў з блізкімі імёнамі, напрыклад, калі вы хочаце выдаліць усе .txt файлы з лакальнага рэпазітара, набярыце:

    `git rm * .txt --cached`