# Сінхранізацыя вашага адгалінаванні з асноўным рэпазітаром

Па-першае, варта разумець паток для поўнай сінхранізацыі, што важна. У гэтай схеме ёсць 3 розныя рэпазітары: мае адкрытыя сховішча ў Github `github.com / firstcontributions / first-doprino.git`, ваш відэлец сховішча на GitHub` github.com / Your-Name / first-donates / ` і сховішча мясцовай машыны, на якой вы павінны працаваць. Такі від супрацоўніцтва характэрны для праектаў з адкрытым зыходным кодам і называецца `Triangle Workflows`.

<img style="float;" src="https://firstcontributions.github.io/assets/additional-material/triangle_workflow.png" alt="triangle workflow" />

Каб захаваць вашыя два сховішчы ў актуальным стане з маім адкрытым сховішчам, мы спачатку павінны здабыць і аб'яднаць агульнае сховішча з рэпазітарам вашай лакальнай машыны.
Наш другі крок - перанесці ваша мясцовае сховішча ў відэлец GitHub. Як вы ўжо бачылі раней, толькі "з відэльцам" вы можаце папрасіць "pull request". Такім чынам, відэлец GitHub - апошняе сховішча, якое трэба абнавіць.

Зараз давайце паглядзім, як гэта зрабіць:

Па-першае, вы павінны быць на сваім вядучым аддзяленні. Каб даведацца, на якой філіяле вы знаходзіцеся, праверце першы радок:
```
git status
```
калі вы яшчэ не на майстры:
```
git checkout master
```

Затым вы павінны дадаць маё агульнадаступнае сховішча ў свой git з `add addstream stream-url`:
```
git remote add upstream https://github.com/firstcontributions/first-contributions.git
```

Гэта спосаб сказаць Git, што іншая версія гэтага праекта існуе ў паказаным URL-адресе, і мы называем яго "вышэй". Пасля таго, як ваш git мае імя, давайце пазнаём апошнюю версію грамадскага сховішча:
```
git fetch upstream
```

Вы толькі што атрымалі апошнюю версію майго відэльца (`upstream` remote). Зараз вам трэба аб'яднаць агульнадаступнае сховішча ў ваша галоўнае аддзяленне.
```
git rebase upstream/master
```
Тут вы аб'яднаеце грамадскае сховішча з вашай галоўнай галіной. Галоўнае аддзяленне вашай мясцовай машыны зараз актуальнае. І, нарэшце, калі вы націснеце галоўную галінку на відэлец, ваша відэлец GitHub таксама будзе змяняць:
```
git push origin master
```

Звярніце ўвагу, вы націскаеце на remote імя `origin`.

Такім чынам, да гэтага часу альбо ў гэты момант усе вашыя сховішчы актуальныя. Добра зроблена! Вы павінны рабіць гэта кожны раз, калі ваш сховішча GitHub паведамляе вам, што вы здзяйсняеце некалькі commits.