# Канфігураванне GIT

Калі вы ўпершыню паспрабавалі зрабіць commit, вы маглі ўбачыць такое паведамленне:

```bash
$ git commit
*** Please tell me who you are.

Run

git config --global user.email "you@example.com"
git config --global user.name "Your Name"

to set your account's default identity.
Omit --global to set the identity only in this repository.
```

Каб стварыць commit, GIT павінен ведаць хто з'яўляецца яго аўтарам. Пры сумеснай працы, неабходна ведаць кім і калі былі змененыя тыя ці іншыя часткі праекта, таму GIT прадугледжвае, што кожны commits пры яго стварэнні асацыюецца з імем і емейл адрасам карыстальніка.

Існуе некалькі спосабаў, якія дазваляюць асацыяваць каманду `git commit` з вашым емейл і імем, і тут мы пералічым некаторыя з іх.

### Глабальная канфігурацыя

Інфармацыя, захаваная як частка глабальнай канфігурацыі, адносіцца да ўсёй сістэмы, г.зн. да ўсіх рэпазітароў, у якіх вы працуеце. Гэта пераважны спосаб, прыдатны для большасці з варыянтаў выкарыстання.

Каб захаваць што-небудзь у глабальным канфігурацыі, вы выкарыстоўваеце каманду `config` наступным чынам:

`$ git config --global <variable name> <value>`

Ва ўжыванні да інфармацыі пра карыстальніка, мы выконваем гэтыя каманды такім чынам:

`` `
$ git config --global user.email "you@example.com"
$ git config --global user.name "Your Name"
`` `

### Канфігурацыя рэпазітара

Як вынікае з назвы, гэтыя канфігурацыі адносяцца да вашага бягучага сховішча. Калі вы хочаце прыняць удзел у пэўным сховішчы, скажам, на праекце, звязаным з працай, з электроннай поштай вашай кампаніі, то вы можаце скарыстацца гэтым метадам.

Каб змяніць канфігурацыю на ўзроўні рэпазітара, варта апусціць ключ `--global` у камандзе` config` такім чынам:

`$ git config <variable name> <value>`

Ва ўжыванні да інфармацыі пра карыстальніка, гэта выглядае наступным чынам:

`` `
$ git config user.email "you@alternate.com"
$ git config user.name "Your Name"
`` `

### Канфігурацыя ў камандным радку

Гэты спосаб канфігурацыі адносіцца толькі да дадзенай камандзе. Усе каманды GIT дазваляюць выкарыстоўваць ключ `-c` перад дзеясловам ідэнтыфікуюць каманду для часовай ўстаноўкі канфігурацыйных параметеров.

Для змены параметраў канфігурацыі, якія распаўсюджваюцца толькі на дадзеную каманду, карыстайцеся наступным фарматам каманд GIT:

`$ git -c <variable-1>=<value> -c <variable-2>=<value> <command>`

Для нашага выпадку Каманда для камітаў будзе вылядеть так:

`git -c user.name='Your Name' -c user.email='you@example.com' commit -m "Your commit message"`

### Заўвага аб парадку предшествования

Парадак предшествования сярод трох згаданых тыпаў каманд канфігурацыі вызначаецца як `command-line > repository > global`. Гэта азначае, што калі якая-небудзь пераменная вызначана, як у глабальнай канфігурацыі, так і ў камандным радку, то будзе выкарыстана значэнне, прысвоенае у камандным радку.

## Не толькі інфармацыя пра карыстальніка

Да гэтага часу, абмяркоўваючы канфігурацыю GIT'а, мы дакраналіся толькі інфармацыі пра карыстальніка. Аднак GIT дазваляе канфігураваць яшчэ неслколько параметраў. Вось некторые з іх:

1. `core.editor` - паказвае назва рэдактара для рэдагавання каментар для камітаў і да т.п.,
2. `commit.template` - паказвае файл, які змяшчае першапачатковы темплат для камітаў,
3. `color.ui` - лагічная зменная, якая ўказвае ці варта испольовать каляровыя шрыфты ў паведамленнях на тэрмінале GIT'а.

Для прастаты мы апусцілі некаторыя дэталі. Для больш падрабязнага азнаямлення звярніцеся да [git-scm.com](https://git-scm.com/book/en/v2/Customizing-Git-Git-Configuration).