# Additional information

We assume that you have already finished with the basic tutorial before coming here. This document will give you some additional information about advanced Git techniques.

### [Amending a commit](amending-a-commit.md)
This document provides information about how to amend a commit on the remote repository. Amending a commit is a way to modify the most recent commit you have made in your current branch. This can be helpful if you need to edit the commit message or if you forgot to include changes in the commit. You can continue to amend a commit until you push it to the remote repository.
> Use this when you need to adjust a commit you made.

### [Configuring git](configuring-git.md)
This document provides information about how to configure user details and other options in git.
> Use this to better control your git configurations.

### [Keeping your fork synced with the repository](keeping-your-fork-synced-with-this-repository.md)
This document provides information about how to keep your forked repository up-to-date with the base repository. This is important, as hopefully you and many others will contribute to the project.
> Follow these steps if your fork doesn't have any changes in parent repository.

### [Moving a Commit to a different Branch](moving-a-commit-to-a-different-branch.md)
This document provides information about how to move a Commit to another Branch.
> Take these steps to move a commit to another branch.

### [Removing a File](removing-a-file.md)
This document provides information about how to remove a file from your local repository.
> Follow these steps to learn how to remove a file prior to a commit

### [Removing a branch from your repository](removing-branch-from-your-repository.md)
This document provides information about how to delete a branch from your repository.
> Only after your pull request gets merged, follow to next steps

### [Resolving Merge Conflicts](resolving-merge-conflicts.md)
This document provides information about how to resolve merge conflicts.
> Take these steps to resolve the annoying merge conflicts.

### [Reverting a commit](reverting-a-commit.md)
This document provides information about how to revert a commit on the remote repository. It will come in handy in case you need to undo a commit that has already been pushed to Github.
> Take these steps if you want to reverse a commit.

### [Squashing Commits](squashing-commits.md)
This document provides information about how to squash commits with an interactive rebase.
> Use this if you want to open a PR in an open source project and the reviewer asks you to squash every commit into one, with an informative commit message.

### [Undo-ing a local commit](undoing-a-commit.md)
This document provides information about how to undo a commit on your local repository. This is what you need to do when you feel you've messed up your local repository and wish to reset the local repository.
> Take these steps if you want to undo/reset a local commit.

### [Useful Links](Useful-links-for-further-learning.md)
This document is dedicated to all the tips and tricks websites, blog posts, and helpful sites that make our lives easier. They are a great reference to serve all of our needs, be it a beginner or an expert. This page should act as an index of all those useful links that would help everybody who is new in the open-source domain or someone who wants to learn more.

### [Creating a .gitignore file](creating-a-gitignore-file.md)
This document explains what a .gitignore file does, why to use it and how to create a .gitignore file. This file is used in almost all git projects. It helps commit only necessary files to git.

### [Storing Credentials](storing-credentials.md)
This document explains how to store your credentials for repositories. This can be a security concern, so please follow the security policies of your place of work/study.
