# Useful Links

This document is dedicated to all the tips and tricks websites, blog posts, and helpful sites that make our lives easier. They are a great reference to serve all of our needs, be it a beginner or an expert. This page should act as an index of all those useful links that would help everybody who is new in the open-source domain or someone who wants to learn more.

## The List
1.  [Interactive tutorial to git](https://try.github.io)
2.  [Youtube: Git and GitHub for Beginners by freecodecamp](https://www.youtube.com/watch?v=RGOj5yH7evk)
3.  [git - the simple guide](http://rogerdudler.github.io/git-guide/)
4.  [On undoing, fixing, or removing commits in git](http://sethrobertson.github.io/GitFixUm/fixup.html)
5.  [Git and GitHub tutorial translated to many languages](https://github.com/Roshanjossey/first-contributions)
6.  [Merge Conflicts](https://www.git-tower.com/learn/git/ebook/en/command-line/advanced-topics/merge-conflicts)
7.  [Resolving Merge Conflicts](https://githowto.com/resolving_conflicts)
8. [Basics of Git - The Simple Quick Start Guide](https://blog.praveen.science/basics-of-git-the-quick-start-guide/)
9. [Git Standards followed in our way of Spotify Agile Methodology](https://blog.praveen.science/git-standards-followed-in-our-way-of-spotify-agile-methodolgy/)
10. [Git Shortcuts](https://blog.praveen.science/git-shortcuts/)
11.  [Official Git cheat sheet in many languages](https://services.github.com/on-demand/resources/cheatsheets)
12.  [Git cheat sheet from Tower](https://www.git-tower.com/learn/cheat-sheets/git)
13.  [Common Git Problems](https://www.codementor.io/citizen428/git-tutorial-10-common-git-problems-and-how-to-fix-them-aajv0katd)
14. [Git Rebase](https://blog.gitprime.com/git-rebase-an-illustrated-guide/)
15. [Beginner's Guide to Rebasing and Squashing](https://github.com/servo/servo/wiki/Beginner%27s-guide-to-rebasing-and-squashing)
16. [Git Cheatsheet that shows correlations between commands and files](http://ndpsoftware.com/git-cheatsheet.html)
17. [How to contribute](https://opensource.guide/how-to-contribute/)
18. [Getting started with Open Source](https://github.com/OpenSourceHelpCommunity/Getting-Started-With-Contributing-to-Open-Sources)
19. [How to contribute](https://github.com/freeCodeCamp/how-to-contribute-to-open-source)
20. [Atlassians Git Tutorials](https://www.atlassian.com/git)
21. [Pull request reviews](https://help.github.com/articles/about-pull-request-reviews/)
22. [Another Interactive tutorial for git](https://learngitbranching.js.org/)
23. [Git commandline cheat-sheet](https://gist.github.com/davfre/8313299)
24. [Programming Books](https://github.com/EbookFoundation/free-programming-books)
25. [E-Book of professional tip and secrets](https://goalkicker.com/GitBook/GitProfessionalTipsSecrets.pdf)
26. [tutorial about simple rules of become git professional](https://medium.freecodecamp.org/follow-these-simple-rules-and-youll-become-a-git-and-github-master-e1045057468f)
27. [A Note About Git Commit Messages](https://tbaggery.com/2008/04/19/a-note-about-git-commit-messages.html)
28. [5 Useful Tips For A Better Commit Message](https://thoughtbot.com/blog/5-useful-tips-for-a-better-commit-message)
29. [Version Control using Git](https://ourcodingclub.github.io/2017/02/27/git.html)
30. [Version Control with Git](https://www.udacity.com/course/version-control-with-git--ud123)
31. [Audit the Coursera course from Google](https://www.coursera.org/learn/introduction-git-github)
32. [Using Version Control in VS Code](https://code.visualstudio.com/docs/editor/versioncontrol)
33. [Git vs Github: What's the Difference and How to Get Started with Both](https://kinsta.com/knowledgebase/git-vs-github/)
34. [Hello World Github guides](https://guides.github.com/activities/hello-world/)
35. [How To Use GitHub](https://www.edureka.co/blog/how-to-use-github/)
36. [10 Days of Git and Github](https://github.com/Asabeneh/10-days-of-git-and-github)
37. [Keyboard shortcuts for Github](https://docs.github.com/en/get-started/using-github/keyboard-shortcuts)
38. [Complete Git and GitHub Tutorial by Kunal Kushwaha](https://www.youtube.com/watch?v=apGV9Kg7ics&ab_channel=KunalKushwaha)
39. [Git workflow Cheat Sheet](https://drive.google.com/uc?export=download&id=1QPRh5YmqQm4DFfitelPYlBTWC2I6tTTM)
Keep adding more links, that you find helpful.
