// Code generated by client-gen. DO NOT EDIT.

package v1alpha1

import (
	"context"
	"time"

	v1alpha1 "github.com/argoproj/argo-workflows/v3/pkg/apis/workflow/v1alpha1"
	scheme "github.com/argoproj/argo-workflows/v3/pkg/client/clientset/versioned/scheme"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// WorkflowTaskSetsGetter has a method to return a WorkflowTaskSetInterface.
// A group's client should implement this interface.
type WorkflowTaskSetsGetter interface {
	WorkflowTaskSets(namespace string) WorkflowTaskSetInterface
}

// WorkflowTaskSetInterface has methods to work with WorkflowTaskSet resources.
type WorkflowTaskSetInterface interface {
	Create(ctx context.Context, workflowTaskSet *v1alpha1.WorkflowTaskSet, opts v1.CreateOptions) (*v1alpha1.WorkflowTaskSet, error)
	Update(ctx context.Context, workflowTaskSet *v1alpha1.WorkflowTaskSet, opts v1.UpdateOptions) (*v1alpha1.WorkflowTaskSet, error)
	UpdateStatus(ctx context.Context, workflowTaskSet *v1alpha1.WorkflowTaskSet, opts v1.UpdateOptions) (*v1alpha1.WorkflowTaskSet, error)
	Delete(ctx context.Context, name string, opts v1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error
	Get(ctx context.Context, name string, opts v1.GetOptions) (*v1alpha1.WorkflowTaskSet, error)
	List(ctx context.Context, opts v1.ListOptions) (*v1alpha1.WorkflowTaskSetList, error)
	Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1alpha1.WorkflowTaskSet, err error)
	WorkflowTaskSetExpansion
}

// workflowTaskSets implements WorkflowTaskSetInterface
type workflowTaskSets struct {
	client rest.Interface
	ns     string
}

// newWorkflowTaskSets returns a WorkflowTaskSets
func newWorkflowTaskSets(c *ArgoprojV1alpha1Client, namespace string) *workflowTaskSets {
	return &workflowTaskSets{
		client: c.RESTClient(),
		ns:     namespace,
	}
}

// Get takes name of the workflowTaskSet, and returns the corresponding workflowTaskSet object, and an error if there is any.
func (c *workflowTaskSets) Get(ctx context.Context, name string, options v1.GetOptions) (result *v1alpha1.WorkflowTaskSet, err error) {
	result = &v1alpha1.WorkflowTaskSet{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("workflowtasksets").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do(ctx).
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of WorkflowTaskSets that match those selectors.
func (c *workflowTaskSets) List(ctx context.Context, opts v1.ListOptions) (result *v1alpha1.WorkflowTaskSetList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1alpha1.WorkflowTaskSetList{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("workflowtasksets").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do(ctx).
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested workflowTaskSets.
func (c *workflowTaskSets) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Namespace(c.ns).
		Resource("workflowtasksets").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch(ctx)
}

// Create takes the representation of a workflowTaskSet and creates it.  Returns the server's representation of the workflowTaskSet, and an error, if there is any.
func (c *workflowTaskSets) Create(ctx context.Context, workflowTaskSet *v1alpha1.WorkflowTaskSet, opts v1.CreateOptions) (result *v1alpha1.WorkflowTaskSet, err error) {
	result = &v1alpha1.WorkflowTaskSet{}
	err = c.client.Post().
		Namespace(c.ns).
		Resource("workflowtasksets").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(workflowTaskSet).
		Do(ctx).
		Into(result)
	return
}

// Update takes the representation of a workflowTaskSet and updates it. Returns the server's representation of the workflowTaskSet, and an error, if there is any.
func (c *workflowTaskSets) Update(ctx context.Context, workflowTaskSet *v1alpha1.WorkflowTaskSet, opts v1.UpdateOptions) (result *v1alpha1.WorkflowTaskSet, err error) {
	result = &v1alpha1.WorkflowTaskSet{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("workflowtasksets").
		Name(workflowTaskSet.Name).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(workflowTaskSet).
		Do(ctx).
		Into(result)
	return
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *workflowTaskSets) UpdateStatus(ctx context.Context, workflowTaskSet *v1alpha1.WorkflowTaskSet, opts v1.UpdateOptions) (result *v1alpha1.WorkflowTaskSet, err error) {
	result = &v1alpha1.WorkflowTaskSet{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("workflowtasksets").
		Name(workflowTaskSet.Name).
		SubResource("status").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(workflowTaskSet).
		Do(ctx).
		Into(result)
	return
}

// Delete takes name of the workflowTaskSet and deletes it. Returns an error if one occurs.
func (c *workflowTaskSets) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	return c.client.Delete().
		Namespace(c.ns).
		Resource("workflowtasksets").
		Name(name).
		Body(&opts).
		Do(ctx).
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *workflowTaskSets) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	var timeout time.Duration
	if listOpts.TimeoutSeconds != nil {
		timeout = time.Duration(*listOpts.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Namespace(c.ns).
		Resource("workflowtasksets").
		VersionedParams(&listOpts, scheme.ParameterCodec).
		Timeout(timeout).
		Body(&opts).
		Do(ctx).
		Error()
}

// Patch applies the patch and returns the patched workflowTaskSet.
func (c *workflowTaskSets) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1alpha1.WorkflowTaskSet, err error) {
	result = &v1alpha1.WorkflowTaskSet{}
	err = c.client.Patch(pt).
		Namespace(c.ns).
		Resource("workflowtasksets").
		Name(name).
		SubResource(subresources...).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}
