#
# Copyright (c) 2024. Devtron Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

# shellcheck disable=SC2155
#export TEST_BRANCH=$(echo $TEST_BRANCH | awk -F '/' '{print $NF}')
export LATEST_HASH=`git log --pretty=format:'%H' -n 1`
export TEST_BRANCH=`git name-rev --name-only "$LATEST_HASH" | awk -F '/' '{print $NF}'`
apk update && apk add wget && apk add curl && apk add vim  && apk add bash && apk add git && apk add yq && apk add gcc && apk add musl-dev && apk add make
wget -q -O - https://raw.githubusercontent.com/k3d-io/k3d/main/install.sh | bash
###### check docker is running or not ?? ####

k3d cluster create it-cluster
MACHINE_OS='linux'
MACHINE_ARCH='amd64'
#export MACHINE_OS='darwin'
#export MACHINE_ARCH='arm64'
curl -LO "https://dl.k8s.io/release/$(curl -L -s https://dl.k8s.io/release/stable.txt)/bin/$MACHINE_OS/$MACHINE_ARCH/kubectl"
install -o root -g root -m 0755 kubectl /usr/local/bin/kubectl
kubectl create ns devtroncd
kubectl create ns devtron-cd
kubectl create ns devtron-ci
kubectl -n devtroncd create cm git-hash-cm --from-literal=GIT_HASH=$GIT_HASH
kubectl -n devtroncd apply -f $PWD/tests/integrationTesting/postgresql-secret.yaml
kubectl -ndevtroncd apply -f $PWD/tests/integrationTesting/postgresql.yaml
kubectl -n devtroncd apply -f $PWD/tests/integrationTesting/devtron-secret.yaml
kubectl -n devtroncd apply -f $PWD/tests/integrationTesting/nats-server.yaml
# we are copying sql scripts into node container and this conainer's name is fixed
docker cp $PWD/scripts/sql/ k3d-it-cluster-server-0:./tmp/scripts
yq '(select(.metadata.name == "postgresql-migrate-devtron") | .spec.template.spec.containers[0].env[0].value) = env(TEST_BRANCH)' $PWD/tests/integrationTesting/migrator.yaml -i
yq '(select(.metadata.name == "postgresql-migrate-devtron") | .spec.template.spec.containers[0].env[9].value) = env(LATEST_HASH)' $PWD/tests/integrationTesting/migrator.yaml -i
kubectl -ndevtroncd apply -f $PWD/tests/integrationTesting/migrator.yaml
# shellcheck disable=SC2046
while [ ! $(kubectl -n devtroncd get job postgresql-migrate-devtron -o jsonpath="{.status.succeeded}")  ]; do sleep 10; done
echo "devtron postgres migration completed"
# shellcheck disable=SC2046
while [ ! $(kubectl -n devtroncd get job postgresql-migrate-casbin -o jsonpath="{.status.succeeded}")  ]; do sleep 10; done
echo "casbin postgres migration completed"
# shellcheck disable=SC2046
while [ ! $(kubectl -n devtroncd get job postgresql-migrate-lens -o jsonpath="{.status.succeeded}")  ]; do sleep 10; done
echo "lens postgres migration completed"
# shellcheck disable=SC2046
while [ ! $(kubectl -n devtroncd get job postgresql-migrate-gitsensor -o jsonpath="{.status.succeeded}")  ]; do sleep 10; done
echo "git-sensor postgres migration completed"
#exit #to get out of container

###### Installing Helm #####
echo "Installing Helm"
curl https://raw.githubusercontent.com/helm/helm/master/scripts/get-helm-3 > get_helm.sh
chmod 700 get_helm.sh
./get_helm.sh


###### Installing Argo Dependencies #####
echo "Installing Argo Workflow CRDS"
kubectl create ns argo
cd $PWD/charts/devtron # Make sure path is set correctly
helm dependency up
helm template devtron . --set installer.modules={cicd} -s templates/workflow.yaml >./argo_wf.yaml
kubectl apply -f ./argo_wf.yaml
while [ ! $(kubectl -n argo get deployment workflow-controller -o jsonpath="{.status.readyReplicas}")  ]; do sleep 10; done
cd $PWD
