/*
 * Copyright (c) 2024. Devtron Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package bean

import (
	"encoding/json"
	"github.com/devtron-labs/devtron/internal/sql/repository"
	bean3 "github.com/devtron-labs/devtron/pkg/pipeline/bean"
)

type CiArtifactWebhookRequest struct {
	Image                         string                         `json:"image" validate:"required"`
	ImageDigest                   string                         `json:"imageDigest"`
	MaterialInfo                  json.RawMessage                `json:"materialInfo"`
	DataSource                    repository.ArtifactsSourceType `json:"dataSource" validate:"oneof=CI-RUNNER EXTERNAL pre_cd post_cd post_ci GOCD"`
	PipelineName                  string                         `json:"pipelineName"`
	WorkflowId                    *int                           `json:"workflowId"`
	UserId                        int32                          `json:"userId"`
	IsArtifactUploaded            bool                           `json:"isArtifactUploaded"`
	FailureReason                 string                         `json:"failureReason"`                 // FailureReason is used for notifying the failure reason to the user. Should be short and user-friendly
	PluginRegistryArtifactDetails map[string][]string            `json:"PluginRegistryArtifactDetails"` //map of registry and array of images generated by Copy container image plugin
	PluginArtifactStage           string                         `json:"pluginArtifactStage"`           // at which stage of CI artifact was generated by plugin ("pre_ci/post_ci")
	IsScanEnabled                 bool                           `json:"isScanEnabled"`
}

const (
	ImageScanningPluginToCheckInPipelineStageStep = bean3.VULNERABILITY_SCANNING_PLUGIN
)
