import React from "react";

function CodeOfConduct() {
  return (
    <section className="bg-white-smoke lg:flex-row px-4 lg:px-40 pt-2">
      <div className="flex flex-wrap">
        <div className="mb-4 w-full text-dark-blue-primary-600">
          <h1 className="text-h4 font-bold font-century">Expected Behaviours</h1>
          <p className="text-base my-4">
            DevCon Zambia strives on being a healthy community! Part of being a community is to set standards on how we
            make our events and surrounding communication an inclusive, judgement and harassment-free place for
            individuals regardless of background or experience.
          </p>
          <p class="text-base my-4">
            We aim to make sure that our community is a safe place to learn, connect, and grow together. This Code of
            Conduct applies to all events run by DevCon Zambia, including any self-organised events derived from our
            events. We also expect the same code of conduct to carry through to any other medium that relates to DevCon
            Zambia, for example, social media, blogs, forums and chat services.
          </p>
          <p class="text-base my-4">
            To prevent conflict and to create a safe and engaging atmosphere; all attendees, sponsors, speakers,
            vendors, volunteers, staff and organisers shall:
          </p>
          <h5 className="text-h5 font-bold font-century">Be kind and considerate</h5>
          <p class="text-base my-4">
            Approach any interaction with consideration. Communication and discussions should be friendly and welcoming
            and not exclusive to anyone of different backgrounds, experience, or opinion.
          </p>
          <h5 className="text-h5 font-bold font-century">Be respectful</h5>
          <p class="text-base my-4">
            Poor manners and attitude are never an excuse. Always treat others with the most utmost respect, and be
            welcoming to everyone. Do not speak ill of others in any environment or situation.
          </p>
          <h5 className="text-h5 font-bold font-century">Own responsibility</h5>
          <p class="text-base my-4">
            Your actions are your own, think carefully about your choices and act in a responsible manner. We all make
            mistakes, own up to those mistakes and apologise if you feel you may have harmed or offended others. Work to
            make the wrong right.
          </p>
          <h4 className="text-h4 font-bold font-century">Anti-Harassment Policy</h4>
          <p class="text-base my-4">
            Our events and communication mediums are dedicated to providing a harassment-free experience for everyone,
            regardless of background or experience. Including but not limited to gender, gender identity and expression,
            age, sexual orientation, disability, physical appearance, body size, race, ethnicity, religion (or lack
            thereof), or technology choices.
          </p>
          <p class="text-base my-4">
            We do not tolerate harassment of conference participants in any form. You are obliged to refrain from
            content and imagery that may offend in any context; including talks, sponsor material, workshops, parties,
            social media, and chat channels. Conference participants violating these rules may be sanctioned or expelled
            from the conference without a refund at the discretion of the conference organisers.
          </p>
          <p class="text-base my-4">Harassment includes, but is not limited to:</p>
          <ul className="list-no lg:list-disc my-2">
            <li>
              Sharing or engaging in content including but not limited to verbal, written, image and videos that are
              deemed offensive related to gender, gender identity and expression, sexual orientation, disability,
              physical appearance, body size, race, age, or religion
            </li>
            <li>Deliberate intimidation, stalking, or following</li>
            <li>Harassing photography or recording</li>
            <li>Sustained disruption</li>
            <li>Unwelcome attention</li>
            <li>Advocating for, or encouraging, any of the above behaviours</li>
          </ul>
          <p class="text-base my-4">We will not act on complaints regarding:</p>
          <ul className="list-no lg:list-disc my-2">
            <li>
              ‘Reverse’ -isms, including ‘reverse racism,’ ‘reverse sexism,’ and ‘cisphobia’ (because these things don’t
              exist)
            </li>
            <li>
              Reasonable communication of boundaries, such as “leave me alone,” “go away,” or “I’m not discussing this
              with you.”
            </li>
            <li>Refusal to explain or debate social justice concepts</li>
            <li>Communicating in a ‘tone’ you don’t find congenial</li>
            <li>Criticising racist, sexist, cissexist, or otherwise oppressive behaviour or assumptions</li>
          </ul>
          <h4 className="text-h4 font-bold font-century">Diversity Policy</h4>
          <p class="text-base my-4">
            Diversity and self-expression are essential. Therefore, we encourage all attendees to identify and express
            how they wish, including the use of any facilities they feel most comfortable in, regardless of gender
            expression. Please do not question someones use of facilities, as they know and are conscious of where they
            are. If you witness someone being made to feel unwelcome, or someone makes you feel unwelcome while using
            any facilities, please reach out to a conference staff member so we can assist you.
          </p>
          <h4 className="text-h4 font-bold font-century">Reporting</h4>
          <p class="text-base my-4">
            Before filing a report please ensure that you are safe. If you are at event you can always contact any venue
            staff member, well-known figure (speaker), security or organisers to ask for assistance. Your safety is of
            utmost importance.
          </p>
          <p class="text-base my-4">
            If you experience or witness unacceptable behaviour—or have any other concerns—please report it by
            contacting any of the following:
          </p>
          <ul className="list-no lg:list-disc my-2">
            {" "}
            {/* more contact info can be added here later */}
            <li>
              Email:{" "}
              <a className="underline" href="mailto:info@devcon.co.zm" title="email">
                info@devcon.co.zm
              </a>
            </li>
          </ul>
          <p class="text-base my-4">
            All reports will be handled with discretion - we will not disclose any information that can be used to
            identify you without prior consent. In your report please include:
          </p>
          <ul className="list-no lg:list-disc my-2">
            <li>Your contact information</li>
            <li>Names (real, nicknames, or pseudonyms) of any individuals involved, if they are known to you.</li>
            <li>If there are additional witnesses, please include their details as well.</li>
            <li>Your account of what occurred, and if you believe the incident is ongoing.</li>
            <li>Any additional information that may be helpful.</li>
          </ul>
          <p class="text-base my-4">
            After filing a report, a representative will contact you personally, review the incident, follow up with any
            additional questions, and make a decision as to how to respond. If the person who is harassing you is part
            of the response team, they will recuse themselves from handling your incident. If the complaint originates
            from a member of the response team, it will be handled by a different member of the response team. We will
            respect confidentiality requests for the purpose of protecting victims of abuse.
          </p>
          <h4 className="text-h4 font-bold font-century">Enforcement</h4>
          <p class="text-base my-4">
            Adherence to and acceptance of this Code of Conduct is a condition to any event, including those derived
            from main events such as group dinners.
          </p>
          <p class="text-base my-4">
            Participants asked to stop any harassing behaviour are expected to comply immediately. This includes all
            attendees, sponsors, speakers, organisers, volunteers, and venue or vendor staff.
          </p>
          <p class="text-base my-4">
            If a participant engages in harassing behaviour before, during or after an event, event organisers retain
            the right to take any actions to keep the event a welcoming environment for all participants. This includes,
            but is not limited to, warning the offender, expulsion from the conference without the possibility for
            refund, and a ban on attending future events. If behaviour is associated to be criminal based on local laws
            we include the right to inform any law enforcement of the report.
          </p>
          <h4 className="text-h4 font-bold font-century">Contact Us</h4>
          <p class="text-base my-4">
            If you have any questions about the code of conduct, please contact us at{" "}
            <a className="underline" href="mailto:info@devcon.co.zm" title="email">
              info@devcon.co.zm
            </a>
          </p>
        </div>
      </div>
    </section>
  );
}

export default CodeOfConduct;
