**Thanks for taking the time to contribute! ❤️**

All types of contributions are encouraged and valued, no matter if it's a bug
report 🐛, a feature request 💡, or a Pull Request 🚀.

- **❓ I have a question:** Ask in [our dev container community Slack channel]
- **🐛 I found a bug:** [Open an Issue]
- **💡 I have an idea:** [Open an Issue]
- **💻 I want to code:** See below

If you like the project, but just don't have time to contribute, that's OK too!
You can also star the project ⭐, rave about it online 💬, or add a link to us
🔗 in your project's readme.

⚠️ You must never report security 🔒 related issues, vulnerabilities or bugs
including sensitive information to the issue tracker, or elsewhere in public.
Instead, please [report them to the Microsoft Security Response Center]. You can
read more about our security policy in [`SECURITY.md`].

## Contributing code

👨‍💼 This repository is a collection of dev container Features managed by dev
container spec maintainers. This repository will **only accept improvements and
bug fixes** for the [current set of maintained Features].

🚀 If you're looking to create a new Feature, then we encourage adding it to a
separate repository of your control. The [devcontainers/feature-starter]
repository has more guidance on self authoring Features.

💡 Once you've self authored the Features and if you'd like to share them with
the community, then we'd recommend [adding it to the index].

👷‍ If you've identified an issue and you want to fix it, here's how you can get
started:

1. 🔀 Fork the repo
2. 💻 Open the repo in your editor
3. 👨‍💻 Add your changes to your workspace
4. ✨ [Test your changes using `devcontainer features test`] to make sure
   everything still works
5. 🆚 Bump the version of the feature you changed according to [semver]
6. 🔖 Commit & push your changes
7. 🔁 Open a PR to get your changes merged
8. 🚀 Profit!

👩‍⚖️ When contributing code to this project, you may be asked to agree to our
[Contributor License Agreement].

<!-- prettier-ignore-start -->
[our dev container community Slack channel]: https://aka.ms/devcontainer_community
[open an issue]: https://github.com/devcontainers/features/issues/new
[current set of maintained Features]: https://github.com/devcontainers/features/tree/main/src
[devcontainers/feature-starter]: https://github.com/devcontainers/feature-starter#readme
[adding it to the index]: https://github.com/devcontainers/feature-starter#adding-features-to-the-index
[report them to the Microsoft Security Response Center]: https://msrc.microsoft.com/create-report
[`SECURITY.md`]: https://github.com/devcontainers/spec/blob/main/SECURITY.md
[contributor license agreement]: https://opensource.microsoft.com/cla/
[Test your changes using `devcontainer features test`]: https://github.com/devcontainers/cli/blob/main/docs/features/test.md
[semver]: https://semver.org/
<!-- prettier-ignore-end -->
