const types = ['class', 'interface', 'type-alias', 'markdown', 'const', 'demo-source'];

module.exports = function filterUnusedDocs() {
  return {
    name: 'filterUnusedDocs',
    $runAfter: ['docs-processed'],
    $runBefore: ['adding-modules'],
    $process(docs) {
      const tokenRegExp = /^\s*new\s+InjectionToken/;
      return docs.filter(doc => types.indexOf(doc.docType) !== -1
        && (doc.docType !== 'const' || tokenRegExp.test(doc.type)));
    },
  };
};
