module.exports = {
  'extends': 'eslint:recommended',
  'parserOptions': {
    'ecmaVersion': 2018,
    'sourceType': 'module'
  },
  'env': {
    'es6': true,
    'node': true
  },
  'rules': {
    'indent': ['error', 2],
    'linebreak-style': ['error', 'unix'],
    'quotes': ['error', 'single'],
    'comma-dangle': ['error', 'always-multiline'],
    'array-bracket-newline': ['error', {'multiline': true}],
    'array-bracket-spacing': ['error', 'never'],
    'arrow-parens': ['error', 'as-needed', {'requireForBlockBody': true}],
    'arrow-spacing': 'error',
    'no-var': 'error',
    'block-spacing': 'error',
    'brace-style': 'error',
    'callback-return': 'error',
    'camelcase': 'error',
    'comma-spacing': 'error',
    'comma-style': ['error', 'last'],
    'computed-property-spacing': 'error',
    'curly': 'error',
    'default-case': 'error',
    'dot-location': ['error', 'property'],
    'dot-notation': ['error', {'allowKeywords': false}],
    'eol-last': ['error', 'always'],
    'eqeqeq': ['error', 'always'],
    'for-direction': 'error',
    'func-call-spacing': ['error', 'never'],
    'function-paren-newline': ['error', 'multiline'],
    'generator-star-spacing': ['error', 'before'],
    'implicit-arrow-linebreak': ['error', 'beside'],
    'key-spacing': 'error',
    'keyword-spacing': 'error',
    'max-depth': ['error', 4],
    'max-len': [
      'error',
      {
        'code': 120,
        'ignoreComments': true,
        'ignoreTrailingComments': true,
        'ignoreUrls': true,
        'ignoreStrings': true,
        'ignoreTemplateLiterals': true,
      }
    ],
    'max-nested-callbacks': ['error', 3],
    'multiline-ternary': ['error', 'always-multiline'],
    'operator-linebreak': ['error', 'before', {'overrides': {'?': 'ignore', ':': 'ignore'}}],
    'new-parens': 'error',
    'no-array-constructor': 'error',
    'no-buffer-constructor': 'error',
    'no-caller': 'error',
    'no-confusing-arrow': ['error', {'allowParens': true}],
    'no-continue': 'error',
    'no-else-return': ['error', {allowElseIf: false}],
    'no-empty-function': 'error',
    'no-eq-null': 'error',
    'no-eval': 'error',
    'no-extra-label': 'error',
    'no-floating-decimal': 'error',
    'no-implicit-coercion': ['error', {'allow': ['!!']}],
    'no-implied-eval': 'error',
    'no-labels': 'error',
    'no-lone-blocks': 'error',
    'no-lonely-if': 'warn',
    'no-loop-func': 'error',
    'no-magic-numbers': ['warn', {'ignore': [-1, 0, 1], 'ignoreArrayIndexes': true}],
    'no-multi-spaces': 'error',
    'no-multiple-empty-lines': ['error', {'max': 1}],
    'no-new-func': 'error',
    'no-new-object': 'error',
    'no-new-require': 'error',
    'no-new-wrappers': 'error',
    'no-octal-escape': 'warn',
    'no-param-reassign': ['error', {'props': false}],
    'no-path-concat': 'warn',
    'no-proto': 'error',
    'no-return-assign': ['error', 'except-parens'],
    'no-self-compare': 'error',
    'no-sequences': 'error',
    'no-shadow': 'error',
    'no-shadow-restricted-names': 'error',
    'no-sync': 'warn',
    'no-tabs': 'warn',
    'no-template-curly-in-string': 'warn',
    'no-throw-literal': 'warn',
    'no-trailing-spaces': 'error',
    'no-undef-init': 'error',
    'no-unmodified-loop-condition': 'warn',
    'no-unneeded-ternary': ['error', {'defaultAssignment': false}],
    'no-unused-expressions': 'error',
    'no-use-before-define': 'error',
    'no-useless-call': 'warn',
    'no-useless-computed-key': 'error',
    'no-useless-concat': 'error',
    'no-useless-constructor': 'error',
    'no-useless-rename': 'error',
    'no-useless-return': 'error',
    'no-void': 'warn',
    'no-whitespace-before-property': 'error',
    'no-with': 'error',
    'object-curly-newline': ['error', {'consistent': true}],
    'object-curly-spacing': ['error', 'never'],
    'object-property-newline': 'error',
    'object-shorthand': 'error',
    'one-var-declaration-per-line': ['error', 'always'],
    'padded-blocks': ['error', 'never'],
    'prefer-arrow-callback': 'error',
    'prefer-const': 'error',
    'prefer-destructuring': ['error', {
      'VariableDeclarator': {
        'array': false,
        'object': true,
      },
      'AssignmentExpression': {
        'array': true,
        'object': false,
      }
    }],
    'prefer-promise-reject-errors': 'error',
    'prefer-rest-params': 'error',
    'prefer-spread': 'error',
    'prefer-template': 'error',
    'quote-props': ['error', 'consistent-as-needed'],
    'radix': 'error',
    'require-await': 'error',
    'rest-spread-spacing': ['error', 'never'],
    'semi': ['error', 'always'],
    'semi-spacing': 'error',
    'semi-style': ['error', 'last'],
    'space-before-blocks': ['error', 'always'],
    'space-before-function-paren': ['error', 'never'],
    'space-in-parens': ['error', 'never'],
    'space-infix-ops': 'error',
    'space-unary-ops': 'error',
    'spaced-comment': ['error', 'always'],
    'strict': ['error', 'safe'],
    'switch-colon-spacing': ['error'],
    'symbol-description': 'error',
    'template-curly-spacing': ['error', 'never'],
    'template-tag-spacing': ['error', 'always'],
    'wrap-iife': ['error', 'outside'],
    'yield-star-spacing': ['error', 'before'],
    'yoda': 'error'
  }
};
