import type { NextPage } from 'next'
import Image from 'next/image'
import Head from 'next/head'
import { Button, Divider, CircularProgress } from '@mui/material';
import styles from '../styles/Home.module.css'
import { useState } from 'react'
import RotateLeftIcon from '@mui/icons-material/RotateLeft';
import { apiBaseUrl } from '../env';

const Home: NextPage = () => {
  const [messageForHide, setMessageForHide] = useState<string>('')
  const [imageForHide, setImageForHide] = useState<string | Blob>('')
  const [resultImageUrl, setResultImageUrl] = useState<string | undefined>(undefined)
  const [hideInProgress, setHideInProgress] = useState<boolean>(false)
  const [seekInProgress, setSeekInProgress] = useState<boolean>(false)
  const [resultImageBlob, setResultImageBlob] = useState<Blob | undefined>(undefined)
  const [imageForSeek, setImageForSeek] = useState<string | Blob>('')
  const [extractedMessage, setExtractedMessage] = useState<string | undefined>(undefined)

  const resetState = () => {
    const hideInput = window.document.getElementById('contained-button-file-for-hide') as HTMLInputElement
    const seekInput = window.document.getElementById('contained-button-file-for-seek') as HTMLInputElement
    if (resultImageUrl) window.URL.revokeObjectURL(resultImageUrl)
    if (hideInput) hideInput.value = ''
    if (seekInput) seekInput.value = ''
    setMessageForHide('')
    setImageForHide('')
    setResultImageUrl(undefined)
    setResultImageBlob(undefined)
    setImageForSeek('')
    setExtractedMessage(undefined)
    setHideInProgress(false)
    setSeekInProgress(false)
    window.alert("Now, we're back to the past!")
  }

  const checkState = () => {
    if (messageForHide || imageForHide ||  resultImageUrl || resultImageBlob || imageForSeek || extractedMessage)
      return true
    return false
  }

  const handleHideMessageChange = (e: any) => {
    setMessageForHide(e.target.value)
  }
  const handleHideImageChange = (e: any) => {
    setImageForHide(e.target.files[0])
  }

  const handleHide = async (e: any) => {
    e.preventDefault()
    setHideInProgress(true)
    let formData = new FormData()
    formData.append('file', imageForHide)
    formData.append('message', messageForHide)
    const response = await fetch(`${apiBaseUrl}/hide`, {
      method: 'POST',
      body: formData
    })
    const reader = response.body!.getReader()
    let uint8array: Uint8Array = new Uint8Array()
    let notEmpty = true
    while (notEmpty) {
      const { value: uint8arrayChunk } = await reader.read()
      if (uint8arrayChunk != undefined){
        uint8array = new Uint8Array([...uint8array, ...uint8arrayChunk])
      } else {
        notEmpty = false
      }
    }
    // Get from client side
    if (uint8array !== undefined){
      const myBlob = new Blob([uint8array], { type: 'image/png' })
      setResultImageBlob(myBlob)
      const url = URL.createObjectURL(myBlob)
      setResultImageUrl(url)
      setHideInProgress(false)
      const now = new Date().toISOString().slice(0, 19).replace(/-/g, '').replace(/:/g, '').replace(/T/g, '')
      let link = document.createElement('a')
      link.download = `${now}-d3fau1t.png`
      link.href = url
      link.click()
    }
  }

  const passImageToSeekMessage = () => {
    const now = new Date().toISOString().slice(0, 19).replace(/-/g, '').replace(/:/g, '').replace(/T/g, '')
    if (resultImageBlob)
      setImageForSeek(new File([resultImageBlob], __filename=`${now}-d3fau1t.png`))
    // setImageForSeek(new File(resultImageBlob, "blob.png"))
  }

  const handleSeekImageChange = (e: any) => {
    setImageForSeek(e.target.files[0])
  }

  const handleResultImage = (e: any) => {
    setResultImageUrl(e.target.files[0])
  }

  const handleSeek = async (e: any) => {
    e.preventDefault()
    setSeekInProgress(true)
    setExtractedMessage("If it's taking too long, it's likely that the hidden message doesn't exist.")
    let formData = new FormData()
    formData.append('file', imageForSeek)
    const response = await fetch(`${apiBaseUrl}/seek`, {
      method: 'POST',
      body: formData
    }).then(res => res.json())
    .then(data => {
      setSeekInProgress(false)
      setExtractedMessage(data.message)
    })
  }

  return (
    <div className={styles.container}>
      <Head>
        <title>Steganography</title>
        <meta name="description" content="Generated by create next app" />
        <link rel="icon" href="/favicon.ico" />
      </Head>
      <main className={styles.main}>
        { checkState() ? <RotateLeftIcon onClick={resetState} /> : <></>}
        <h1>Hide</h1>
        <form onSubmit={handleHide} style={{width:'100%'}}>
          <div>
            <label htmlFor="contained-button-file-for-hide">
              <input style={{visibility:'hidden'}} accept=".jpg, .jpeg, .png, .bmp" id="contained-button-file-for-hide" multiple type="file" onChange={handleHideImageChange} />
              <Button style={{width: '100%', backgroundColor: imageForHide ? '#03fca9' : '#282029', color: imageForHide ? '#000000' : '#ffffff', marginBottom: '3vw'}} variant="contained" component="span">
                { imageForHide ? "Good, type your message" : 'Choose image to hide message'}
              </Button>
            </label>
            <textarea style={{width:'100%'}} id="message" name="message" rows={10} cols={50} placeholder="type what you wanna hide" value={messageForHide} onChange={handleHideMessageChange}/>
          </div>
          <div style={{textAlign:'center'}}>
            <Button
              onClick={handleHide}
              style={{
                width: resultImageUrl ? '49%' : '100%',
                marginRight: resultImageUrl ? '1%' : 'none'
              }}
              disabled={
                imageForHide ?
                  messageForHide ?
                    hideInProgress ? true : false
                  : true
                : true
              }
              variant="contained"
              component="span">
                Submit
            </Button>
            { resultImageUrl ? <Button variant="contained" style={{width: '49%', marginLeft: resultImageUrl ? '1%' : 'none'}} onClick={passImageToSeekMessage}>Use this</Button> : <Button style={{visibility:'hidden'}} /> }
          </div>
          <div style={{
            textAlign:"center",
            display: hideInProgress === true
              && resultImageUrl === undefined
              ? "block" :"none",
            }}>
            <CircularProgress />
          </div>
          <div style={{textAlign:"center", display: resultImageUrl ? "block" :"none" }}>
            <h2>Result</h2>
            { resultImageUrl ? <Image src={resultImageUrl} alt={'result image'} width={80} height={80} /> : <></> }
          </div>
        </form>
        <Divider style={{width:'100%', marginTop:'1.8em'}} />
        
        <h1>Seek</h1>
        <form onSubmit={handleSeek} style={{width:'100%'}}>
          <div>
            
            <label htmlFor="contained-button-file-for-seek">
              <input style={{visibility:'hidden'}} accept=".jpg, .jpeg, .png, .bmp" id="contained-button-file-for-seek" multiple type="file" onChange={handleSeekImageChange} />
              <Button style={{width:'100%', backgroundColor: imageForSeek ? '#03fca9' : '#282029', color: imageForSeek ? '#000000' : '#ffffff', marginBottom: '3vw'}} variant="contained" component="span">
                { imageForSeek ? "Good, let's dig in" : 'Choose image to seek message'}
              </Button>
            </label>
            <label htmlFor="seek-message">{ imageForSeek ? 'Your message is ...' : 'Waiting ...' }</label> <div style={{display: seekInProgress === true ? 'block' : 'none'}}><CircularProgress /> </div> <br />
            <p id="seek-message">{extractedMessage}</p>
          </div>
          <div>
            <Button
              onClick={handleSeek}
              style={{width:'100%'}}
              disabled={
                imageForSeek ?
                  seekInProgress ? true : false
                : true
              }
              variant="contained"
              component="span">
                Submit
            </Button>
          </div>
        </form>
      </main>
      <footer className={styles.footer}>
        D3fau1t: Steganography Web
      </footer>
    </div>
  )
}

export default Home
