![quantum_banner](https://user-images.githubusercontent.com/95103224/196238693-cbbf73a3-4b01-4a9c-98f7-a4a8de7cc52a.gif)

# ℚ𝕦𝕒𝕟𝕥𝕦𝕞

## :feet: Getting started

| name | description |
|:---------------------------------------|:--------------------------------------------------|
| <a href = "https://qiskit.org " alt = "[qiskit.org]">Qiskit</a>| open-source SDK for working with quantum computers|
| <a href="https://lab.quantum-computing.ibm.com" alt = "lab.quantum-computing.ibm.com">IBM Quantum</a> | cloud-enabled Jupyter notebook environment        |

## :jigsaw: Interactive websites & apps

| name | description |
|:------------------------------|:-----------|
| Quantum Flytrap <a href= "https://quantumflytrap.com" alt= "[quantumflytrap.com]">[1]</a> <a href= "https://lab.quantumflytrap.com" alt = "[lab.quantumflytrap.com]">[2]</a> | no-code IDE for Quantum Computing |
| <a href = "https://helloquantum.mybluemix.net" alt = "[helloquantum.mybluemix.net]">Hello Quantum App</a> | puzzle game designed to teach introductory principles of quantum computing |
| <a href="https://qplaylearn.com" alt = "[qplaylearn.com]">QPlayLearn</a> | interactive tools to make the learning process more effective and fun |

## :desktop_computer: Websites

| name | description |
|:--------------|:-----------|
| <a href="https://qworld.net" alt="[qworld.net]">QWorld</a> <a href="https://gitlab.com/qworld" alt="[gitlab.com/qworld]">(GitLab)</a>  | non-profit global organization that brings quantum computing researchers & enthusiasts together |
| <a href = "https://qosf.org" alt = "[qosf.org]">Quantum Open Source Foundation</a> | supporting the development and standardization of open tools for quantum computing |
| <a href = "https://quantumalgorithmzoo.org/" alt="[quantumalgorithmzoo.org]">Quantum Algorithm Zoo</a> | comprehensive catalog of quantum algorithms with links for more information |
| <a href = "https://openquantumsafe.org/" alt = "[openquantumsafe.org]">Open Quantum Safe</a> | open-source project supporting the development of quantum-resistant cryptography |
| <a href= "https://qureca.com/education/" alt = "[qureca.com/education/]">QURECA Education</a> | list of online educational resources to help enhance quantum knowledge |
| <a href="https://www.qaif.org/home" alt="[qaif.org/home]"> Quantum AI Foundation</a> | charity organization, focus on new technologies (Artificial Intelligence and Quantum Computing) |

## :books: Books, Notes, Papers & Other

| name                                 | author(s)          |
|:-------------------------------------|:-------------------|
| <a href = "https://csis.pace.edu/~ctappert/cs837-19spring/QC-textbook.pdf" alt = "[csis.pace.edu/~ctappert/cs837-19spring/QC-textbook.pdf]">Quantum Computation and Quantum Information</a>| Michael A. Nielsen, Isaac L. Chuang |
| <a href = "http://www.stat.ucla.edu/~ywu/linear.pdf" alt = "[www.stat.ucla.edu/~ywu/linear.pdf]">The Mathematics of Quantum Mechanics</a> | Martin Laforest, PhD |
| <a href = "https://www.fi.muni.cz/usr/gruska/qbook1.pdf" alt = "[www.fi.muni.cz/usr/gruska/qbook1.pdf]">Quantum Computing</a>             |         Jozef Gruska |
| <a href = "https://library.oapen.org/bitstream/id/bbd21fd2-1c26-4467-98e7-e20519f2185f/9783030616014.pdf" alt ="[library.oapen.org/bitstream/id/bbd21fd2-1c26-4467-98e7-e20519f2185f/9783030616014.pdf]">Quantum Computing for the Quantum Curious</a> | Joshua Isaacson, Ciaran Hughes, Anastasia Perry, Jessica Turner, Ranbel F. Sun |
| <a href = "https://github.com/dmvaldman/library/blob/master/computer%20science/Aaronson%20-%20Quantum%20Computing%20Since%20Democritus.pdf" alt = "[github.com/dmvaldman/library/blob/master/computer%20science/Aaronson%20-%20Quantum%20Computing%20Since%20Democritus.pdf]">Quantum Computing since Democritus</a> | Scott Aaronson |
| <a href = "https://www.lorentz.leidenuniv.nl/quantumcomputers/literature/preskill_1_to_6.pdf" alt = "[www.lorentz.leidenuniv.nl/quantumcomputers/literature/preskill_1_to_6.pdf]">Lecture Notes for Physics 229: Quantum Information and Computation | John Preskill, Caltech |
| <a href = "http://webéducation.com/wp-content/uploads/2018/07/In-Search-of-Schr%C3%B6dingers-Cat.pdf" alt = "[webéducation.com/wp-content/uploads/2018/07/In-Search-of-Schr%C3%B6dingers-Cat.pdf]">In Search Of Schrodinger's Cat</a> | John Gribbin |
| <a href="https://superstrings.notion.site/Exploring-Quantum-Theory-with-Qubits-a4b99196fcdf4dceb3f7f4e96d6f00f2" alt="[superstrings.notion.site/Exploring-Quantum-Theory-with-Qubits-a4b99196fcdf4dceb3f7f4e96d6f00f2]">Exploring Quantum Theory with Qubits</a> | Kristina P., Denisa V., Berenika Z. & Subhroneel C.

## :mortar_board: Courses & Lectures

| name           | description                                                                  |
|:---------------|:-----------------------------------------------------------------------------|
| <a href="https://www.qubitbyqubit.org" alt = "[qubitbyqubit.org]">Qubit by Qubit</a> | year-long global quantum computing course for high school students and above |
| <a href = "https://uwaterloo.ca/institute-for-quantum-computing/qsys" alt = "[uwaterloo.ca/institute-for-quantum-computing/qsys]">Quantum School for Young Students</a> | hybrid summer program to teach high school students about quantum information |
| <a href = "https://open.hpi.de/courses/qc-machineLearning2023" alt = "[open.hpi.de/courses/qc-machineLearning2023]">Quantum Machine Learning</a> with @[IBM Quantum Research](https://research.ibm.com/quantum-computing) | Advanced, Big Data and AI, Quantum Computing,, January 11, 2023 - January 25, 2023 |
| <a href ="https://ocw.mit.edu/search/?q=quantum+computing" alt = "[ocw.mit.edu/search/?q=quantum+computing]">OpenCourseWare courses</a> | Quantum Computation, Quantum Theory, Quantum Physics and more |
| Fundamentals of Quantum Computing <a href = "https://trainingportal.linuxfoundation.org/learn/course/fundamentals-of-quantum-computing-lfq101/understanding-quantum-computing/overview-of-technology" alt = "[trainingportal.linuxfoundation.org/learn/course/fundamentals-of-quantum-computing-lfq101]">(LFQ101)</a> | short quantum computing course, including security advantages and danger |
| <a href = "https://cognitiveclass.ai/courses/course-v1:IBM+QC0101EN+v1" alt="[cognitiveclass.ai]">Introduction to Quantum Computing</a> | very basic course teaching about superposition, entanglement, and uncertainty |
| <a href="http://theory.caltech.edu/~preskill/ph219/ph219_2021-22.html" alt = "[theory.caltech.edu/~preskill/ph219/ph219_2021-22.html]">Ph219/CS219 Quantum Computation</a> | taught by John Preskill, Caltech |
| <a href="https://open.hpi.de/courses?q=&channel=&lang=&topic=Quantum+Computing&level=" alt = "[https://open.hpi.de/courses]">OpenHPI courses</a> | courses in German and English |

## :trophy: Challenges
| name                | description                                               |
|:--------------------|:----------------------------------------------------------|
| <a href="https://github.com/qosf/monthly-challenges" alt = "[github.com/qosf/monthly-challenges]">QOSF Monthly Challenges</a> | monthly challenges in the field of quantum computing |
| <a href="https://www.quantumcomputingchallenge.com/" alt="[quantumcomputingchallenge.com]">QPARC Challenge 2022</a> | past challenge focused on quantum chemistry and material development |

## Repos
| name | user | description |
|:-----|:-----|:------------|
| <a href="https://gitlab.com/users/qkitchen/projects" alt="[gitlab.com/users/qkitchen/projects]">Quantum Repo</a> | @qkitchen | quantum projects on GitLab |
