export interface Props extends React.HTMLProps<HTMLElement> {
	className?: string;
	fill?: string;
}

export const Logo: React.FC<Props> = ({ className }) => {
	return (
		<svg
			width="20"
			height="20"
			viewBox="0 0 200 200"
			fill="none"
			xmlns="http://www.w3.org/2000/svg"
			className={className}
		>
			<path
				d="M143.247 100.548C154.09 104.751 164.044 112.055 165.636 121.546C167.301 131.009 160.604 142.659 150.922 151.367C141.241 160.075 128.575 165.842 113.705 167.658C98.7615 169.501 81.5176 167.361 76.4589 158.862C71.4491 150.274 78.6485 135.389 86.121 123.58C93.5207 111.799 101.29 103.126 111.017 99.2784C120.743 95.4306 132.428 96.4077 143.247 100.548Z"
				fill="#E41E3D"
			/>
			<path
				d="M156.549 60.4973C154.169 68.7419 149.168 76.8135 143.696 78.9744C138.208 81.1663 132.249 77.4474 130.024 69.9967C127.778 62.535 129.284 51.3106 134.624 44.9354C139.985 38.5713 149.198 37.0254 153.934 40.4457C158.67 43.8661 158.928 52.2527 156.549 60.4973Z"
				fill="#E41E3D"
			/>
			<path
				d="M24.2391 130.809C26.7312 124.719 36.0888 121.294 46.4531 121.277C56.8216 121.314 68.2474 124.697 69.7762 130.956C71.2797 137.246 62.9073 146.326 54.7002 150.698C46.4931 155.07 38.4765 154.702 32.2942 150.125C26.1161 145.602 21.7428 136.845 24.2391 130.809Z"
				fill="#FFBA13"
			/>
			<path
				d="M80.9476 95.9041C80.1508 103.324 66.463 107.052 53.5417 105.72C40.6204 104.387 28.4249 98.0602 23.8444 90.0242C19.219 81.9605 22.1882 72.2209 29.1276 67.992C36.0018 63.7686 46.9115 65.0504 58.336 71.2224C69.7604 77.3943 81.7893 88.5117 80.9476 95.9041Z"
				fill="#E41E3D"
			/>
			<path
				d="M107.41 32.2444C115.685 40.5749 118.21 55.541 116.268 67.2382C114.299 78.9547 107.863 87.3417 100.014 85.5458C92.1364 83.7691 82.9011 71.771 77.8159 59.2358C72.7871 46.7229 71.9654 33.7557 78.5664 28.059C85.1396 22.3815 99.1356 23.9745 107.41 32.2444Z"
				fill="#E41E3D"
			/>
		</svg>
	);
};

export const Browser = () => {
	return (
		<svg xmlns="http://www.w3.org/2000/svg" viewBox="70 100 360 280">
			<g>
				<path
					d="M313,109.94h-53.3a9.35,9.35,0,0,0-8.7,5.93l-4.75,12h80.21l-4.75-12A9.35,9.35,0,0,0,313,109.94Z"
					style={{ fill: "#292929" }}
				/>
				<path
					d="M313,109.94h-53.3a9.35,9.35,0,0,0-8.7,5.93l-4.75,12h80.21l-4.75-12A9.35,9.35,0,0,0,313,109.94Z"
					style={{ fill: "#fff", opacity: 0.4 }}
				/>
				<path
					d="M161.68,109.94h-53.3a9.36,9.36,0,0,0-8.71,5.93l-4.75,12h80.22l-4.75-12A9.36,9.36,0,0,0,161.68,109.94Z"
					style={{ fill: "#555555" }}
				/>
				<path
					d="M161.68,109.94h-53.3a9.36,9.36,0,0,0-8.71,5.93l-4.75,12h80.22l-4.75-12A9.36,9.36,0,0,0,161.68,109.94Z"
					style={{ opacity: 0.2 }}
				/>
				<path
					d="M406.73,126.55H250.28l-4.22-10.68a9.37,9.37,0,0,0-8.71-5.93h-53.3a9.35,9.35,0,0,0-8.71,5.93l-4.22,10.68H93.27a11,11,0,0,0-10.94,10.94V346.21a11,11,0,0,0,10.94,10.94H406.73a11,11,0,0,0,10.94-10.94V137.49A11,11,0,0,0,406.73,126.55Z"
					style={{ fill: "#555555" }}
				/>
				<rect
					x="152.1"
					y="91.58"
					width="195.8"
					height="321.33"
					rx="3.73"
					transform="translate(502.25 2.25) rotate(90)"
					style={{ fill: "currentColor" }}
				/>
				<rect
					x="199.79"
					y="206.13"
					width="53.67"
					height="15.91"
					style={{ fill: "#407BFF" }}
				/>
				<rect
					x="262.54"
					y="206.13"
					width="37.67"
					height="15.91"
					style={{ fill: "#407BFF" }}
				/>
				<rect
					x="117.99"
					y="160.86"
					width="17.05"
					height="3.8"
					style={{ fill: "#407BFF" }}
				/>
				<rect
					x="96.21"
					y="160.86"
					width="17.05"
					height="3.8"
					style={{ fill: "#407BFF" }}
				/>
				<path
					d="M332.5,266.68h-165V236.32h165Zm-164-1h163V237.32h-163Z"
					style={{ fill: "#407BFF" }}
				/>
				<rect
					x="173.17"
					y="243.91"
					width="1"
					height="15.19"
					style={{ fill: "#407BFF" }}
				/>
				<rect
					x="207.22"
					y="276.35"
					width="85.56"
					height="3.8"
					style={{ fill: "#407BFF" }}
				/>
				<path
					d="M314.08,257.29a7.38,7.38,0,1,1,5.21-12.6h0a7.38,7.38,0,0,1-5.21,12.6Zm0-12.76a5.38,5.38,0,1,0,3.8,1.58A5.38,5.38,0,0,0,314.08,244.53Z"
					style={{ fill: "#407BFF" }}
				/>
				<path
					d="M323.64,260.47a1,1,0,0,1-.71-.29l-5.05-5.05a1,1,0,0,1,1.42-1.42l5.05,5.06a1,1,0,0,1,0,1.41A1,1,0,0,1,323.64,260.47Z"
					style={{ fill: "#407BFF" }}
				/>
				<path
					d="M332.5,266.68h-165V236.32h165Zm-164-1h163V237.32h-163Z"
					style={{ fill: "#fff", opacity: 0.6 }}
				/>
				<rect
					x="173.17"
					y="243.91"
					width="1"
					height="15.19"
					style={{ fill: "#fff", opacity: 0.6 }}
				/>
				<rect
					x="207.22"
					y="276.35"
					width="85.56"
					height="3.8"
					style={{ fill: "#fff", opacity: 0.6 }}
				/>
				<rect
					x="117.99"
					y="160.86"
					width="17.05"
					height="3.8"
					style={{ fill: "#fff", opacity: 0.6 }}
				/>
				<rect
					x="96.21"
					y="160.86"
					width="17.05"
					height="3.8"
					style={{ fill: "#fff", opacity: 0.6 }}
				/>
				<g style={{ opacity: 0.6 }}>
					<path
						d="M314.08,257.29a7.38,7.38,0,1,1,5.21-12.6h0a7.38,7.38,0,0,1-5.21,12.6Zm0-12.76a5.38,5.38,0,1,0,3.8,1.58A5.38,5.38,0,0,0,314.08,244.53Z"
						style={{ fill: "#fff" }}
					/>
					<path
						d="M323.64,260.47a1,1,0,0,1-.71-.29l-5.05-5.05a1,1,0,0,1,1.42-1.42l5.05,5.06a1,1,0,0,1,0,1.41A1,1,0,0,1,323.64,260.47Z"
						style={{ fill: "#fff" }}
					/>
				</g>
			</g>
		</svg>
	);
};

export const Audio = () => {
	return (
		<svg
			width="210"
			height="122"
			viewBox="0 0 420 244"
			fill="none"
			xmlns="http://www.w3.org/2000/svg"
		>
			<path d="M412.803 29H406.803V30H412.803V29Z" fill="#E6E6E6" />
			<path
				d="M394.682 30H382.561V29H394.682V30ZM370.44 30H358.319V29H370.44L370.44 30ZM346.197 30H334.076V29H346.197V30ZM321.955 30H309.834V29H321.955V30ZM297.712 30H285.591V29H297.712V30ZM273.47 30H261.349V29H273.47V30ZM249.227 30H237.106V29H249.227V30ZM224.985 30H212.864V29H224.985V30ZM200.743 30H188.621V29H200.743V30ZM176.5 30H164.379V29H176.5V30ZM152.258 30H140.137V29H152.258V30ZM128.015 30H115.894V29H128.015V30ZM103.773 30H91.6518V29H103.773V30ZM79.5304 30H67.4091V29H79.5304V30ZM55.288 30H43.1669V29H55.288V30ZM31.0456 30H18.9242V29H31.0456V30Z"
				fill="#E6E6E6"
			/>
			<path d="M6.80316 29H0.803162V30H6.80316V29Z" fill="#E6E6E6" />
			<path d="M215.803 122H209.803V123H215.803V122Z" fill="#E6E6E6" />
			<path
				d="M197.862 123H185.921V122H197.862V123ZM173.979 123H162.038V122H173.979V123ZM150.097 123H138.156V122H150.097V123ZM126.215 123H114.274V122H126.215V123ZM102.332 123H90.391V122H102.332V123ZM78.4499 123H66.5087V122H78.4499V123ZM54.5675 123H42.6264V122H54.5676L54.5675 123ZM30.6852 123H18.744V122H30.6852V123Z"
				fill="#E6E6E6"
			/>
			<path d="M6.80316 122H0.803162V123H6.80316V122Z" fill="#E6E6E6" />
			<path d="M98.8032 166H92.8032V167H98.8032V166Z" fill="#E6E6E6" />
			<path
				d="M80.5175 167H68.2318V166H80.5175V167ZM55.946 167H43.6603V166H55.946V167ZM31.3747 167H19.089V166H31.3747V167Z"
				fill="#E6E6E6"
			/>
			<path d="M6.80316 166H0.803162V167H6.80316V166Z" fill="#E6E6E6" />
			<path
				d="M412.973 40.01V211.27C412.963 219.886 409.536 228.147 403.443 234.24C397.35 240.333 389.09 243.76 380.473 243.77H32.4731C27.911 243.773 23.3997 242.813 19.2346 240.952C15.0694 239.09 11.3443 236.371 8.30313 232.97V231.44C11.2308 234.962 14.8934 237.801 19.0341 239.758C23.1749 241.715 27.6935 242.743 32.2733 242.77L92.4633 182.58C93.2524 181.791 94.1894 181.164 95.2206 180.737C96.2518 180.31 97.3571 180.09 98.4733 180.09C99.5895 180.09 100.695 180.31 101.726 180.737C102.757 181.164 103.694 181.791 104.483 182.58L136.473 214.56L211.463 139.58C212.252 138.791 213.189 138.164 214.221 137.737C215.252 137.31 216.357 137.09 217.473 137.09C218.59 137.09 219.695 137.31 220.726 137.737C221.757 138.164 222.694 138.791 223.483 139.58L267.473 183.56L410.983 40.06L411.973 40.03L412.433 40.02L412.973 40.01Z"
				fill="#5678f8"
			/>
			<path
				d="M380.803 244H32.8031C24.1866 243.99 15.9258 240.563 9.83298 234.47C3.74016 228.377 0.312884 220.117 0.303131 211.5V32.5C0.312884 23.8835 3.74016 15.6226 9.83298 9.5298C15.9258 3.43698 24.1866 0.00975325 32.8031 0H380.803C389.42 0.00975061 397.681 3.43698 403.773 9.5298C409.866 15.6226 413.293 23.8835 413.303 32.5V211.5C413.293 220.117 409.866 228.377 403.773 234.47C397.681 240.563 389.42 243.99 380.803 244ZM32.8031 1C24.4517 1.00945 16.4451 4.33122 10.5397 10.2366C4.63435 16.1419 1.31258 24.1486 1.30313 32.5V211.5C1.31258 219.851 4.63435 227.858 10.5397 233.763C16.4451 239.669 24.4517 242.991 32.8031 243H380.803C389.155 242.991 397.161 239.669 403.067 233.763C408.972 227.858 412.294 219.851 412.303 211.5V32.5C412.294 24.1486 408.972 16.1419 403.067 10.2366C397.161 4.33122 389.155 1.00945 380.803 1H32.8031Z"
				fill="#3F3D56"
			/>
			<path
				d="M33.1566 243.854L32.4497 243.147L92.7929 182.803C94.3881 181.211 96.5496 180.317 98.8032 180.317C101.057 180.317 103.218 181.211 104.813 182.803L136.803 214.793L211.793 139.803C213.388 138.211 215.55 137.317 217.803 137.317C220.057 137.317 222.218 138.211 223.813 139.803L267.803 183.793L412.45 39.1465L413.157 39.8535L267.803 185.207L223.106 140.51C222.41 139.814 221.583 139.261 220.673 138.884C219.763 138.507 218.788 138.313 217.803 138.313C216.818 138.313 215.843 138.507 214.933 138.884C214.023 139.261 213.196 139.814 212.5 140.51L136.803 216.207L104.106 183.51C102.699 182.106 100.791 181.317 98.8031 181.317C96.8148 181.317 94.9076 182.106 93.4999 183.51L33.1566 243.854Z"
				fill="#3F3D56"
			/>
			<path
				d="M98.8032 173.5C102.669 173.5 105.803 170.366 105.803 166.5C105.803 162.634 102.669 159.5 98.8032 159.5C94.9372 159.5 91.8032 162.634 91.8032 166.5C91.8032 170.366 94.9372 173.5 98.8032 173.5Z"
				fill="#3F3D56"
			/>
			<path
				d="M215.803 129.5C219.669 129.5 222.803 126.366 222.803 122.5C222.803 118.634 219.669 115.5 215.803 115.5C211.937 115.5 208.803 118.634 208.803 122.5C208.803 126.366 211.937 129.5 215.803 129.5Z"
				fill="#3F3D56"
			/>
			<path
				d="M412.803 36.5C416.669 36.5 419.803 33.366 419.803 29.5C419.803 25.634 416.669 22.5 412.803 22.5C408.937 22.5 405.803 25.634 405.803 29.5C405.803 33.366 408.937 36.5 412.803 36.5Z"
				fill="#3F3D56"
			/>
		</svg>
	);
};

export const Servers = () => {
	return (
		<svg xmlns="http://www.w3.org/2000/svg" viewBox="150 200 140 240">
			<g>
				<rect
					x="169.9"
					y="222.37"
					width="102.97"
					height="193.86"
					style={{ fill: "currentColor" }}
				/>
				<rect
					x="257.87"
					y="231.62"
					width="7.62"
					height="7.66"
					rx="0.93"
					style={{ opacity: 0.1 }}
				/>
				<rect
					x="242.15"
					y="231.62"
					width="7.62"
					height="7.66"
					rx="0.93"
					style={{ opacity: 0.3 }}
				/>
				<rect
					x="226.44"
					y="231.62"
					width="7.62"
					height="7.66"
					rx="0.93"
					style={{ opacity: 0.3 }}
				/>
				<rect
					x="210.72"
					y="231.62"
					width="7.62"
					height="7.66"
					rx="0.93"
					style={{ opacity: 0.1 }}
				/>
				<rect
					x="195.01"
					y="231.62"
					width="7.62"
					height="7.66"
					rx="0.93"
					style={{ opacity: 0.3 }}
				/>
				<rect
					x="179.29"
					y="231.62"
					width="7.62"
					height="7.66"
					rx="0.93"
					style={{ opacity: 0.3 }}
				/>
				<g style={{ opacity: 0.1 }}>
					<rect x="173.26" y="243.67" width="96.25" height="30.35" />
				</g>
				<rect
					x="260.05"
					y="248.01"
					width="5.31"
					height="21.68"
					rx="1.3"
					style={{ fill: "#407BFF" }}
				/>
				<rect
					x="249.1"
					y="248.01"
					width="5.31"
					height="21.68"
					rx="1.3"
					style={{ opacity: 0.1 }}
				/>
				<rect
					x="238.14"
					y="248.01"
					width="5.31"
					height="21.68"
					rx="1.3"
					style={{ fill: "#407BFF" }}
				/>
				<rect
					x="227.18"
					y="248.01"
					width="5.31"
					height="21.68"
					rx="1.3"
					style={{ fill: "#407BFF" }}
				/>
				<path
					d="M200.83,254a3.5,3.5,0,1,1,3.5,3.5A3.51,3.51,0,0,1,200.83,254Z"
					style={{ opacity: 0.3, fill: "#fff" }}
				/>
				<path
					d="M217.84,263.69a3.5,3.5,0,1,1-3.5-3.51A3.5,3.5,0,0,1,217.84,263.69Z"
					style={{ opacity: 0.1 }}
				/>
				<path
					d="M210.84,254a3.5,3.5,0,1,1,3.5,3.5A3.51,3.51,0,0,1,210.84,254Z"
					style={{ opacity: 0.1 }}
				/>
				<path
					d="M207.83,263.69a3.5,3.5,0,1,1-3.5-3.51A3.5,3.5,0,0,1,207.83,263.69Z"
					style={{ opacity: 0.1 }}
				/>
				<circle
					cx="186.88"
					cy="258.85"
					r="7.59"
					transform="translate(-128.3 207.96) rotate(-45)"
					style={{ opacity: 0.3, fill: "#fff" }}
				/>
				<g style={{ opacity: 0.1 }}>
					<rect x="173.26" y="278.18" width="96.25" height="30.35" />
				</g>
				<rect
					x="260.05"
					y="282.52"
					width="5.31"
					height="21.68"
					rx="1.3"
					style={{ fill: "#407BFF" }}
				/>
				<rect
					x="249.1"
					y="282.52"
					width="5.31"
					height="21.68"
					rx="1.3"
					style={{ opacity: 0.1 }}
				/>
				<rect
					x="238.14"
					y="282.52"
					width="5.31"
					height="21.68"
					rx="1.3"
					style={{ fill: "#407BFF" }}
				/>
				<rect
					x="227.18"
					y="282.52"
					width="5.31"
					height="21.68"
					rx="1.3"
					style={{ fill: "#407BFF" }}
				/>
				<path
					d="M200.83,288.52a3.5,3.5,0,1,1,3.5,3.5A3.5,3.5,0,0,1,200.83,288.52Z"
					style={{ opacity: 0.3, fill: "#fff" }}
				/>
				<circle
					cx="214.34"
					cy="298.2"
					r="3.5"
					style={{ opacity: 0.3, fill: "#fff" }}
				/>
				<path
					d="M210.84,288.52a3.5,3.5,0,1,1,3.5,3.5A3.5,3.5,0,0,1,210.84,288.52Z"
					style={{ opacity: 0.1 }}
				/>
				<circle cx="204.33" cy="298.2" r="3.5" style={{ opacity: 0.1 }} />
				<circle
					cx="186.88"
					cy="293.36"
					r="7.59"
					style={{ opacity: 0.3, fill: "#fff" }}
				/>
				<g style={{ opacity: 0.1 }}>
					<rect x="173.26" y="312.7" width="96.25" height="30.35" />
				</g>
				<rect
					x="260.05"
					y="317.03"
					width="5.31"
					height="21.68"
					rx="1.3"
					style={{ fill: "#407BFF" }}
				/>
				<rect
					x="249.1"
					y="317.03"
					width="5.31"
					height="21.68"
					rx="1.3"
					style={{ opacity: 0.1 }}
				/>
				<rect
					x="238.14"
					y="317.03"
					width="5.31"
					height="21.68"
					rx="1.3"
					style={{ fill: "#407BFF" }}
				/>
				<rect
					x="227.18"
					y="317.03"
					width="5.31"
					height="21.68"
					rx="1.3"
					style={{ fill: "#407BFF" }}
				/>
				<path
					d="M200.83,323a3.5,3.5,0,1,1,3.5,3.51A3.5,3.5,0,0,1,200.83,323Z"
					style={{ opacity: 0.3, fill: "#fff" }}
				/>
				<circle
					cx="214.34"
					cy="332.71"
					r="3.5"
					style={{ opacity: 0.3, fill: "#fff" }}
				/>
				<path
					d="M210.84,323a3.5,3.5,0,1,1,3.5,3.51A3.5,3.5,0,0,1,210.84,323Z"
					style={{ opacity: 0.1 }}
				/>
				<circle cx="204.33" cy="332.71" r="3.5" style={{ opacity: 0.1 }} />
				<circle cx="186.88" cy="327.87" r="7.59" style={{ opacity: 0.1 }} />
				<g style={{ opacity: 0.1 }}>
					<rect x="173.26" y="347.21" width="96.25" height="30.35" />
				</g>
				<rect
					x="260.05"
					y="351.55"
					width="5.31"
					height="21.68"
					rx="1.3"
					style={{ fill: "#407BFF" }}
				/>
				<rect
					x="249.1"
					y="351.55"
					width="5.31"
					height="21.68"
					rx="1.3"
					style={{ opacity: 0.1 }}
				/>
				<rect
					x="238.14"
					y="351.55"
					width="5.31"
					height="21.68"
					rx="1.3"
					style={{ fill: "#407BFF" }}
				/>
				<rect
					x="227.18"
					y="351.55"
					width="5.31"
					height="21.68"
					rx="1.3"
					style={{ fill: "#407BFF" }}
				/>
				<circle
					cx="204.33"
					cy="357.55"
					r="3.5"
					style={{ opacity: 0.3, fill: "#fff" }}
				/>
				<circle
					cx="214.34"
					cy="367.23"
					r="3.5"
					style={{ opacity: 0.3, fill: "#fff" }}
				/>
				<circle
					cx="214.34"
					cy="357.55"
					r="3.5"
					style={{ opacity: 0.3, fill: "#fff" }}
				/>
				<circle cx="204.33" cy="367.23" r="3.5" style={{ opacity: 0.1 }} />
				<circle
					cx="186.88"
					cy="362.39"
					r="7.59"
					style={{ opacity: 0.3, fill: "#fff" }}
				/>
				<g style={{ opacity: 0.1 }}>
					<rect x="173.26" y="381.72" width="96.25" height="30.35" />
				</g>
				<rect
					x="260.05"
					y="386.06"
					width="5.31"
					height="21.68"
					rx="1.3"
					style={{ fill: "#407BFF" }}
				/>
				<rect
					x="249.1"
					y="386.06"
					width="5.31"
					height="21.68"
					rx="1.3"
					style={{ opacity: 0.1 }}
				/>
				<rect
					x="238.14"
					y="386.06"
					width="5.31"
					height="21.68"
					rx="1.3"
					style={{ fill: "#407BFF" }}
				/>
				<rect
					x="227.18"
					y="386.06"
					width="5.31"
					height="21.68"
					rx="1.3"
					style={{ fill: "#407BFF" }}
				/>
				<circle
					cx="204.33"
					cy="392.06"
					r="3.5"
					style={{ opacity: 0.3, fill: "#fff" }}
				/>
				<circle
					cx="214.34"
					cy="401.74"
					r="3.5"
					style={{ opacity: 0.3, fill: "#fff" }}
				/>
				<circle
					cx="214.34"
					cy="392.06"
					r="3.5"
					style={{ opacity: 0.3, fill: "#fff" }}
				/>
				<circle cx="204.33" cy="401.74" r="3.5" style={{ opacity: 0.1 }} />
				<circle
					cx="186.88"
					cy="396.9"
					r="7.59"
					style={{ opacity: 0.3, fill: "#fff" }}
				/>
			</g>
		</svg>
	);
};
