import { Audio, Browser, Servers } from "@/components/ui/icons";

export function BentoFeatures() {
  return (
    <section className="mt-20">
      <div className="relative py-16">
        <div className="absolute -left-16 -top-32 font-extrabold opacity-[0.05] font-heading text-[12rem]">
          Features
        </div>
        <div className="max-w-6xl px-6 mx-auto text-gray-500">
          <div className="relative">
            <div className="relative z-10 grid grid-cols-6 gap-3">
              <div className="relative flex p-8 overflow-hidden border col-span-full rounded-xl lg:col-span-2 border-neutral-50/50 backdrop-blur dark:bg-neutral-700/10 dark:border-neutral-800">
                <div className="relative m-auto size-fit">
                  <div className="relative flex items-center w-56 h-24 mx-auto">
                    <svg
                      className="absolute inset-0 text-neutral-200 size-full dark:text-neutral-600"
                      viewBox="0 0 254 104"
                      fill="none"
                      xmlns="http://www.w3.org/2000/svg"
                    >
                      <path
                        d="M112.891 97.7022C140.366 97.0802 171.004 94.6715 201.087 87.5116C210.43 85.2881 219.615 82.6412 228.284 78.2473C232.198 76.3179 235.905 73.9942 239.348 71.3124C241.85 69.2557 243.954 66.7571 245.555 63.9408C249.34 57.3235 248.281 50.5341 242.498 45.6109C239.033 42.7237 235.228 40.2703 231.169 38.3054C219.443 32.7209 207.141 28.4382 194.482 25.534C184.013 23.1927 173.358 21.7755 162.64 21.2989C161.376 21.3512 160.113 21.181 158.908 20.796C158.034 20.399 156.857 19.1682 156.962 18.4535C157.115 17.8927 157.381 17.3689 157.743 16.9139C158.104 16.4588 158.555 16.0821 159.067 15.8066C160.14 15.4683 161.274 15.3733 162.389 15.5286C179.805 15.3566 196.626 18.8373 212.998 24.462C220.978 27.2494 228.798 30.4747 236.423 34.1232C240.476 36.1159 244.202 38.7131 247.474 41.8258C254.342 48.2578 255.745 56.9397 251.841 65.4892C249.793 69.8582 246.736 73.6777 242.921 76.6327C236.224 82.0192 228.522 85.4602 220.502 88.2924C205.017 93.7847 188.964 96.9081 172.738 99.2109C153.442 101.949 133.993 103.478 114.506 103.79C91.1468 104.161 67.9334 102.97 45.1169 97.5831C36.0094 95.5616 27.2626 92.1655 19.1771 87.5116C13.839 84.5746 9.1557 80.5802 5.41318 75.7725C-0.54238 67.7259 -1.13794 59.1763 3.25594 50.2827C5.82447 45.3918 9.29572 41.0315 13.4863 37.4319C24.2989 27.5721 37.0438 20.9681 50.5431 15.7272C68.1451 8.8849 86.4883 5.1395 105.175 2.83669C129.045 0.0992292 153.151 0.134761 177.013 2.94256C197.672 5.23215 218.04 9.01724 237.588 16.3889C240.089 17.3418 242.498 18.5197 244.933 19.6446C246.627 20.4387 247.725 21.6695 246.997 23.615C246.455 25.1105 244.814 25.5605 242.63 24.5811C230.322 18.9961 217.233 16.1904 204.117 13.4376C188.761 10.3438 173.2 8.36665 157.558 7.52174C129.914 5.70776 102.154 8.06792 75.2124 14.5228C60.6177 17.8788 46.5758 23.2977 33.5102 30.6161C26.6595 34.3329 20.4123 39.0673 14.9818 44.658C12.9433 46.8071 11.1336 49.1622 9.58207 51.6855C4.87056 59.5336 5.61172 67.2494 11.9246 73.7608C15.2064 77.0494 18.8775 79.925 22.8564 82.3236C31.6176 87.7101 41.3848 90.5291 51.3902 92.5804C70.6068 96.5773 90.0219 97.7419 112.891 97.7022Z"
                        fill="currentColor"
                      ></path>
                    </svg>
                    <span className="block mx-auto text-5xl font-semibold text-transparent bg-clip-text bg-gradient-to-br from-blue-300 to-pink-600 dark:from-blue-400 dark:to-pink-400 w-fit">
                      100%
                    </span>
                  </div>
                  <h2 className="text-2xl text-gray-800 transition dark:text-white font-display group-hover:text-purple-950">
                    Open Source
                  </h2>
                  <p className="text-gray-700 dark:text-gray-300">
                    Leveraging the power of community collaboration.
                  </p>
                </div>
              </div>
              <div className="relative p-8 overflow-hidden border col-span-full rounded-xl sm:col-span-3 lg:col-span-2 border-neutral-50/50 backdrop-blur dark:bg-neutral-700/10 dark:border-neutral-800">
                <div>
                  <div className="relative flex w-40 mx-auto text-white dark:text-neutral-800">
                    <Browser />
                  </div>
                  <div className="relative z-10 mt-6 space-y-2 text-center">
                    <h2 className="text-2xl text-gray-800 transition dark:text-white font-display group-hover:text-purple-950">
                      XGBoost Integration
                    </h2>
                    <p className="text-gray-700 dark:text-gray-300">
                      Using xgboost ML techniques to effectively combine
                      heterogeneous retrievers.
                    </p>
                  </div>
                </div>
              </div>
              <div className="relative p-8 overflow-hidden border col-span-full rounded-xl sm:col-span-3 lg:col-span-2 border-neutral-50/50 backdrop-blur dark:bg-neutral-700/10 dark:border-neutral-800">
                <div>
                  <div className="w-40 mx-auto text-white dark:text-neutral-800">
                    <Audio />
                  </div>
                  <div className="relative z-10 mt-8 space-y-2 text-center">
                    <h2 className="text-2xl text-gray-800 transition dark:text-white font-display group-hover:text-purple-950">
                      Enterprise Grade
                    </h2>
                    <p className="text-gray-700 dark:text-gray-300">
                      Designed to scale to the needs of the largest enterprises.
                    </p>
                  </div>
                </div>
              </div>
              <div className="relative p-8 overflow-hidden border col-span-full rounded-xl lg:col-span-3 border-neutral-50/50 backdrop-blur dark:bg-neutral-700/10 dark:border-neutral-800">
                <div className="grid sm:grid-cols-2">
                  <div className="relative z-10 flex flex-col justify-between gap-2 sm:gap-6">
                    <div className="relative flex border rounded-full aspect-square min-h-12 min-w-12 size-12 before:absolute before:-inset-2 before:border before:rounded-full dark:bg-white/5 dark:border-white/10 dark:before:border-white/5 dark:before:bg-white/5">
                      <svg
                        className="m-auto size-6"
                        xmlns="http://www.w3.org/2000/svg"
                        width="24"
                        height="24"
                        viewBox="0 0 24 24"
                        fill="none"
                        stroke="currentColor"
                        strokeWidth="2"
                        strokeLinecap="round"
                        strokeLinejoin="round"
                      >
                        <path d="M12 22v-9" />
                        <path d="M15.17 2.21a1.67 1.67 0 0 1 1.63 0L21 4.57a1.93 1.93 0 0 1 0 3.36L8.82 14.79a1.655 1.655 0 0 1-1.64 0L3 12.43a1.93 1.93 0 0 1 0-3.36z" />
                        <path d="M20 13v3.87a2.06 2.06 0 0 1-1.11 1.83l-6 3.08a1.93 1.93 0 0 1-1.78 0l-6-3.08A2.06 2.06 0 0 1 4 16.87V13" />
                        <path d="M21 12.43a1.93 1.93 0 0 0 0-3.36L8.83 2.2a1.64 1.64 0 0 0-1.63 0L3 4.57a1.93 1.93 0 0 0 0 3.36l12.18 6.86a1.636 1.636 0 0 0 1.63 0z" />
                      </svg>
                    </div>
                    <div className="flex flex-col items-center justify-start h-full space-y-2">
                      <h2 className="text-2xl text-gray-800 transition dark:text-white font-display group-hover:text-purple-950">
                        Out-of-the-Box
                      </h2>
                      <p className="text-gray-700 dark:text-gray-300">
                        Running your own DenserRetriever instance is as easy as{" "}
                        <code>docker compose up</code>
                      </p>
                    </div>
                  </div>
                  <div className="relative w-32 mx-auto overflow-hidden text-gray-100 dark:text-neutral-700">
                    <Servers />
                  </div>
                </div>
              </div>
              <div className="relative p-8 overflow-hidden border col-span-full rounded-xl lg:col-span-3 border-neutral-50/50 backdrop-blur dark:bg-neutral-700/10 dark:border-neutral-800">
                <div className="grid h-full sm:grid-cols-2">
                  <div className="relative z-10 flex flex-col justify-start gap-2">
                    <div className="relative flex border rounded-full aspect-square size-12 before:absolute before:-inset-2 before:border before:rounded-full dark:bg-white/5 dark:border-white/10 dark:before:border-white/5 dark:before:bg-white/5">
                      <svg
                        className="m-auto size-6"
                        xmlns="http://www.w3.org/2000/svg"
                        width="1em"
                        height="1em"
                        viewBox="0 0 24 24"
                      >
                        <g fill="none">
                          <path
                            stroke="currentColor"
                            d="M9 6a3 3 0 1 0 6 0a3 3 0 0 0-6 0zm-4.562 7.902a3 3 0 1 0 3 5.195a3 3 0 0 0-3-5.196zm15.124 0a2.999 2.999 0 1 1-2.998 5.194a2.999 2.999 0 0 1 2.998-5.194z"
                          ></path>
                          <path
                            fill="currentColor"
                            fillRule="evenodd"
                            d="M9.003 6.125a2.993 2.993 0 0 1 .175-1.143a8.507 8.507 0 0 0-5.031 4.766a8.5 8.5 0 0 0-.502 4.817a3 3 0 0 1 .902-.723a7.498 7.498 0 0 1 4.456-7.717m5.994 0a7.499 7.499 0 0 1 4.456 7.717a2.998 2.998 0 0 1 .902.723a8.5 8.5 0 0 0-5.533-9.583a3 3 0 0 1 .175 1.143m2.536 13.328a3.002 3.002 0 0 1-1.078-.42a7.501 7.501 0 0 1-8.91 0l-.107.065a3 3 0 0 1-.971.355a8.5 8.5 0 0 0 11.066 0"
                            clipRule="evenodd"
                          ></path>
                        </g>
                      </svg>
                    </div>
                    <div className="space-y-2">
                      <h2 className="text-2xl text-gray-800 transition dark:text-white font-display group-hover:text-purple-950">
                        Benchmark
                      </h2>
                      <p className="text-gray-700 dark:text-gray-300">
                        Achieving state-of-the-art accuracy in MTEB Retrieval
                        benchmarking.
                      </p>
                    </div>
                  </div>
                  <div className="relative mt-6 sm:-my-8 before:absolute before:w-px before:inset-0 before:mx-auto before:bg-neutral-50 sm:-mr-[--card-padding] dark:before:bg-neutral-800">
                    <div className="relative flex flex-col justify-center h-full py-6 space-y-6">
                      <div className="flex items-center justify-end gap-2 w-[calc(50%+0.875rem)] relative">
                        <span className="block px-2 py-1 text-xs border rounded-md shadow-xs dark:text-white h-fit dark:bg-neutral-800 dark:border-white/5">
                          Hugging Face
                        </span>
                        <div className="ring-4 ring-white size-7 dark:ring-[--card-dark-bg]">
                          <svg
                            className="bg-white border rounded-full size-8 border-neutral-950/5 dark:border-white/5"
                            viewBox="0 0 256 238"
                            version="1.1"
                            preserveAspectRatio="xMidYMid"
                          >
                            <g>
                              <path
                                d="M255.138167,174.711097 C254.470657,172.191464 253.389216,169.801107 251.938594,167.63574 C252.249353,166.494633 252.48553,165.336124 252.644638,164.166428 C253.673871,156.738049 251.099545,149.933674 246.245492,144.675635 C243.616473,141.801737 240.798512,139.904865 237.813984,138.740141 C239.773008,130.358354 240.76495,121.78514 240.769922,113.170905 C240.769922,109.240428 240.547419,105.389504 240.174508,101.595761 C239.979351,99.7013749 239.744418,97.8107182 239.469707,95.9262767 C238.614499,90.3661798 237.346603,84.876936 235.675963,79.5057805 C234.580849,75.9768033 233.314196,72.5025196 231.880977,69.0966029 C229.731768,64.0523657 227.22208,59.169723 224.3718,54.4909382 C222.501032,51.3758917 220.46494,48.3627742 218.270983,45.4652589 C217.195758,44.0022064 216.075783,42.5739588 214.909816,41.1817593 C211.456664,36.9840291 207.705183,33.0436072 203.681478,29.3890835 C202.346458,28.160716 200.972904,26.9751089 199.562059,25.8327595 C198.173588,24.6744992 196.754042,23.5530328 195.305906,22.470349 C192.390988,20.3012524 189.377871,18.2651606 186.277741,16.3707748 C169.148714,5.96656941 149.061264,0 127.581614,0 C65.0693691,0 14.4032505,50.6661186 14.4032505,113.178364 C14.4016346,121.894527 15.4114765,130.580858 17.412639,139.058358 C14.7276827,140.224325 12.1533567,142.0404 9.76797192,144.66942 C4.91516213,149.928702 2.339593,156.70573 3.37006926,164.135352 C3.52544867,165.316236 3.76162538,166.484689 4.07487027,167.633254 C2.62549112,169.799864 1.54405041,172.191464 0.875297427,174.711097 C-0.616344927,180.380581 -0.125345985,185.493185 1.77028284,189.97557 C-0.289426644,195.831509 0.225189968,202.066574 2.90890317,207.489937 C4.86046858,211.449005 7.65356889,214.510601 11.0955336,217.249007 C15.1888488,220.502031 20.3126403,223.267784 26.4967409,225.919179 C33.8704263,229.064058 42.8675157,232.018753 46.9571019,233.10268 C57.5303601,235.841086 67.6660699,237.576364 77.9459717,237.659647 C92.5889275,237.796381 105.193305,234.353173 114.217742,225.543782 C118.651649,226.086988 123.114145,226.359213 127.580371,226.35797 C132.300176,226.348026 137.015009,226.049697 141.701252,225.467957 C150.7058,234.333285 163.354927,237.807568 178.047604,237.667105 C188.321291,237.586308 198.458244,235.851031 208.999183,233.108895 C213.119845,232.024968 222.113205,229.070273 229.496835,225.926637 C235.678449,223.269027 240.800998,220.504517 244.922903,217.255223 C248.338764,214.518059 251.129378,211.45522 253.082186,207.496153 C255.793246,202.075276 256.281759,195.840211 254.248154,189.981785 C256.12638,185.503129 256.61365,180.379338 255.12325,174.717312 L255.138167,174.711097 Z M244.648192,189.590229 C246.725304,193.531894 246.858309,197.98569 245.024832,202.132455 C242.245405,208.419728 235.341587,213.370737 221.929236,218.689685 C213.592198,221.997402 205.956232,224.110562 205.894081,224.130451 C194.865872,226.990675 184.886784,228.44254 176.260119,228.44254 C161.965213,228.44254 151.324831,224.498389 144.57515,216.707044 C133.165329,218.649908 121.516845,218.715789 110.08092,216.902201 C103.326266,224.56427 92.7530082,228.44254 78.5699755,228.44254 C69.9346093,228.44254 59.9617371,226.990675 48.936014,224.130451 C48.8676471,224.110562 41.2366534,221.997402 32.9008587,218.689685 C19.4885079,213.373223 12.589662,208.4247 9.80526298,202.132455 C7.97178592,197.984446 8.1047907,193.530651 10.1819027,189.590229 C10.3745731,189.224777 10.579674,188.866783 10.7996912,188.522462 C9.55416985,186.652937 8.72009317,184.539777 8.34966865,182.324688 C7.97949274,180.109599 8.08254037,177.839817 8.65197483,175.666991 C9.47735027,172.532056 11.1827947,169.924168 13.4973264,168.050914 C12.382821,166.21868 11.651419,164.180102 11.3468754,162.056997 C10.6806084,157.440364 12.2120279,152.829946 15.6602078,149.067279 C18.343921,146.142417 22.1389078,144.532686 26.3416101,144.532686 L26.4534833,144.532686 C23.2849863,134.37833 21.6789847,123.798857 21.688929,113.158475 C21.688929,55.1460178 68.7253845,8.10956226 126.737842,8.10956226 C184.762729,8.10956226 231.786754,55.1460178 231.786754,113.158475 C231.794213,123.823718 230.177024,134.426809 226.989881,144.607268 C227.49704,144.557547 227.994254,144.531443 228.481524,144.531443 C232.682983,144.531443 236.479213,146.13993 239.162926,149.064792 C242.60862,152.820002 244.143768,157.434149 243.476258,162.054511 C243.171715,164.177616 242.44081,166.217437 241.325807,168.049671 C243.640339,169.921682 245.345783,172.52957 246.171159,175.665748 C246.739226,177.838573 246.842398,180.107113 246.471973,182.323445 C246.101549,184.538534 245.267472,186.650451 244.023194,188.521219 C244.243211,188.86181 244.450798,189.219805 244.640982,189.585257 L244.648192,189.590229 Z"
                                fill="#FFFFFF"
                              ></path>
                              <path
                                d="M243.950849,188.508788 C245.195128,186.63802 246.029204,184.526103 246.399629,182.311014 C246.770053,180.094683 246.666881,177.826143 246.098814,175.653317 C245.273439,172.518382 243.567994,169.910494 241.253463,168.03724 C242.367222,166.205006 243.09937,164.166428 243.403914,162.043324 C244.070181,157.426691 242.538761,152.816273 239.090581,149.053605 C236.406868,146.128743 232.610638,144.519012 228.409179,144.519012 C227.920666,144.519012 227.424695,144.543873 226.917537,144.594838 C230.10095,134.416865 231.715653,123.811287 231.705709,113.146045 C231.705709,55.1335874 184.669253,8.09713191 126.656796,8.09713191 C68.6443386,8.09713191 21.6078831,55.1211571 21.6078831,113.146045 C21.5978145,123.782698 23.2039404,134.364657 26.3724374,144.520255 L26.2605642,144.520255 C22.0591049,144.520255 18.2641182,146.129986 15.580405,149.054848 C12.1347111,152.810058 10.6008056,157.422962 11.2670725,162.044567 C11.5712432,164.167671 12.3027695,166.206249 13.4175235,168.038483 C11.1029918,169.911737 9.3975474,172.519625 8.573415,175.655803 C8.00435345,177.828629 7.90167873,180.098412 8.27235186,182.314744 C8.64302498,184.529832 9.478469,186.642992 10.7236175,188.512518 C10.5011141,188.856838 10.2972563,189.214832 10.1058289,189.580285 C8.02995997,193.52195 7.89571216,197.975745 9.72918922,202.122511 C12.5073731,208.40854 19.4124342,213.362036 32.824785,218.679741 C41.1618227,221.987458 48.7977885,224.100618 48.8599403,224.120507 C59.8881494,226.980731 69.8672368,228.433839 78.4939017,228.433839 C92.6769344,228.433839 103.255165,224.555569 110.004846,216.892256 C121.435799,218.705845 133.088012,218.639964 144.499076,216.6971 C151.245028,224.488445 161.88914,228.433839 176.184045,228.433839 C184.818169,228.433839 194.792284,226.980731 205.818007,224.120507 C205.885131,224.100618 213.517367,221.987458 221.853162,218.679741 C235.265513,213.364522 242.164359,208.411027 244.948758,202.122511 C246.782235,197.974502 246.64923,193.520707 244.572118,189.580285 C244.381934,189.211103 244.173104,188.854352 243.953087,188.512518 L243.950849,188.508788 Z M105.22811,204.891994 C104.64637,205.91004 104.023609,206.903225 103.359828,207.869063 C101.613364,210.425987 99.3162345,212.378795 96.6511668,213.831903 C91.5534791,216.610087 85.103369,217.582141 78.552573,217.582141 C68.200575,217.582141 57.5825675,215.159465 51.6408588,213.615615 C51.3487455,213.53979 15.1826337,203.323283 19.7570035,194.622036 C20.5276854,193.160227 21.7968245,192.576 23.3928818,192.576 C29.8405059,192.576 41.5784881,202.177205 46.6252114,202.177205 C47.7514014,202.177205 48.546944,201.69615 48.8713762,200.526454 C51.0218273,192.81342 16.1919783,189.571584 19.1255416,178.400425 C19.6438873,176.423999 21.0472742,175.622242 23.0224573,175.622242 C31.5459503,175.620999 50.6799926,190.613247 54.6825662,190.613247 C54.9895959,190.613247 55.2096132,190.523749 55.3289446,190.334807 L55.381152,190.249038 C57.2581353,187.147665 56.1816668,184.892799 43.3137654,177.010712 L42.0781883,176.258676 C27.9200163,167.687947 17.975734,162.535566 23.6315446,156.382541 C24.281652,155.671525 25.2027412,155.357037 26.322716,155.357037 C27.6515207,155.357037 29.2587653,155.802044 31.0288476,156.546622 C38.5069479,159.700202 48.8664041,168.300764 53.2045972,172.047272 C54.4811945,173.158546 55.2332308,173.837243 55.2332308,173.837243 C55.2332308,173.837243 60.7150165,179.537803 64.0301916,179.537803 C64.7934153,179.537803 65.4397936,179.238231 65.8785851,178.493653 C68.2304079,174.530857 44.0508853,156.20603 42.6835465,148.648376 C41.7599713,143.524584 43.3324109,140.93037 46.2423566,140.93037 C47.6246118,140.93037 49.3126537,141.518325 51.1759636,142.700452 C56.9560778,146.369892 68.1185347,165.54744 72.2081208,173.005652 C73.5779457,175.506639 75.9160951,176.563219 78.0230399,176.563219 C82.2033676,176.563219 85.4713074,172.407752 78.4058948,167.127338 C67.7866443,159.180614 71.5132641,146.194624 76.581119,145.399081 C76.7974071,145.365519 77.0161813,145.348117 77.2337125,145.346874 C81.8428874,145.346874 83.8764931,153.289869 83.8764931,153.289869 C83.8764931,153.289869 89.8343613,168.256014 100.073243,178.486195 C109.362446,187.770425 110.658932,195.391475 105.247999,204.888265 L105.22811,204.891994 Z M138.33014,206.644673 L137.799364,206.708068 L136.893191,206.812483 C136.417109,206.860962 135.941026,206.908197 135.462458,206.952946 L134.995077,206.995209 L134.569958,207.031257 L133.9646,207.079736 C133.742097,207.095895 133.519594,207.113298 133.29709,207.126971 L132.630823,207.17172 L132.484145,207.180422 L131.959584,207.211497 L131.737081,207.222685 L131.115563,207.253761 L130.39336,207.283594 L129.737037,207.305968 L129.299489,207.318399 L129.078229,207.318399 C128.941495,207.318399 128.806004,207.325857 128.66927,207.3271 L128.451739,207.3271 C128.315005,207.3271 128.179514,207.3271 128.04278,207.334558 L127.487143,207.340773 L126.709003,207.340773 C126.098673,207.340773 125.490829,207.334558 124.882984,207.323371 L124.390742,207.312183 C124.251523,207.312183 124.11106,207.304725 123.97184,207.300996 L123.451008,207.284837 L122.802143,207.259976 L122.21916,207.235115 L122.06751,207.2289 L121.511873,207.199067 C121.357736,207.190366 121.2036,207.182908 121.050707,207.172963 L120.691469,207.151832 C120.240248,207.123242 119.789026,207.090923 119.337804,207.056118 L118.865451,207.018827 L118.268794,206.967863 L117.571451,206.903225 C117.182381,206.867177 116.793311,206.8274 116.404241,206.783893 L116.385595,206.783893 C122.066266,194.104933 119.193612,182.271237 107.714181,170.810452 C100.186359,163.292574 95.1719548,152.189783 94.1402356,149.753434 C92.0370198,142.537614 86.4694648,134.513821 77.2225252,134.513821 C76.440656,134.515064 75.6612729,134.577216 74.889348,134.699034 C70.8382959,135.335468 67.2981314,137.667402 64.7722837,141.175247 C62.0438212,137.780518 59.3899409,135.081888 56.9908827,133.556684 C53.37365,131.264527 49.7651186,130.101046 46.2473287,130.101046 C41.8594141,130.101046 37.9351517,131.903447 35.200474,135.17263 L35.1321071,135.255913 L34.9779707,134.608292 L34.9717555,134.580945 C34.4516696,132.355912 34.0147427,130.11099 33.6615963,127.853638 C33.6615963,127.837479 33.6615963,127.822562 33.6541381,127.807646 L33.5770699,127.296758 C33.5354283,127.020805 33.494781,126.743608 33.4552525,126.467654 C33.4229336,126.237692 33.3906147,126.007731 33.3607818,125.779012 C33.330949,125.550294 33.29863,125.320332 33.2712833,125.090371 C33.2414504,124.859166 33.2141036,124.629205 33.1867569,124.399243 C33.1605288,124.180469 33.1352952,123.961695 33.1109317,123.742921 L33.1035978,123.686984 C32.991476,122.677639 32.8953894,121.667052 32.8150893,120.655221 L32.7715831,120.069751 C32.7591527,119.9094 32.7479654,119.747805 32.7380211,119.584967 C32.7380211,119.547676 32.733049,119.509142 32.7305629,119.474337 L32.6896671,118.825473 C32.6747506,118.590539 32.663439,118.355606 32.6510087,118.120672 C32.6385783,117.886981 32.6261479,117.652048 32.6162037,117.415871 L32.591343,116.800568 L32.5838847,116.614113 L32.5652392,116.044803 L32.5516901,115.562505 C32.5516901,115.369835 32.5428646,115.175921 32.5391355,114.983251 L32.5291912,114.375407 C32.5267051,114.172792 32.5291912,113.97142 32.5242191,113.768805 C32.5180039,113.564948 32.5242191,113.362333 32.5242191,113.158475 C32.5242191,61.1374479 74.7004066,18.9612604 126.733864,18.9612604 C178.767321,18.9612604 220.943509,61.1374479 220.943509,113.158475 L220.943509,114.375407 C220.943509,114.578021 220.938537,114.781879 220.933565,114.983251 C220.933565,115.152304 220.927349,115.317627 220.922377,115.48668 C220.922377,115.637087 220.916162,115.786252 220.909947,115.931687 C220.909947,116.121871 220.89876,116.310812 220.892545,116.500997 L220.892545,116.517156 C220.876385,116.929844 220.858983,117.342532 220.84158,117.755219 L220.834122,117.891953 L220.801803,118.508499 L220.77197,118.997012 C220.70236,120.154278 220.611619,121.311543 220.500988,122.466323 L220.500988,122.482483 C220.4811,122.698771 220.458725,122.916302 220.435108,123.13259 C220.380414,123.636019 220.324477,124.139449 220.268541,124.642878 L220.205146,125.148793 L220.126835,125.742964 C220.099488,125.960495 220.069655,126.176784 220.038579,126.393072 C220.005017,126.635464 219.968969,126.876612 219.934164,127.117761 L219.847152,127.687071 L219.745223,128.33345 C219.710418,128.548495 219.675613,128.762297 219.634593,128.977342 C219.59233,129.191144 219.560011,129.404946 219.52272,129.619991 C219.448137,130.047596 219.371069,130.473957 219.287786,130.900318 C219.122462,131.749311 218.94968,132.595818 218.766954,133.441082 C218.720962,133.651155 218.673727,133.862471 218.625248,134.072544 C215.973854,131.495732 212.463522,130.092345 208.590224,130.092345 C205.076163,130.092345 201.463903,131.254583 197.847913,133.547983 C195.447612,135.071944 192.796218,137.771817 190.065269,141.166546 C187.535692,137.657458 183.995528,135.326766 179.949448,134.689089 C179.177523,134.568515 178.396897,134.506363 177.615028,134.50512 C168.368088,134.50512 162.798047,142.526427 160.697317,149.744733 C159.654411,152.182325 154.644978,163.281387 147.110942,170.814181 C135.640212,182.24762 132.741454,194.03408 138.337598,206.650889 L138.33014,206.644673 Z M235.585222,181.274323 L235.547931,181.384953 C235.521827,181.455806 235.495723,181.526659 235.467133,181.596269 C235.422384,181.701927 235.375149,181.805099 235.325427,181.908271 C235.204853,182.154392 235.068119,182.393055 234.917712,182.621773 C234.710125,182.931289 234.482649,183.227131 234.235285,183.505571 C234.178106,183.570209 234.123412,183.633604 234.058774,183.696999 C233.971762,183.792713 233.878534,183.88594 233.78655,183.979168 C232.112181,185.63862 229.561473,187.091728 226.677631,188.426748 C226.350712,188.574669 226.020065,188.722591 225.684446,188.870512 L225.351312,189.018433 C225.128809,189.116633 224.907549,189.214832 224.673858,189.310546 C224.446382,189.407503 224.217664,189.503217 223.988945,189.597687 L223.295332,189.884829 C221.673171,190.552338 220.011232,191.187529 218.389071,191.816505 L217.696701,192.085001 L217.010545,192.353497 C216.555594,192.531251 216.105616,192.709005 215.661852,192.886759 L215.0018,193.152768 L214.354179,193.418778 L214.034719,193.551783 C213.823403,193.641281 213.614573,193.728294 213.408229,193.817792 C208.63746,195.863828 205.206682,197.945912 205.927643,200.530183 C205.947531,200.603522 205.969906,200.673132 205.994767,200.740256 C206.059404,200.931683 206.14766,201.113166 206.257047,201.282219 C206.321685,201.384148 206.396267,201.479862 206.47955,201.566874 C207.3273,202.446943 208.869907,202.307723 210.815257,201.609137 C210.973123,201.551958 211.134717,201.491049 211.297555,201.426411 C211.409428,201.384148 211.520058,201.339399 211.631932,201.294649 L211.799741,201.223796 C212.244748,201.034855 212.715858,200.824782 213.198156,200.594821 C213.31873,200.538884 213.440548,200.48419 213.562365,200.419553 C215.940292,199.257315 218.636435,197.689847 221.311447,196.264086 C221.721649,196.041582 222.133094,195.829023 222.542052,195.617707 C223.210805,195.2709 223.885773,194.936524 224.566957,194.617064 C227.100263,193.426236 229.480675,192.580972 231.396193,192.580972 C232.293664,192.580972 233.087964,192.764941 233.748016,193.187573 L233.858646,193.260912 C234.193022,193.497089 234.483892,193.786716 234.721312,194.11985 C234.776006,194.198161 234.833185,194.278958 234.881664,194.362242 C234.933871,194.448011 234.983593,194.536267 235.030828,194.625765 C235.976778,196.420708 235.184964,198.281532 233.332842,200.105065 C231.554058,201.855258 228.787062,203.57189 225.640939,205.161732 C225.408492,205.279821 225.173558,205.397909 224.937381,205.512268 C215.576083,210.109013 203.320998,213.570866 203.146973,213.614372 C199.880276,214.460879 195.208949,215.573396 189.945938,216.404987 L189.166555,216.525561 L189.039765,216.544206 C187.846451,216.723204 186.649408,216.881069 185.449879,217.017803 L185.339249,217.02899 C183.157722,217.277597 180.920259,217.457837 178.679066,217.533663 L178.645504,217.533663 C177.840017,217.563495 177.035773,217.577169 176.230286,217.577169 L175.302982,217.577169 C174.074863,217.559766 172.847987,217.505073 171.623598,217.410602 C171.595008,217.410602 171.565175,217.410602 171.535342,217.404387 C171.097794,217.370825 170.659002,217.329805 170.222697,217.281326 C169.471903,217.200529 168.722353,217.101086 167.975289,216.984241 C167.684419,216.935763 167.37366,216.884798 167.074088,216.832591 C166.937355,216.80773 166.801864,216.782869 166.666373,216.755522 L166.634054,216.749307 C166.202721,216.667267 165.773873,216.576525 165.346269,216.478326 C165.098905,216.422389 164.850298,216.366452 164.60542,216.300572 L164.458742,216.262037 C164.336925,216.232205 164.217593,216.199886 164.098262,216.167567 L164.032381,216.150164 L163.648283,216.039534 C163.509063,215.999757 163.371086,215.958737 163.231866,215.917717 L163.182145,215.9028 L162.820422,215.79217 C162.683688,215.749907 162.548197,215.705158 162.412706,215.661651 C162.300833,215.62436 162.190203,215.585826 162.07833,215.549778 L161.833452,215.464009 C161.597275,215.381968 161.363584,215.294956 161.129894,215.205457 L160.908633,215.119688 L160.725907,215.046349 C160.374128,214.904643 160.023592,214.756722 159.676785,214.601342 L159.445581,214.490712 L159.407047,214.47331 C159.325006,214.434776 159.244209,214.396241 159.162169,214.361436 C159.001817,214.284368 158.842709,214.204814 158.684843,214.124017 L158.637608,214.100399 L158.408889,213.979825 C158.002417,213.768509 157.603402,213.542276 157.213089,213.301127 L156.999287,213.170609 C156.888657,213.103485 156.787971,213.035118 156.682313,212.966751 L156.403873,212.781539 C156.303188,212.714415 156.202502,212.646048 156.104302,212.575195 L155.925305,212.448405 C155.736363,212.312914 155.551151,212.174937 155.368425,212.031988 C155.271468,211.957406 155.175755,211.880338 155.080041,211.809485 C154.867482,211.639189 154.659895,211.463921 154.454794,211.283681 L154.446093,211.276223 C154.245964,211.103441 154.050808,210.924444 153.860623,210.741718 L153.850679,210.729287 C153.751236,210.634817 153.654279,210.540346 153.557323,210.442146 C153.461609,210.343946 153.364652,210.24699 153.271424,210.14879 C153.176954,210.049347 153.082483,209.948661 152.990499,209.845489 C152.901,209.748533 152.813988,209.650333 152.726975,209.55089 L152.697142,209.517328 C152.248406,208.996496 151.828261,208.450804 151.43919,207.882737 L151.285054,207.655261 C151.183125,207.504854 151.082439,207.353203 150.982997,207.201553 L150.68964,206.750331 C150.545448,206.530314 150.404985,206.307811 150.268251,206.084064 C150.170051,205.924956 150.073095,205.765847 149.977381,205.605496 C149.896584,205.468762 149.815786,205.333271 149.738718,205.199023 C149.695212,205.125684 149.654192,205.051102 149.613172,204.97652 C149.572151,204.899452 149.523673,204.821141 149.480167,204.742829 L149.410557,204.619769 C149.386939,204.578749 149.379481,204.566318 149.367051,204.538972 C149.282524,204.39105 149.200484,204.240643 149.12093,204.08775 C149.084882,204.021869 149.048834,203.954745 149.0103,203.888864 L148.898426,203.675062 L148.787796,203.462503 L148.573994,203.03117 C148.539189,202.960317 148.505627,202.889464 148.472065,202.818611 C148.398726,202.665717 148.329116,202.51531 148.259506,202.364903 C148.232159,202.303994 148.20357,202.243085 148.178709,202.182177 C148.082995,201.97459 147.992254,201.764517 147.906484,201.551958 C147.848062,201.411495 147.794611,201.272275 147.737431,201.133055 C147.57708,200.722853 147.426673,200.308922 147.288696,199.89002 C147.247675,199.765716 147.206655,199.642656 147.170607,199.518352 C147.081109,199.236183 147.000311,198.951528 146.928215,198.664387 C146.83996,198.33001 146.761649,197.991905 146.695768,197.652556 C146.653505,197.452427 146.616214,197.251056 146.585138,197.048441 C146.551576,196.848312 146.522986,196.648184 146.499368,196.449298 C146.448404,196.05277 146.412356,195.654998 146.391224,195.255984 C146.391224,195.190103 146.385009,195.122979 146.383766,195.057098 C146.377551,194.925337 146.373822,194.793575 146.372579,194.661813 C146.302969,189.351566 148.991654,184.243934 154.738206,178.502354 C164.973359,168.275903 170.934956,153.306029 170.934956,153.306029 C170.934956,153.306029 171.095308,152.678296 171.429684,151.775852 C171.541557,151.476281 171.658403,151.177952 171.781463,150.883353 C171.921926,150.55022 172.072333,150.220815 172.233928,149.897626 L172.281163,149.803155 C172.48875,149.390468 172.71374,148.988967 172.958617,148.597411 C173.014554,148.50667 173.069248,148.415928 173.133885,148.32643 C173.315369,148.055448 173.508039,147.793167 173.710654,147.538345 C173.867276,147.343189 174.033843,147.154247 174.209111,146.97525 C174.803282,146.363677 175.480736,145.863977 176.247689,145.596724 L176.344646,145.565648 C176.409283,145.544517 176.472678,145.524628 176.538559,145.505982 C176.615627,145.486094 176.692696,145.467448 176.769764,145.451289 L176.804569,145.445074 C176.967406,145.412755 177.130244,145.39038 177.295568,145.379193 L177.310484,145.379193 C177.396253,145.379193 177.482023,145.370492 177.570278,145.370492 C177.790296,145.371735 178.00907,145.389137 178.226601,145.422699 C179.148933,145.568134 180.027759,146.117556 180.783525,146.965306 L180.885454,147.084637 C181.131575,147.373021 181.355321,147.681294 181.554207,148.004483 C181.703371,148.244389 181.843834,148.496725 181.976839,148.761492 C182.030289,148.873365 182.081254,148.975294 182.132218,149.084681 C182.157079,149.140618 182.181939,149.195311 182.205557,149.252491 C182.255278,149.363121 182.301271,149.474994 182.347263,149.591839 C182.607057,150.258106 182.808429,150.945505 182.950135,151.646577 C183.100542,152.403585 183.187555,153.171781 183.212416,153.943706 C183.221117,154.283055 183.221117,154.626132 183.212416,154.974182 C183.2062,155.105944 183.199985,155.238949 183.190041,155.371954 C183.088112,156.849923 182.766166,158.304274 182.234147,159.687772 C182.180696,159.824506 182.122274,159.963726 182.06758,160.102946 C181.800328,160.741866 181.489569,161.360898 181.139033,161.957555 C180.938904,162.298146 180.722616,162.636252 180.491411,162.971871 L180.349705,163.173243 C179.801527,163.938953 179.189953,164.657427 178.5212,165.321208 C177.862392,165.98126 177.156348,166.59159 176.409283,167.149713 C175.659733,167.702864 174.957418,168.316923 174.308554,168.984433 C172.440272,170.945943 172.005209,172.675005 172.425355,173.986407 C172.475077,174.134328 172.533499,174.279763 172.600623,174.420226 C172.756003,174.72477 172.957374,175.004453 173.198523,175.248088 L173.264404,175.313969 C173.332771,175.37985 173.404867,175.443244 173.478206,175.504153 L173.552788,175.565062 C173.734272,175.704282 173.925699,175.828585 174.125828,175.936729 C174.183007,175.967805 174.236458,175.998881 174.302339,176.028714 C174.577049,176.165448 174.864191,176.274835 175.160033,176.358118 L175.242073,176.37925 L175.352703,176.409083 L175.44966,176.432701 L175.552832,176.455075 L175.656004,176.476207 L175.754204,176.492366 C175.827543,176.50604 175.902125,176.517227 175.975464,176.527171 L176.04756,176.537116 L176.175593,176.550789 L176.255147,176.558247 L176.386909,176.568191 L176.462734,176.568191 L176.599468,176.574407 L177.030801,176.574407 L177.153862,176.568191 L177.295568,176.55949 L177.46835,176.543331 L177.629944,176.523442 C177.665992,176.523442 177.703283,176.513498 177.740574,176.507283 C178.309884,176.423999 178.864278,176.263648 179.388839,176.029957 C179.500712,175.982722 179.611342,175.930514 179.713271,175.875821 C179.932045,175.766434 180.144605,175.643373 180.348462,175.507882 C180.633117,175.321427 180.901613,175.111354 181.153949,174.882636 L181.329217,174.716069 C181.356564,174.688722 181.385154,174.662618 181.411257,174.634028 C181.582796,174.46249 181.744391,174.281006 181.894798,174.090822 C182.160808,173.755203 182.396984,173.398451 182.602085,173.023055 C185.034705,168.600335 187.584171,164.242253 190.247995,159.958754 L190.613448,159.373284 L190.982629,158.786572 C191.167842,158.490729 191.353054,158.197373 191.538266,157.907746 L191.725964,157.615632 L192.100118,157.032649 C192.602304,156.255752 193.105734,155.487556 193.612892,154.726818 L193.992018,154.159994 C194.752755,153.033804 195.51225,151.937447 196.263043,150.89454 L196.63844,150.379924 C197.455114,149.251248 198.306593,148.148675 199.190391,147.072207 L199.54217,146.652061 C199.59935,146.581208 199.6528,146.512841 199.716195,146.444474 L200.060516,146.04546 C200.117696,145.979579 200.172389,145.914941 200.232055,145.851546 L200.565188,145.474907 L200.732998,145.293423 C200.894593,145.118155 201.058673,144.945374 201.22524,144.773835 C201.337113,144.663205 201.440285,144.551331 201.548429,144.448159 C202.178648,143.803024 202.873505,143.225013 203.623055,142.724069 L203.795837,142.613439 L203.971105,142.501566 C204.082978,142.431956 204.196094,142.364832 204.311697,142.301437 C207.250232,140.634527 209.684095,140.511467 211.083753,141.911124 C211.932746,142.760117 212.40137,144.16599 212.37651,146.121285 C212.37651,146.208297 212.37651,146.294067 212.369051,146.383565 L212.369051,146.480522 C212.369051,146.568778 212.361593,146.659519 212.355378,146.750261 C212.355378,146.860891 212.341705,146.972764 212.330517,147.083394 C212.31933,147.195267 212.314358,147.279794 212.303171,147.377994 C212.303171,147.406583 212.296955,147.435173 212.293226,147.463763 C212.284525,147.550775 212.273338,147.639031 212.26215,147.726043 C212.26215,147.75339 212.26215,147.779494 212.250963,147.806841 C212.238533,147.924929 212.22113,148.043017 212.199999,148.159863 C212.186325,148.268007 212.168923,148.376151 212.147791,148.484295 C212.13909,148.546447 212.12666,148.607355 212.116715,148.669507 C212.084396,148.846018 212.042133,149.021286 211.991169,149.192825 C211.895455,149.513528 211.77861,149.828016 211.640633,150.133803 C211.580967,150.266808 211.517572,150.399812 211.452934,150.530331 C211.318687,150.80007 211.167036,151.076024 211.00047,151.361922 C210.917186,151.502385 210.831417,151.64782 210.739432,151.793255 L210.600212,152.014515 C210.458506,152.237019 210.310585,152.462008 210.156449,152.689483 C210.002312,152.916959 209.836989,153.149406 209.659235,153.38434 C209.429273,153.697585 209.186881,154.017045 208.930816,154.340234 L208.736902,154.585112 C208.188724,155.267539 207.626872,155.938778 207.05259,156.598829 L206.596396,157.114689 L206.363948,157.375726 C206.046974,157.729992 205.728757,158.081771 205.408054,158.431063 L205.161933,158.697073 C204.999095,158.873584 204.828799,159.052581 204.665962,159.230335 C204.499395,159.410575 204.330342,159.589572 204.161289,159.768569 L203.649159,160.308047 L203.130813,160.848767 C202.958031,161.029007 202.784006,161.211733 202.608738,161.391973 L201.553401,162.479629 C196.512893,167.649413 191.201403,172.801794 189.403974,176.016284 C189.284643,176.226357 189.176499,176.441402 189.078299,176.661419 C188.823477,177.245646 188.716576,177.745346 188.788672,178.149332 C188.81229,178.282337 188.859525,178.41037 188.927892,178.525972 C189.029821,178.70124 189.152881,178.862835 189.294587,179.007027 C189.360468,179.071664 189.428835,179.132573 189.503417,179.187267 C189.872599,179.45079 190.320091,179.586281 190.773799,179.572608 L190.915505,179.572608 L191.06094,179.562663 L191.207619,179.545261 L191.328193,179.527858 C191.344353,179.526615 191.360512,179.522886 191.376671,179.519157 L191.487302,179.498026 L191.517134,179.490567 L191.638952,179.464464 L191.812977,179.419714 L191.968356,179.373722 C192.070285,179.342646 192.172214,179.307841 192.276629,179.269307 C192.501618,179.189753 192.721636,179.097768 192.936681,178.994596 C192.991374,178.968493 193.047311,178.943632 193.100761,178.915042 L193.266085,178.833002 C193.482373,178.723615 193.697418,178.605526 193.913706,178.477494 C194.086488,178.375565 194.258027,178.27115 194.429566,178.16052 L194.596133,178.049889 C194.650826,178.015084 194.706763,177.979036 194.761457,177.938016 L194.92678,177.827386 L195.013793,177.766477 L195.252455,177.599911 C195.474959,177.445774 195.682546,177.287909 195.893862,177.127557 L195.912507,177.113884 L196.245641,176.855333 C196.701835,176.494852 197.135654,176.131886 197.52721,175.790051 L197.788247,175.56009 L197.813108,175.537715 L197.948599,175.417141 C198.269302,175.13 198.5552,174.861504 198.793863,174.639001 L198.89082,174.54453 L199.125753,174.322027 L199.266216,174.185293 L199.314695,174.135571 L199.328368,174.121898 C199.4477,174.002567 199.4477,174.002567 199.567031,173.881992 L199.576975,173.872048 L199.621725,173.832271 C199.635398,173.817354 199.654043,173.802438 199.675175,173.783792 L199.692578,173.767633 L199.739813,173.72537 L199.992149,173.502866 L200.133855,173.374834 C200.203465,173.315168 200.27929,173.246801 200.356358,173.173462 L200.526654,173.024298 C200.556487,172.999437 200.58632,172.970847 200.617396,172.9435 L200.79515,172.788121 L201.05743,172.559403 L201.195407,172.438828 C201.736128,171.967718 202.394936,171.399651 203.149459,170.759487 L203.458975,170.49845 L203.971105,170.069603 L204.49318,169.632054 C205.176849,169.06523 205.912726,168.462358 206.690866,167.835868 L207.201754,167.425667 C207.636816,167.080103 208.084309,166.725838 208.536774,166.37033 C208.718257,166.227381 208.903469,166.084432 209.09241,165.942726 C209.556063,165.584732 210.022201,165.22798 210.489582,164.876201 C211.556106,164.070715 212.656193,163.263985 213.768709,162.477143 L214.247278,162.145253 C214.580411,161.914048 214.913545,161.684087 215.247921,161.459097 L215.549979,161.253997 C216.147879,160.851253 216.750751,160.457211 217.358595,160.07187 L217.660653,159.881686 L217.960224,159.69523 C218.259796,159.510018 218.559367,159.326049 218.85521,159.148295 L219.152295,158.971784 L219.747709,158.624977 C219.942866,158.511861 220.136779,158.401231 220.330693,158.291843 L220.447538,158.225963 L220.909947,157.973626 C221.101374,157.869211 221.294045,157.768526 221.484229,157.670326 L221.770127,157.523648 L222.046081,157.383185 C222.677543,157.066211 223.320192,156.772854 223.974029,156.504359 C224.063528,156.467068 224.151783,156.43102 224.240039,156.392486 C224.415307,156.319146 224.589331,156.252023 224.762113,156.192357 C224.934895,156.133934 225.105191,156.073025 225.273001,156.01336 C225.425894,155.962395 225.573815,155.91516 225.718008,155.870411 L225.766486,155.855494 C225.843554,155.831877 225.920622,155.809502 225.99769,155.789613 L226.020065,155.783398 C226.176688,155.738649 226.33331,155.697629 226.491175,155.660338 L226.503606,155.660338 C226.736053,155.604401 226.962286,155.557166 227.183546,155.519875 C227.259371,155.507444 227.333953,155.495014 227.406049,155.48507 C227.621095,155.452751 227.837383,155.430376 228.053671,155.41546 C228.190405,155.405516 228.328382,155.401786 228.465116,155.401786 L228.56953,155.401786 C228.70875,155.401786 228.842998,155.410488 228.976003,155.424161 C229.036912,155.424161 229.09782,155.435348 229.157486,155.44405 L229.182347,155.44405 C229.242013,155.450265 229.302921,155.460209 229.361344,155.472639 C229.419767,155.48507 229.479432,155.493771 229.536612,155.507444 L229.556501,155.507444 C229.61368,155.519875 229.667131,155.536034 229.726796,155.552194 C230.201636,155.680226 230.637941,155.921375 230.999664,156.254509 L231.031983,156.286828 L231.095378,156.348979 L231.15753,156.41486 C231.655987,156.939421 232.068675,157.539807 232.379434,158.193644 L232.427912,158.304274 C232.53357,158.552881 232.616853,158.810189 232.675276,159.073713 C232.836871,159.808347 232.793364,160.574056 232.548486,161.285072 C232.442828,161.594588 232.313553,161.895403 232.160659,162.183787 L232.058731,162.367756 C231.670904,163.017864 231.213467,163.623222 230.692635,164.172643 L230.580762,164.290732 C230.335884,164.550526 230.081061,164.802862 229.818781,165.045254 C229.735498,165.123565 229.649728,165.201877 229.562716,165.280188 L229.430954,165.399519 C229.157486,165.641911 228.877803,165.878088 228.594391,166.109292 C228.54467,166.14907 228.493705,166.188847 228.445227,166.23111 C228.247584,166.390218 228.043727,166.551813 227.832411,166.713408 C227.103992,167.270287 226.3619,167.807279 225.606134,168.325624 C225.161128,168.630168 224.701205,168.937198 224.226365,169.2492 C223.341324,169.829697 222.450068,170.397764 221.55011,170.954644 C221.290316,171.114996 221.029278,171.277833 220.763269,171.439428 C218.318218,172.9435 215.607158,174.551988 212.715858,176.300939 L211.967551,176.75589 C211.148391,177.25559 210.375223,177.732915 209.648047,178.186623 L209.281352,178.417828 L208.587738,178.862835 C208.313027,179.036859 208.045775,179.208398 207.78598,179.377451 C207.589581,179.502998 207.398153,179.627301 207.210455,179.750362 L206.840031,179.993997 C206.65979,180.112085 206.480793,180.230173 206.301796,180.350748 L206.127771,180.461378 C205.943802,180.584438 205.764805,180.705013 205.59078,180.824344 L205.306125,181.018258 L204.971748,181.250705 L204.663476,181.46575 C204.176206,181.807585 203.695151,182.156878 203.217826,182.512386 L203.051259,182.639176 C202.863561,182.780882 202.682077,182.922588 202.506809,183.060565 L202.278091,183.243291 C201.89275,183.552807 201.543457,183.849892 201.227726,184.133304 L201.07359,184.27501 C200.985334,184.355808 200.898322,184.436605 200.816281,184.516159 C200.757859,184.570853 200.704408,184.626789 200.645986,184.681483 L200.565188,184.761037 C200.387434,184.938791 200.214652,185.121517 200.046843,185.309216 L199.964802,185.403686 C199.782076,185.615002 199.622968,185.817617 199.482505,186.01526 L199.420353,186.104758 C199.258758,186.340935 199.115809,186.590785 198.993992,186.850579 L198.951729,186.941321 L198.925625,187.004716 L198.904493,187.059409 L198.875903,187.135234 C198.867202,187.161338 198.8498,187.20733 198.839855,187.247108 C198.788891,187.395029 198.7516,187.547922 198.726739,187.703302 L198.714309,187.786585 L198.704365,187.86241 L198.698149,187.935749 L198.698149,188.326062 C198.698149,188.358381 198.698149,188.391943 198.705608,188.425505 C198.706851,188.445394 198.709337,188.465282 198.711823,188.485171 C198.711823,188.51749 198.720524,188.549809 198.724253,188.583371 L198.747871,188.720104 L198.747871,188.72632 C198.756572,188.769826 198.765273,188.813332 198.776461,188.856838 C198.787648,188.900345 198.798835,188.948823 198.812509,188.994815 C198.852286,189.135278 198.900764,189.274498 198.956701,189.409989 C198.956701,189.419933 198.965402,189.431121 198.969131,189.441065 C198.984047,189.474627 198.997721,189.509432 199.01388,189.542994 C199.074789,189.6847 199.143156,189.822677 199.217738,189.958168 L199.296049,190.098631 L199.37809,190.240337 L199.463859,190.382043 C199.478775,190.40566 199.494935,190.426792 199.51358,190.447923 L199.54217,190.477756 L199.572003,190.505103 L199.605565,190.531207 C199.62794,190.547366 199.651557,190.56104 199.676418,190.574713 C199.701279,190.5859 199.728626,190.598331 199.755972,190.608275 C199.785805,190.618219 199.815638,190.626921 199.845471,190.634379 C200.562702,190.795973 202.036942,190.201803 203.994723,189.167597 L204.346502,188.981142 L204.941916,188.65671 L205.234029,188.495115 C205.440373,188.383242 205.652932,188.258938 205.867977,188.135878 L206.262019,187.913375 C208.851262,186.422975 211.945176,184.507458 215.142263,182.637933 C215.440592,182.462665 215.741406,182.28864 216.042221,182.114615 L216.646336,181.729274 C216.948394,181.555249 217.249208,181.38371 217.551266,181.214657 C218.836564,180.483753 220.139265,179.781438 221.455639,179.108956 L222.046081,178.809384 C222.43888,178.615471 222.82795,178.426529 223.212048,178.24256 C223.956627,177.889538 224.708663,177.555161 225.468157,177.238187 L225.884574,177.069135 L225.935539,177.049246 C228.140683,176.175392 230.140727,175.634672 231.759159,175.634672 C232.109695,175.632186 232.458988,175.660776 232.804552,175.720441 L232.814496,175.720441 C232.926369,175.74033 233.027055,175.762705 233.128984,175.788808 L233.147629,175.788808 C233.296794,175.824856 233.443472,175.870849 233.585178,175.928028 C233.698294,175.969048 233.807681,176.017527 233.913339,176.074706 C234.376991,176.30964 234.77352,176.656447 235.069362,177.084051 C235.094223,177.120099 235.11784,177.15739 235.140215,177.195924 C235.249602,177.362491 235.344073,177.537759 235.421141,177.721728 C235.467133,177.827386 235.509397,177.936773 235.549174,178.054862 C235.588951,178.174193 235.623756,178.288552 235.659804,178.411613 C235.923327,179.353833 235.897224,180.350748 235.585222,181.278052 L235.585222,181.274323 Z"
                                fill="#FF9D00"
                              ></path>
                              <path
                                d="M220.830393,113.727785 L220.830393,113.118698 C220.830393,61.0976708 178.666636,18.9214832 126.633178,18.9214832 C74.6121511,18.9214832 32.4235332,61.0976708 32.4235332,113.118698 L32.4208548,113.322556 C32.4208548,113.458046 32.4208548,113.592294 32.4208548,113.727785 C32.4282567,113.9304 32.4303699,114.133015 32.4285053,114.335629 L32.4359635,114.783122 L32.4384496,114.944717 L32.4446648,115.165977 C32.4471509,115.285308 32.45088,115.403397 32.45088,115.522728 L32.4633103,116.006269 L32.4831989,116.574336 L32.4894141,116.760791 L32.5142748,117.348747 L32.5142748,117.376094 L32.5490798,118.063492 L32.5490798,118.080895 C32.5615101,118.315828 32.5739405,118.550762 32.5888569,118.784453 C32.6012872,119.001984 32.6149606,119.218272 32.6298771,119.43456 L32.6336062,119.473094 C32.6445449,119.658307 32.6569752,119.844762 32.6708972,120.029974 L32.6746263,120.078452 C32.6870567,120.25745 32.7007301,120.43769 32.7156465,120.615444 L32.7181326,120.650249 L32.7429933,120.961008 C32.8174511,121.857236 32.9044635,122.753464 33.0040307,123.647207 L33.0102459,123.703143 L33.084828,124.359466 L33.1705974,125.050594 C33.2281499,125.510517 33.2895559,125.969197 33.3545666,126.427877 C33.3933493,126.705074 33.4336237,126.981027 33.4751411,127.256981 L33.4813562,127.290543 C33.574211,127.914547 33.6743996,128.538551 33.7821708,129.160068 C34.0913136,130.963713 34.4544043,132.758655 34.8710697,134.541168 L34.8772849,134.569758 L34.917062,134.737568 C34.9543531,134.896676 34.9916441,135.055785 35.0314212,135.216136 L35.0997882,135.132853 C37.8344658,131.86367 41.7574852,130.061269 46.1466428,130.061269 C49.6644327,130.061269 53.2742072,131.223507 56.8901969,133.516907 C59.289255,135.040868 61.9418923,137.740741 64.6715978,141.13547 C67.1974455,137.626382 70.7376101,135.295691 74.7874191,134.659256 C75.560587,134.537439 76.3412132,134.475287 77.1218393,134.474044 C86.3662928,134.474044 91.93882,142.496594 94.0395497,149.713657 C95.0774842,152.152492 100.086916,163.250311 107.638356,170.770675 C119.117787,182.240161 121.995413,194.077587 116.30977,206.744116 L116.328416,206.744116 C116.716243,206.786379 117.105313,206.826157 117.495626,206.862205 C117.728073,206.884579 117.960521,206.906954 118.192968,206.926842 L118.275009,206.934301 C118.445305,206.95046 118.616844,206.965376 118.788382,206.977807 L119.260736,207.016341 C119.710715,207.051146 120.161936,207.082222 120.615644,207.112055 L120.973638,207.133186 L121.258294,207.149346 L121.436048,207.15929 L121.990441,207.189123 L122.142092,207.195338 L122.726318,207.220199 L123.37394,207.245059 L123.896014,207.259976 L123.983027,207.263705 C124.092414,207.267434 124.204287,207.272406 124.314917,207.272406 L124.433006,207.274892 C125.166396,207.292295 125.898544,207.300996 126.631935,207.300996 L127.410075,207.300996 L127.966955,207.294781 C128.103689,207.287323 128.23918,207.287323 128.375914,207.287323 L128.592202,207.287323 L128.7799,207.283594 C128.853239,207.281107 128.927821,207.278621 129.00116,207.278621 L129.223664,207.278621 L129.659969,207.266191 L130.316292,207.243816 L131.039738,207.212741 C131.247325,207.204039 131.453669,207.194095 131.661256,207.182908 L131.883759,207.170477 L132.213164,207.151832 L132.40832,207.140644 L132.553755,207.131943 L133.221265,207.087194 C133.443769,207.073521 133.666272,207.056118 133.888775,207.038716 L134.49289,206.99148 L134.919251,206.955432 L135.38539,206.913169 C135.863958,206.86842 136.341284,206.821184 136.816123,206.771463 C137.119424,206.737901 137.420238,206.704339 137.722296,206.668291 L138.253072,206.604896 C132.660656,193.988088 135.555685,182.204113 146.989124,170.780619 C154.524404,163.251554 159.53135,152.14752 160.5755,149.711171 C162.679959,142.495351 168.242542,134.471558 177.49321,134.471558 C178.275079,134.472801 179.055706,134.53371 179.827631,134.65677 C183.87371,135.293204 187.415118,137.625139 189.944695,141.132984 C192.675643,137.738255 195.327038,135.038382 197.726096,133.514421 C201.342085,131.221021 204.954346,130.058783 208.468407,130.058783 C212.341705,130.058783 215.853279,131.463413 218.504674,134.038982 C218.650109,133.390117 218.790572,132.741253 218.92482,132.089903 C219.00686,131.68343 219.087657,131.275714 219.167212,130.866756 C219.264168,130.36457 219.356153,129.859897 219.440679,129.355225 C219.463054,129.218491 219.486672,129.081757 219.512775,128.94378 C219.553795,128.728735 219.589844,128.516176 219.623405,128.299888 L219.637079,128.217848 L219.725334,127.654753 L219.812347,127.084199 L219.81359,127.077984 C219.848395,126.839321 219.884443,126.599416 219.916762,126.35951 C219.942866,126.178027 219.967726,125.996543 219.991344,125.813817 L220.00626,125.709402 L220.083329,125.115231 L220.146723,124.609316 C220.185257,124.276183 220.222548,123.943049 220.258597,123.608673 C220.274756,123.475668 220.288429,123.34142 220.302103,123.207172 L220.314533,123.099028 C220.338151,122.876525 220.359282,122.655265 220.379171,122.432761 L220.428892,121.915659 C220.532064,120.76958 220.615348,119.623502 220.679985,118.474937 L220.679985,118.467479 L220.713547,117.858391 L220.719763,117.721658 L220.744623,117.143646 C220.754568,116.926115 220.763269,116.706098 220.770727,116.483594 L220.770727,116.467435 L220.776942,116.307083 C220.783157,116.170349 220.78813,116.033616 220.78813,115.898125 L220.790616,115.842188 C220.795588,115.715399 220.80056,115.583637 220.80056,115.453118 L220.804289,115.341245 C220.808018,115.210726 220.811747,115.081451 220.811747,114.950932 L220.814233,114.840302 C220.817962,114.673735 220.821691,114.508411 220.821691,114.341845 L220.830393,113.727785 Z M103.276545,207.837987 C110.736,196.896791 110.20771,188.682813 99.9713141,178.452633 C89.7349185,168.222452 83.7745642,153.256307 83.7745642,153.256307 C83.7745642,153.256307 81.5507741,144.565005 76.4791901,145.364276 C71.4076061,146.162305 67.6872015,159.149538 78.3052089,167.092533 C88.9232164,175.041744 76.193292,180.430302 72.1061919,172.97209 C68.0178488,165.511392 56.8665792,146.333844 51.0740347,142.66689 C45.2889485,138.998693 41.220494,141.054673 42.5841037,148.614814 C43.2615579,152.367537 49.5612608,158.771655 55.449519,164.749412 C61.4210605,170.821639 66.966241,176.458804 65.7816283,178.447661 C63.4285625,182.410457 55.1412462,173.792494 55.1412462,173.792494 C55.1412462,173.792494 29.1866693,150.174823 23.5432891,156.327848 C18.3362142,161.999818 26.3662222,166.821552 38.7456107,174.252417 C39.7984616,174.885122 40.8823884,175.536472 41.9924189,176.207711 C56.1505909,184.779683 57.2568923,187.040764 55.2431751,190.278871 C54.5010831,191.477157 49.7613895,188.631849 43.9315539,185.131462 C33.9934868,179.164892 20.8856796,171.296479 19.033557,178.339517 C17.4312845,184.434119 27.0722663,188.168197 35.8145335,191.552982 C43.0987203,194.374672 49.7613895,196.955213 48.7793916,200.458087 C47.7638318,204.088993 42.2584284,201.060959 36.2371655,197.749513 C29.4812687,194.031594 22.0789935,189.958168 19.6550747,194.554912 C15.0757326,203.243729 51.2406015,213.473909 51.5389299,213.548491 C63.2234617,216.579011 92.8947142,223.000532 103.274059,207.801939 L103.276545,207.837987 Z M151.332289,207.837987 C143.871592,196.896791 144.401125,188.682813 154.63752,178.452633 C164.873916,168.222452 170.83427,153.256307 170.83427,153.256307 C170.83427,153.256307 173.056817,144.565005 178.128401,145.364276 C183.199985,146.162305 186.921633,159.149538 176.302382,167.092533 C165.683132,175.035529 178.414299,180.430302 182.502642,172.97209 C186.589743,165.511392 197.742255,146.333844 203.522369,142.66689 C209.302483,138.999936 213.377153,141.054673 212.013543,148.614814 C211.336089,152.367537 205.036386,158.772898 199.148128,164.761842 C193.17783,170.832827 187.632649,176.469992 188.817262,178.460091 C191.169085,182.422888 199.463859,173.799952 199.463859,173.799952 C199.463859,173.799952 225.418436,150.182281 231.061816,156.335306 C236.268891,162.007276 228.23764,166.830253 215.859495,174.259875 C214.806644,174.891337 213.72396,175.541444 212.613929,176.213926 C198.455757,184.784655 197.349456,187.046979 199.363173,190.285086 C200.105265,191.483372 204.844959,188.638064 210.673551,185.13892 C220.612862,179.17235 233.719426,171.303937 235.571548,178.345732 C237.173821,184.440334 227.532839,188.175655 218.790572,191.559197 C211.506385,194.380887 204.843716,196.960185 205.825714,200.464302 C206.841274,204.095208 212.344191,201.065931 218.355509,197.754485 C225.111406,194.036566 232.513681,189.961897 234.9376,194.559884 C239.516942,203.254916 203.352073,213.478881 203.053745,213.553464 C191.369213,216.592685 161.697961,223.014205 151.331046,207.815613 L151.332289,207.837987 Z"
                                fill="#FFD21E"
                              ></path>
                              <path
                                d="M157.311289,87.4748797 C158.779314,87.9944685 159.871942,89.5768524 160.911119,91.0809251 C162.315749,93.1157739 163.623422,95.0076736 165.629681,93.9411493 C167.997664,92.6831976 169.938042,90.7515208 171.207181,88.3897537 C172.47632,86.0279866 173.015797,83.3442734 172.758489,80.6754767 C172.567061,78.680405 171.935599,76.7524573 170.908852,75.0308534 C169.882105,73.3092495 168.486176,71.8362527 166.822995,70.718764 C165.158571,69.6015238 163.266671,68.8678844 161.285273,68.5695559 C159.302632,68.2713518 157.27897,68.4166626 155.359724,68.9947983 C152.792856,69.767842 150.513129,71.2844693 148.807685,73.3528801 C147.103483,75.4212908 146.049389,77.9483815 145.779651,80.6146922 C145.511155,83.282246 146.039445,85.9696883 147.297397,88.3364275 C148.227187,90.0853781 150.290626,89.2612457 152.468424,88.389878 C154.176354,87.7074516 155.953895,86.9964354 157.311289,87.475004 L157.311289,87.4748797 Z M93.4441358,87.4761228 C91.9761111,87.9957115 90.88224,89.5780954 89.8430625,91.0821681 C88.4384327,93.1157739 87.1307595,95.0089166 85.1245006,93.9423924 C83.3556613,93.0014146 81.8180267,91.6788251 80.6209837,90.0715805 C79.4239407,88.4643358 78.5985653,86.6122132 78.20328,84.6469744 C77.8079948,82.6829787 77.8527441,80.6543451 78.3350418,78.7102379 C78.8185825,76.7648876 79.7259983,74.9512991 80.9926512,73.3987481 C82.2617903,71.84744 83.8578476,70.5969465 85.667707,69.735523 C87.4775664,68.8740996 89.4564786,68.4266069 91.4602515,68.4216028 C93.4640244,68.4172841 95.4441796,68.8571943 97.2577681,69.7094193 C99.0713566,70.5620172 100.673629,71.8064198 101.948983,73.3515127 C103.654428,75.4199234 104.708522,77.9470142 104.97826,80.6145679 C105.246756,83.2821217 104.718466,85.969564 103.459271,88.3363032 C102.526995,90.0852538 100.463556,89.2598784 98.2857583,88.3885107 C96.5790708,87.7060843 94.8015303,86.9950681 93.4441358,87.4748797 L93.4441358,87.4761228 Z M147.429159,145.588023 C157.551195,137.612708 161.264141,124.593157 161.264141,116.575579 C161.264141,110.236099 156.998044,112.231171 150.170051,115.610984 L149.785954,115.802411 C143.517327,118.90627 135.167858,123.038119 126.019119,123.038119 C116.859192,123.038119 108.517182,118.905027 102.252284,115.801168 C95.2030307,112.309482 90.7815542,110.119254 90.7815542,116.576822 C90.7815542,124.849222 94.7368925,138.429383 105.598535,146.322657 C107.030512,143.413954 109.046715,140.83217 111.522841,138.738898 C113.997724,136.645627 116.87908,135.086861 119.985425,134.158313 C121.069352,133.835124 122.185598,135.70092 123.32919,137.610222 C124.431763,139.453644 125.557953,141.338085 126.705274,141.338085 C127.925935,141.338085 129.126707,139.48099 130.298889,137.667402 C131.523279,135.773016 132.716593,133.925866 133.871373,134.295047 C139.683806,136.160843 144.545317,140.206923 147.432888,145.584294 L147.429159,145.588023 Z"
                                fill="#32343D"
                              ></path>
                              <path
                                d="M147.367007,145.624071 C142.095294,149.778295 135.088304,152.563937 125.961939,152.563937 C117.388725,152.563937 110.685035,150.105213 105.538869,146.362434 C106.972089,143.454974 108.989535,140.87319 111.464418,138.781161 C113.939302,136.68789 116.820658,135.127881 119.92576,134.19809 C122.055079,133.562899 124.309945,141.377862 126.644365,141.377862 C129.144109,141.377862 131.551869,133.612621 133.811707,134.334824 C139.621654,136.201863 144.481922,140.247943 147.373222,145.624071 L147.367007,145.624071 Z"
                                fill="#FF323D"
                              ></path>
                              <path
                                d="M69.2173779,98.7616402 C68.2555172,99.4092616 67.1750709,99.8604834 66.0389367,100.089202 C64.9023052,100.31792 63.7318631,100.320406 62.5944859,100.09666 C61.4569843,99.8716707 60.3744248,99.425421 59.4098294,98.7827718 C58.445234,98.1388795 57.6173725,97.312261 56.9734803,96.3476657 C56.3292151,95.3843133 55.8815981,94.3016296 55.6558628,93.1654953 C55.4305005,92.028118 55.4317436,90.8571788 55.6595919,89.7198015 C55.8874403,88.5836672 56.3375434,87.5034695 56.9834245,86.5401172 C57.6298029,85.5777593 58.4601505,84.7526324 59.4259889,84.1112262 C61.3688531,82.8221986 63.7442935,82.3548173 66.0302354,82.8134974 C68.3161773,83.2721774 70.3286515,84.6183846 71.6238942,86.5562766 C72.919137,88.4954117 73.3939765,90.8683661 72.9427547,93.155551 C72.4915329,95.443979 71.1515408,97.4601822 69.2173779,98.7616402 L69.2173779,98.7616402 Z M195.261157,98.7616402 C194.299047,99.4092616 193.21885,99.8604834 192.082715,100.089202 C190.946581,100.31792 189.775642,100.320406 188.638265,100.09666 C187.500887,99.8716707 186.418204,99.425421 185.453608,98.7827718 C184.489013,98.1388795 183.661151,97.312261 183.017259,96.3476657 C182.372124,95.3843133 181.924631,94.3016296 181.699642,93.1654953 C181.474652,92.028118 181.475895,90.8571788 181.703371,89.7198015 C181.930846,88.5836672 182.380825,87.5034695 183.027203,86.5401172 C183.673582,85.5777593 184.503929,84.7526324 185.469768,84.1112262 C187.412632,82.8221986 189.788072,82.3548173 192.074014,82.8134974 C194.359956,83.2721774 196.371187,84.6183846 197.667673,86.5562766 C198.962916,88.4954117 199.437755,90.8683661 198.986534,93.155551 C198.535312,95.443979 197.19532,97.4601822 195.261157,98.7616402 L195.261157,98.7616402 Z"
                                fill="#FFAD03"
                              ></path>
                            </g>
                          </svg>
                        </div>
                      </div>
                      <div className="flex items-center gap-2 ml-[calc(50%-1rem)] relative">
                        <div className="ring-4 ring-white size-8 dark:ring-[--card-dark-bg]">
                          <svg
                            className="text-black border rounded-full dark:text-white border-neutral-950/5 size-full dark:border-white/5"
                            width="32"
                            height="32"
                            viewBox="0 0 32 32"
                            xmlns="http://www.w3.org/2000/svg"
                          >
                            <path
                              fillRule="evenodd"
                              clipRule="evenodd"
                              fill="currentColor"
                              d="M0 0H24.8889V3.55556H28.4444V7.11106H32L32 32H0V0ZM17.7778 3.55554H21.3333V7.1111H17.7778V3.55554ZM24.8889 10.6668V7.11121L21.3333 7.1111V10.6667H17.7778V14.2223H21.3333V10.6667L24.8889 10.6668ZM24.8889 10.6668L28.4445 10.6667V14.2223H24.8889L24.8889 10.6668ZM3.55556 3.55558H7.11111V7.11114H3.55556V3.55558ZM10.6667 7.11121L7.11111 7.11114L7.11112 10.6668L3.55556 10.6667V14.2223H7.11112V10.6668H10.6667L10.6667 14.2223H14.2222V10.6667L10.6667 10.6668V7.11121ZM10.6667 7.11121L10.6667 3.55554H14.2222V7.1111L10.6667 7.11121ZM7.11112 21.3334H3.55556V24.8889L7.1111 24.8889V28.4444H24.8889V24.8889L28.4445 24.8889V21.3334H24.8889L24.8889 24.8889H7.1111L7.11112 21.3334Z"
                            ></path>
                          </svg>
                        </div>
                        <span className="block px-2 py-1 text-xs border rounded-md shadow-xs dark:text-white h-fit dark:bg-neutral-800 dark:border-white/5">
                          Leaderboard
                        </span>
                      </div>
                      <div className="flex items-center justify-end gap-2 w-[calc(50%+0.875rem)] relative">
                        <span className="block px-2 py-1 text-xs border rounded-md shadow-xs dark:text-white h-fit dark:bg-neutral-800 dark:border-white/5">
                          Output
                        </span>
                        <div className="ring-4 ring-white size-8 dark:ring-[--card-dark-bg]">
                          <svg
                            className="bg-white border rounded-full size-full border-neutral-950/5 dark:border-white/5"
                            viewBox="10 10 50 56"
                          >
                            <path
                              fill="#000000"
                              fillOpacity="1"
                              strokeLinejoin="round"
                              d="M 28.9408,48.083C 30.7435,48.0786 30.6029,47.6411 30.6449,46.6938C 30.6331,45.8004 30.3702,45.1218 30.0375,44.7629C 29.7021,44.4131 29.2248,44.1859 28.8804,44.0755L 28.574,43.9912L 24.5287,43.9912C 24.1218,43.9937 23.8649,44.0773 23.6573,44.1877C 23.4509,44.2988 23.2871,44.4513 23.1485,44.6309C 22.9409,44.8931 22.8168,45.4701 22.7658,45.6328L 22.7658,48.0984L 28.9408,48.083 Z M 22.4101,56.306C 21.6926,55.8749 21.1905,55.2989 20.8552,54.7541C 20.1872,53.6569 20.105,52.6802 20.0885,52.5666L 20.0828,52.5028L 20.0828,45.3388L 20.1064,45.2138C 20.1235,45.1332 20.2158,44.6657 20.5162,44.0572C 20.8162,43.4555 21.3423,42.1827 22.2666,41.6416C 22.8782,41.2831 23.6562,41.0558 24.5287,41.0583L 28.7831,41.0583L 28.8731,41.0704C 28.9563,41.0832 29.5293,41.1632 30.2758,41.4906C 31.0146,41.8165 31.963,42.91 32.6212,43.997C 33.0578,44.7167 33.3313,45.638 33.3285,46.6938C 33.3309,47.7365 33.0778,48.1383 32.6514,48.8433C 32.2283,49.5498 31.6549,50.0381 31.1136,50.3541C 30.0227,50.9836 29.0652,51.0181 28.9467,51.0309L 22.7658,51.0324L 22.7658,51.6006L 22.7861,51.7055C 22.8118,51.8276 22.8605,52.7576 22.9396,52.9519C 23.1016,53.3467 23.3666,53.7522 23.7919,54.0051C 24.0808,54.1756 24.4661,54.3138 25.0965,54.3171L 30.4726,54.3171L 30.4725,56.9996L 25.0793,57C 24.0318,57 23.1217,56.7364 22.4101,56.306 Z M 29.1816,25.7219C 39.0365,26.0845 47.4953,34.3427 48.1761,44.1133L 45.4863,44.1133C 45.1592,40.0728 43.1425,36.1989 40.4388,33.4937C 37.5917,30.6484 33.4783,28.5881 29.1816,28.4051L 29.1816,25.7219 Z M 29.1816,32.6739C 35.4741,33.0222 40.5547,37.9069 41.208,44.1133L 38.5042,44.1133C 38.2025,41.8568 37.1631,39.8404 35.6296,38.3043C 33.9494,36.626 31.6958,35.54 29.1816,35.3641L 29.1816,32.6739 Z M 29.1816,19C 43.3959,19.1734 55.005,30.1578 56.1672,44.1133L 53.4741,44.1133C 52.9278,38.1998 50.3054,32.8968 46.3361,28.9249C 41.9295,24.5201 35.8822,21.7734 29.1816,21.6829L 29.1816,19 Z "
                            />
                          </svg>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>
  );
}
