# Нейронные сети и глубинное обучение

* [Лекции по искусственным нейронным сетям — К. В. Воронцов](http://www.ccas.ru/voron/download/NeuralNets.pdf) (pdf)
* [Нейронные сети от Института Биоинформатики](https://stepic.org/s/eg4Xe6Ry)
* [Искусственный интеллект и машинное обучение (лекции)](https://ulearn.me/Course/AIML/) — приятные и качественные лекции по широкому набору тем. Один из немногих из источников на русском языке
* [Neural Networks for Machine Learning (Geoffrey Hinton, University of Toronto)](https://www.coursera.org/learn/neural-networks). Цитата: «Я уже использовал фразу "живая легенда" и теперь испытываю сложности, поскольку как-то иначе охарактеризовать Джеффри Хинтона (человека, стоящего у истоков современных подходов к обучению нейросетей с помощью алгоритма обратного распространения ошибки) сложно. Курс у него получился отличный»
* [Neural Networks and Deep Learning – бесплатная онлайн-книга по нейросетям и глубинному обучению](http://neuralnetworksanddeeplearning.com/index.html) 
* [Neural Networks and Deep Learning (github repo)](https://github.com/mnielsen/neural-networks-and-deep-learning))
* [CS231n: Convolutional Neural Networks for Visual Recognition (Stanford University)](http://vision.stanford.edu/teaching/cs231n/) 
    * :octocat: [CS231n (github repo)](https://github.com/cs231n))
* [Tensorflow Neural Network Playground – игрушечные нейросети в браузере](http://playground.tensorflow.org/)  
    * :octocat: [TensorFlow Playground (github repo)](https://github.com/tensorflow/playground))
* [awesome-rnn – awesome recurrent neural networks](https://github.com/kjw0612/awesome-rnn)
* [nmn2 – dynamically predicted neural network structures for multi-domain question answering](https://github.com/jacobandreas/nmn2)
* [Nervana's Deep Learning Course](https://www.nervanasys.com/deep-learning-tutorials/)

## Deep Learning

* [A great list of deep learning resources](https://omtcyfz.github.io/2016/08/29/Deep-Learning-Resources.html)
* [Deep Learning - Ian Goodfellow, Yoshua Bengio, and Aaron Courville (2016)](http://www.deeplearningbook.org)
* [Deep Learning (by Google)](https://www.udacity.com/course/deep-learning--ud730)
* [Deep Learning (Oxford, 2015, videos)](https://www.youtube.com/playlist?list=PLE6Wd9FR--EfW8dtjAuPoTuPcqmOV53Fu)
* [Machine Learning (Oxford, 2016-2017)](http://www.cs.ox.ac.uk/teaching/courses/2016-2017/ml/)
* [awesome-deep-vision – a curated list of deep learning resources for computer vision](https://github.com/kjw0612/awesome-deep-vision)
* [awesome-deep-learning-papers – a curated list of the most cited deep learning papers (since 2010)](https://github.com/terryum/awesome-deep-learning-papers)
* [Deep Learning Papers by task](https://github.com/sbrugman/deep-learning-papers)
* [A Deep Learning toolkit for Computer Vision](https://luminoth.ai)
* [Deep Learning Tutorials](https://github.com/subokita/DeepLearningTutorials)
* [dl-docker – an all-in-one Docker image for deep learning (Contains all the popular DL frameworks (TensorFlow, Theano, Torch, Caffe, etc.))](https://github.com/saiprashanths/dl-docker)
* [FloydHub – a Platform-as-a-Service for training and deploying your deep learning models in the cloud (Heroku for DL)](https://www.floydhub.com/)
* Материалы от NVIDIA:
    * [Self-Study Courses for Deep Learning](https://developer.nvidia.com/deep-learning-courses)
    * [Online Self-Paced Labs](https://developer.nvidia.com/dli/onlinelabs)
* [deep-rl-tensorflow – TensorFlow implementation of Deep Reinforcement Learning papers](https://github.com/carpedm20/deep-rl-tensorflow)
* [TensorFlow 101 – Tensorflow tutorials](https://github.com/sjchoi86/Tensorflow-101)
* [Introduction to Deep Learning for Image Recognition](https://github.com/rouseguy/scipyUS2016_dl-image) – this notebook accompanies the Introduction to Deep Learning for Image Recognition workshop to explain the core concepts of deep learning with emphasis on classifying images as the application
* [Deep Learning Papers Reading Roadmap](https://github.com/songrotek/Deep-Learning-Papers-Reading-Roadmap)
* [Learning Python in Deep (videos)](https://www.youtube.com/watch?v=jqo1fPEJwDw&list=PLbW_am_GRTo1vIxMK4jUc9ZLvW-P6QL6N)
* [Practical Deep Learning For Coders](http://course.fast.ai)
* [Глубинное обучение (курс лекций)](http://www.machinelearning.ru/wiki/index.php?title=Dl)
* [Deep Learning (Лемпицкий, ШАД/Yandex SDA, 2017)](https://github.com/yandexdataschool/YSDA_deeplearning17)
* [DL Course Materials - часть материалов курса Лемпицкого](https://github.com/ddtm/dl-course)
* [MIT 6.S191: Introduction to Deep Learning – A 1-week extensive survey of deep learning methods and applications](http://introtodeeplearning.com/index.html)
* [Deep Learning Study Group](https://github.com/the-deep-learners)
* [Deep Natural Language Processing (Oxford, 2017)](https://github.com/oxford-cs-deepnlp-2017/lectures)
* [CS 20SI: Tensorflow for Deep Learning Research (Stanford)](http://web.stanford.edu/class/cs20si/syllabus.html)
* [CS 294: Deep Reinforcement Learning (Spring 2017)](https://mega.nz/#F!Ap4n2bLb!e6QZqN_npmWjE-CQldBKZw)
* [TensorFire: Blazing fast in-browser neural networks](https://tenso.rs/demos/fast-neural-style/)
* [Deep Learning Specialization (Andrew Ng)](https://www.coursera.org/specializations/deep-learning)
* [SotA-CV — A repository of state-of-the-art deep learning methods in computer vision](https://github.com/Lextal/SotA-CV)

