# Машинное обучение

Постоянно обновляемая подборка ресурсов по машинному обучению.

#### Оглавление

* [Библиотека ML-специалиста](#Библиотека-ml-специалиста) + выбор редакции:
  * [Дополнительные материалы](https://gist.github.com/demidovakatya/cef3d462bcf56b84f56950ea490a9e8e) к курсу «Введение в машинное обучение»
  * [Рекомендации](https://gist.github.com/demidovakatya/61e15717a9eefae0bd237b7fd959d166) от преподавателей специализации «Машинное обучение и анализ данных»
  * [Литература для поступления в ШАД](https://gist.github.com/demidovakatya/873e4dd6f1c6652ac842)
  * [Подборка научпоп-книг](https://bookmate.com/bookshelves/Nggk0rBi)
* По темам: 
  * [Big Data](/big-data.md)
  * [Dataviz](/dataviz.md)
  * [LaTeX](/latex.md)
  * [NLP](/nlp.md)
  * [Python, IPython, Scikit-learn etc](/python.md)
  * [R](/r.md)
  * [Алгоритмы](/algorithms.md)
  * [Линейная алгебра](/linalg.md)
  * [Нейронные сети, Deep learning](/neural-nets.md)
  * [Статистика и теория вероятностей](/probability-statistics.md)
* [Онлайн-курсы (MOOC)](#Онлайн-курсы-mooc)
* [Чаты/паблики/каналы про ML](#social)

----------------------------------------------------

* [Календарь соревнований по анализу данных](https://mltrainings.ru/?filter=active)
* [Машинное обучение: вводная лекция](http://www.machinelearning.ru/wiki/images/f/fc/Voron-ML-Intro-slides.pdf) – К. В. Воронцов
* [Lecture notes and code for Machine Learning practical course on CMC MSU](https://github.com/esokolov/ml-course-msu)
* [100+ Free Data Science Books](https://www.learndatasci.com/free-data-science-books/) – более 100 бесплатных книг по Data Science
* [Free O'Reilly data science ebooks](https://www.oreilly.com/data/free/archive.html)
* [100 репозиториев по машинному обучению](http://meta-guide.com/software-meta-guide/100-best-github-machine-learning)
* [awesome-machine-learning](https://github.com/josephmisiti/awesome-machine-learning) — A curated list of awesome Machine Learning frameworks, libraries and software
* [Open Source Society University's Data Science course](https://github.com/ossu/data-science) – this is a solid path for those of you who want to complete a Data Science course on your own time, for free, with courses from the best universities in the World
* [Доска по data science в Trello](https://trello.com/b/rbpEfMld/data-science) — проверенные материалы, организованные по темам (expertise tracks, языки программирования, различные инструменты)
* [Machine Learning Resource Guide](https://www.pdf-archive.com/2017/09/02/machine-learning-resource-guide/machine-learning-resource-guide.pdf)
* [17 ресурсов по машинному обучению от Типичного Программиста](https://tproger.ru/articles/free-programming-books/#machine-learning)
* [51 toy data problem in Data Science](https://www.quora.com/Data-Science/What-are-some-good-toy-problems-can-be-done-over-a-weekend-by-a-single-coder-in-data-science-Im-studying-machine-learning-and-statistics-and-looking-for-something-socially-relevant-using-publicly-available-datasets-APIs/answer/Alex-Kamil) 
* [practical-pandas-projects](https://github.com/schlende/practical-pandas-projects) — project ideas for improving one's Python data analysis skills
* [Dive into Machine Learning](https://hangtwenty.github.io/dive-into-machine-learning/) 
  * :octocat: [Dive into Machine Learning repo on github](https://github.com/hangtwenty/dive-into-machine-learning)
* [Data Science Interview Questions](https://www.itshared.org/2015/10/data-science-interview-questions.html) — огромный список вопросов для подготовки к интервью на позицию data scientist'а
* [Много книг по Natural Language Processing](https://www.dropbox.com/sh/b1c2ulwua9zy574/AACswS1E0IB9LdPDxQ6fexm4a?dl=0)
* [Список открытых источников данных, на которых можно найти бесплатные датасеты](/datasets.md)
* [What should I learn in data science in 100 hours?](https://www.quora.com/What-should-I-learn-in-data-science-in-100-hours-I-am-free-for-the-next-10-days-and-would-like-to-learn-whatever-I-can-in-the-next-10-days-and-I-can-put-in-10-hours-a-day-What-can-I-learn-to-get-a-hang-of-it-and-get-started/answer/Roman-Trusov)
* [machine-learning-for-software-engineers](https://github.com/ZuzooVn/machine-learning-for-software-engineers) — A complete daily plan for studying to become a machine learning engineer
* [Tutorials on topics in machine learning](https://homepages.inf.ed.ac.uk/rbf/IAPR/researchers/MLPAGES/mltut.htm)
* [Постоянно обновляющаяся подборка ссылок по датасаенсу](https://docs.google.com/spreadsheets/d/1dXghGL0hH6gs3H9Km7zhOpk9MWufRJ_bSrFw0NLaRuo/edit#gid=0)
* [Teach yourself Machine Learning the hard way!](https://darshanhegde.wordpress.com/2014/08/19/learn-machine-learning-the-hard-way/)
* [An article a week](https://github.com/shagunsodhani/papers-I-read) – list of good articles on ML/AI/DL
* [The most popular programming books ever mentioned on StackOverflow](https://medium.freecodecamp.org/i-analyzed-every-book-ever-mentioned-on-stack-overflow-here-are-the-most-popular-ones-eee0891f1786)
* [Cookiecutter Data Science](https://drivendata.github.io/cookiecutter-data-science/) – A logical, reasonably standardized, but flexible project structure for doing and sharing data science work
* [awesome-datascience-ideas](https://github.com/faktionai/awesome-ai-usecases) – A list of awesome and proven data science use cases and applications
* [machine-learning-surveys](https://github.com/mlreview/machine-learning-surveys) – A curated list of Machine Learning Surveys, Tutorials and Books
* [A hands-on data science crash course in Python by Bart De Vylder and Pieter Buteneers from CoScale](https://github.com/bartdevylder/velocity-tutorial-san-jose)
* [docker-setup](https://github.com/yang-zhang/docker-setup) – A Curated List of Docker Images for Data Science Projects, with Easy Setup
* [Notes on Artificial Intelligence](https://frnsys.com/ai_notes/)  – конспекты по разным ML-related темам, от алгебры до Байеса

----------------------------------------------------

## Библиотека ML-специалиста

* [A Course in Machine Learning](http://ciml.info) – Hal Daumé III
* [A Probabilistic Theory of Pattern Recognition](https://www.szit.bme.hu/%7Egyorfi/pbook.pdf) – Devroye, Gyorfi, Lugosi (pdf)
* [Applied Predictive Modeling](https://www.springer.com/us/book/9781461468486) – M. Kuhn, K. Johnson (2013)
* [Bayesian Reasoning and Machine Learning](http://web4.cs.ucl.ac.uk/staff/D.Barber/textbook/181115.pdf) - D.Barber (2015) (pdf)
* [Core Concepts in Data Analysis: Summarization, Correlation and Visualization](https://www.springer.com/us/book/9780857292865) – Boris Mirkin
* [Data Mining and Analysis. Fundamental Concepts and Algorithms](https://repo.palkeo.com/algo/information-retrieval/Data%20mining%20and%20analysis.pdf) – M.J.Zaki, W.Meira Jr (2014) (pdf)
* [Data Mining: Concepts and Techniques](https://www.sciencedirect.com/book/9780123814791/data-mining-concepts-and-techniques) – Jiawei Han et. al.
* [Data Science For Dummies](https://www.geekbooks.me/book/view/data-science-for-dummies) – Lillian Pierson (2015)
* [Doing Data Science](http://shop.oreilly.com/product/0636920028529.do)
* [Elements of Statistical Learning](https://www-stat.stanford.edu/~tibs/ElemStatLearn/printings/ESLII_print10.pdf) – Hastie, Tibshirani, Friedman (pdf)
* [Foundations of Machine Learning](https://cs.nyu.edu/~mohri/mlbook/) – Mehryar Mohri, Afshin Rostamizadeh, and Ameet Talwalkar (2012)
* [Frequent Pattern Mining](http://www.charuaggarwal.net/freqbook.pdf) – Charu C Aggarwal, Jiawei Han (eds.) (pdf)
* [Gaussian Processes for Machine Learning](http://www.gaussianprocess.org/gpml/chapters/RW.pdf) – Carl E. Rasmugit lssen, Christopher K. I. Williams (pdf)
* [Inductive Logic Programming: Techniques and Applications](http://www.e-booksdirectory.com/details.php?ebook=1105) – Nada Lavrac, Saso Dzeroski
* [Information Theory, Inference and Learning Algorithms](http://www.inference.phy.cam.ac.uk/itila/book.html) – David MacKay
* [Introduction to Information Retrieval](https://nlp.stanford.edu/IR-book/pdf/irbookprint.pdf) – Manning, Rhagavan, Shutze (pdf)
* [Introduction To Machine Learning](http://www.e-booksdirectory.com/details.php?ebook=1117) – Nils J Nilsson (1997)
* [Introduction to Machine Learning](https://alex.smola.org/drafts/thebook.pdf) – Smola and Vishwanathan (pdf)
* [Machine learning cheat sheet](https://github.com/soulmachine/machine-learning-cheat-sheet/raw/master/machine-learning-cheat-sheet.pdf) – soulmachine (2017) (pdf)
* [Machine Learning in Action](https://www.manning.com/books/machine-learning-in-action) – Peter Harrington
* [Machine Learning, Neural and Statistical Classification](http://www.e-booksdirectory.com/details.php?ebook=1118) – D. Michie, D. J. Spiegelhalter
* [Machine Learning. The Art of Science of Algorithms that Make Sense of Data](https://www.amazon.com/Machine-Learning-Science-Algorithms-Sense/dp/1107422221/) – P. Flach (2012)
* [Machine Learning](http://profsite.um.ac.ir/~monsefi/machine-learning/pdf/Machine-Learning-Tom-Mitchell.pdf) – Tom Mitchell
* [Machine Learning](https://www.mlyearning.org/) – Andrew Ng
* [Mining Massive Datasets](http://www.mmds.org/) – Jure Leskovec, Anand Rajaraman, Jeff Ullman
* [Pattern Recognition and Machine Learning](https://www.amazon.com/Pattern-Recognition-Learning-Information-Statistics/dp/0387310738/) – C.M.Bishop (2006)
* [Probabilistic Programming and Bayesian Methods for Hackers](https://camdavidsonpilon.github.io/Probabilistic-Programming-and-Bayesian-Methods-for-Hackers/) (free)
* [A Programmer's Guide to Data Mining](http://guidetodatamining.com/assets/guideChapters/Guide2DataMining.pdf) – Ron Zacharski (pdf)
* [R in Action](https://www.manning.com/books/r-in-action)
* [Reinforcement Learning: An Introduction](http://www.e-booksdirectory.com/details.php?ebook=1825) - Richard S. Sutton, Andrew G. Barto
* [The LION Way Machine Learning plus Intelligent Optimization](https://intelligent-optimization.org/LIONbook/lionbook_3v0.pdf) (pdf)
* [Understanding Machine Learning: From Theory to Algorithms](https://www.cs.huji.ac.il/%7Eshais/UnderstandingMachineLearning/copy.html)
* [Анализ больших наборов данных](https://dmkpress.com/catalog/computer/data/978-5-97060-190-7/) – перевод Mining Massive Datasets
* [Математические методы обучения по прецедентам (теория обучения машин)](http://www.machinelearning.ru/wiki/images/6/6d/Voron-ML-1.pdf) – К. В. Воронцов (pdf)
* [Машинное обучение](https://www.pdf-archive.com/2017/09/02/machine-learning-ru-flach-p/machine-learning-ru-flach-p.pdf) — Петер Флах (pdf)
* [Методы ансамблирования обучающихся алгоритмов](http://www.machinelearning.ru/wiki/images/5/56/Guschin2015Stacking.pdf) — диссертация А. Гущина (pdf)

----------------------------------------------------

## Онлайн-курсы (MOOC)

* [Перечень лучших курсов по практически любым областям математики](https://www.quora.com/What-are-the-best-online-college-level-mathematics-courses)
* [Тонна разнообразных курсов по программированию, алгоритмам, в том числе 29 курсов по ML](https://github.com/prakhar1989/awesome-courses)
* Coursera:
  * [CS229: Machine Learning (Andrew Ng, Stanford University)](https://www.coursera.org/learn/machine-learning) – самый популярный курс по машинному обучению (осторожно, вместо стандартных Питона или R – Matlab/Octave)
  * Специализация [Машинное обучение и Анализ данных (Яндекс + МФТИ/MIPT)](https://www.coursera.org/specializations/machine-learning-data-analysis) 
    * :octocat: [мой репозиторий по этой специализации](https://github.com/demidovakatya/mashinnoye-obucheniye)
  * [Machine Learning Foundations: A Case Study Approach (University of Washington)](https://www.coursera.org/learn/ml-foundations/)
  * [Data Mining Specialization](https://www.coursera.org/specializations/data-mining)
  * [Data Science at Scale Specialization (University of Washington)](https://www.coursera.org/specializations/data-science)
  * [Calculus: Single Variable Part 1 (University of Pennsylvania)](https://www.coursera.org/learn/single-variable-calculus)
  * [Современная комбинаторика (А.М. Райгородский, МФТИ/MIPT)](https://www.coursera.org/learn/modern-combinatorics)
  * [Теория вероятностей для начинающих (А.М. Райгородский, МФТИ/MIPT)](https://www.coursera.org/learn/probability-theory-basics/)
  * [Линейная алгебра (ВШЭ/HSE)](https://www.coursera.org/learn/algebra-lineynaya) — курс линейной алгебры для нематематических факультетов, подходит «для быстрого старта»
  * [Эконометрика (ВШЭ/HSE)](https://www.coursera.org/learn/ekonometrika/) (Econometrics)
  * [Business Analytics Specialization (University of Pennsylvania)](https://www.coursera.org/specializations/business-analytics) – специализация о практическом применении статистики и анализа данных. Для людей, разочаровавшихся в DS и не понимающих, на кой это всё
  * [Social Network Analysis (University of Michigan)](https://www.coursera.org/learn/python-social-network-analysis)
  * [Social and Economic Networks: Models and Analysis (Stanford University)](https://www.coursera.org/learn/social-economic-networks)
  * [Recommender Systems Specialization (University of Minnesota)](https://www.coursera.org/specializations/recommender-systems)
  * [Build Intelligent Applications Specialization (University of Washington)](https://www.coursera.org/specializations/machine-learning)
  * [Программирование на Python (МФТИ/MIPT)](https://www.coursera.org/learn/diving-in-python)
* Udacity:
  * [Machine Learning Engineer Nanodegree (co-created by Kaggle)](https://www.udacity.com/course/machine-learning-engineer-nanodegree--nd009)
  * [Data Analyst Nanodegree (co-created by Facebook & MongoDB)](https://www.udacity.com/course/data-analyst-nanodegree--nd002)
  * [Artificial Intelligence Nanodegree (co-created by IBM Watson & Amazon Alexa)](https://www.udacity.com/course/artificial-intelligence-nanodegree--nd889)
  * [Predictive Analytics for Business Nanodegree (co-created by Tableau & Alteryx)](https://www.udacity.com/degrees/predictive-analytics-for-business--nd008)
* Edx:
  * [Data Science and Engineering with Spark XSeries (Berkeley)](https://www.edx.org/xseries/data-science-engineering-apacher-sparktm)
  * [6.002x: Introduction to Computational Thinking and Data Science (MIT)](https://www.edx.org/course/introduction-to-computational-thinking-and-data-science-2)
  * [6.041x: Introduction to Probability - The Science of Uncertainty (MIT)](https://www.edx.org/course/introduction-probability-science-mitx-6-041x-2)
  * [The Analytics Edge (MIT)](https://www.edx.org/course/the-analytics-edge-0)
* [Learning from Data (Caltech)](https://work.caltech.edu/telecourse.html) – введение в машинное обучение (основная теория, алгоритмы и области практического применения)
* [Видеозаписи лекций Школы Анализа Данных (ШАД)](https://yandexdataschool.ru/edu-process/courses)
  * [Видеолекции курса «Машинное обучение» (К. В. Воронцов, ШАД)](https://yandexdataschool.ru/edu-process/courses/machine-learning)
* [Data Mining in Action course materials (МФТИ/MIPT)](https://github.com/vkantor/MIPT_Data_Mining_In_Action_2016) 
* [Открытый курс OpenDataScience по машинному обучению](https://github.com/Yorko/mlcourse.ai)
* [Intro to Python for Data Science](https://www.datacamp.com/courses/intro-to-python-for-data-science) – основы Python и немного про NumPy
* [Основы статистики](https://stepic.org/course/76) — качественное введение в статистику, целиком на русском языке
* [Data Science and Machine Learning Essentials (Microsoft)](https://mva.microsoft.com/en-US/training-courses/data-science-and-machine-learning-essentials-14100)
* [CS231n: Convolutional Neural Networks for Visual Recognition (Stanford University)](http://cs231n.stanford.edu/) — отличный десятинедельный курс по нейросетям и компьютерному зрению
  * :octocat: [repo on github](https://github.com/cs231n/cs231n.github.io)
* [Mining Massive Datasets (Stanford University)](https://lagunita.stanford.edu/courses/course-v1:ComputerScience+MMDS+Fall2016/about) - курс, основанный на книге Mining of Massive Datasets авторов Jure Leskovec, Anand Rajaraman, and Jeff Ullman (они же являются инструкторами этого курса)
* [CS109: Data Science (Harvard University)](http://web.stanford.edu/class/cs109/)
* [Foundations of Machine Learning](https://bloomberg.github.io/foml/) — a part of Bloomberg's _Machine Learning EDU_ initiative

----------------------------------------------------

## Social

Обсуждение машинного обучения в мессенджерах (группы, каналы, чаты, сообщества).

* [Open Data Science](http://ods.ai)
* [Посвященная московским ML-тренировкам группа в facebook](https://www.facebook.com/groups/1413405125598651/)
* [и группа вконтакте про тренировки по машинному обучению](https://vk.com/mltrainings)
* [Томская группа по машинному обучению](https://vk.com/tomskml)
* [Slack Томской группы по ML](https://tomskml.slack.com/)
  * [форма регистрации](https://docs.google.com/forms/d/e/1FAIpQLSdYpgm7T80JpyBPt6NMgRP_4jne7v_qaGFjy8wDrS4fNajMDA/viewform?c=0&w=1)
* Паблики/группы вконтакте:
  * [Data Science](https://vk.com/datascience)
  * [Deep Learning](https://vk.com/deeplearning)
  * [Data Mining Labs](https://vk.com/datamininglabs)
  * [DeepLearning (Глубокие нейронные сети)](https://vk.com/deeplearning_ru)
  * [Мемы про машинное обучение для юных леди](https://vk.com/weirdreparametrizationtrick)
* В телеграме:
  * [Канал сообщества DeepLearning](https://t.me/deeplearning_ru)
  * [Первый новостной канал про data science](https://t.me/opendatascience)
  * [Чат по большим данным, обработке и машинному обучению](https://t.me/bigdata_ru) — Big Data & Machine Learning
  * [Чат по теме Data Science](https://t.me/datasciencechat) — Data Science Chat
  * [Канал py_digest](https://t.me/py_digest)
  * [Чат ru_python](https://t.me/ru_python)
  * [Spark in me: Internet, statistics, data science, philosophy](https://t.me/snakers4)
  * [Чат канала Spark in me](https://t.me/joinchat/AAAAAEH9JHYBvaPLvaWPGg)
  * [Канал с горячими постами с Reddit на DS тематику](https://t.me/datascientology)
* Сабреддиты по машинному обучению и смежным темам (рекомендую посмотреть как минимум топ за всё время + sidebar):
    * [/r/analyzit](https://www.reddit.com/r/analyzit)
    * [/r/bigdata](https://www.reddit.com/r/bigdata)
    * [/r/bigdatajobs](https://www.reddit.com/r/bigdatajobs)
    * [/r/computervision](https://www.reddit.com/r/computervision)
    * [/r/datacleaning](https://www.reddit.com/r/datacleaning)
    * [/r/datagangsta](https://www.reddit.com/r/datagangsta)
    * [/r/dataisbeautiful](https://www.reddit.com/r/dataisbeautiful)
    * [/r/dataisugly](https://www.reddit.com/r/dataisugly)
    * [/r/datascience](https://www.reddit.com/r/datascience)
    * [/r/datasets](https://www.reddit.com/r/datasets)
    * [/r/dataviz](https://www.reddit.com/r/dataviz)
    * [/r/JupyterNotebooks](https://www.reddit.com/r/JupyterNotebooks)
    * [/r/LanguageTechnology](https://www.reddit.com/r/LanguageTechnology)
    * [/r/learnmachinelearning](https://www.reddit.com/r/learnmachinelearning)
    * [/r/learnpython](https://www.reddit.com/r/learnpython)
    * [/r/MachineLearning](https://www.reddit.com/r/MachineLearning)
    * [/r/opendata](https://www.reddit.com/r/opendata)
    * [/r/rstats](https://www.reddit.com/r/rstats)
    * [/r/probabilitytheory](https://www.reddit.com/r/probabilitytheory)
    * [/r/pystats](https://www.reddit.com/r/pystats)
    * [/r/SampleSize](https://www.reddit.com/r/SampleSize)
    * [/r/semanticweb](https://www.reddit.com/r/semanticweb)
    * [/r/statistics](https://www.reddit.com/r/statistics)
    * [/r/textdatamining](https://www.reddit.com/r/textdatamining)
* [People tweeting about ML and AI](https://blog.talla.com/2016/02/people-tweeting-about-machine-learning-and-ai/)
* [Блоги по датасаенс-тематике](https://github.com/rushter/data-science-blogs) + список:
  * [distill.pub](https://distill.pub/)
  * [inference.vc](https://www.inference.vc/)
  * [karpathy.github.io](https://karpathy.github.io/)
  * [deliprao.com](http://deliprao.com/)
  * [fastml.com](https://fastml.com/)
  * [timvieira.github.io](https://timvieira.github.io/)
  * [blogs.princeton.edu](https://blogs.princeton.edu/)
  * [offconvex.org](https://www.offconvex.org/)
  * [ruder.io](http://ruder.io/)
  * [argmin.net](https://www.argmin.net/)
  * [nlpers.blogspot.ru](https://nlpers.blogspot.com/)
  * [blog.shakirm.com](http://blog.shakirm.com/)
  * [blog.paralleldots.com](https://blog.paralleldots.com)
  * [alexanderdyakonov.wordpress.com](https://dyakonov.org/)
