# Natural Language Processing with PyTorch
_Build Intelligent Language Applications Using Deep Learning_
<br>By Delip Rao and Brian McMahan


Welcome. This is a companion repository for the book [Natural Language Processing with PyTorch: Build Intelligent Language Applications Using Deep Learning](https://www.amazon.com/Natural-Language-Processing-PyTorch-Applications/dp/1491978236/).


Table of Contents
=================

<!--ts-->
* Get Started!
* [Chapter 1: Introduction](https://github.com/joosthub/PyTorchNLPBook/tree/master/chapters/chapter_1)
  * PyTorch Basics
* Chapter 2: A Quick Tour of NLP
* [Chapter 3: Foundational Components of Neural Networks](https://github.com/joosthub/PyTorchNLPBook/tree/master/chapters/chapter_3)
  * In-text examples
  * Diving deep into supervised training
  * Classifying sentiment of restaurant reviews using a Perceptron
* [Chapter 4: Feed-forward Networks for NLP](https://github.com/joosthub/PyTorchNLPBook/tree/master/chapters/chapter_4)
  * Limitations of the Perceptron
  * Introducing Multi-layer Perceptrons (MLPs)
  * Introducing Convolutional Neural Networks (CNNs)
  * Surname Classification with an MLP
  * Surname Classification with a CNN
* [Chapter 5: Embedding Words and Types](https://github.com/joosthub/PyTorchNLPBook/tree/master/chapters/chapter_5)
  * Using Pretrained Embeddings
  * Learning Continous Bag-of-words Embeddings (CBOW)
  * Transfer Learning using Pre-trained Embeddings
* [Chapter 6: Sequence Modeling for NLP](https://github.com/joosthub/PyTorchNLPBook/tree/master/chapters/chapter_6)
  * A sequence representation for Surnames
* [Chapter 7: Intermediate Sequence Modeling for NLP](https://github.com/joosthub/PyTorchNLPBook/tree/master/chapters/chapter_7)
  * Generating novel surnames from sequence representations
  * Uncondition generation
  * Conditioned generation
* [Chapter 8: Advanced Sequence Modeling for NLP](https://github.com/joosthub/PyTorchNLPBook/tree/master/chapters/chapter_8)
  * Understanding PackedSequences 
  * Sequence to Sequence Learning
  * Attention
  * Neural Machine Translation
* Chapter 9: Classics, Frontiers, Next Steps
<!--te-->
