# Quick start

Deep Java Library (DJL) is designed to be easy to get started with and simple to use.
The easiest way to learn DJL is to read the [beginner tutorial](https://docs.djl.ai/master/docs/demos/jupyter/tutorial/README.md) or
our [examples](../examples/README.md).

You can also view our 1.5 hour long (in 8 x ~10 minute segments) DJL 101 tutorial video series:

[<img src="https://resources.djl.ai/images/djl-101.jpg" width="560" height="315">](https://www.youtube.com/embed/?list=PLC1JzXeHJitDmZBHupMGZE2zHzU8fEvfD&listType=playlist)

## Prerequisites

* You need a Java Development Kit (JDK) installed on your system. We recommend using JDK 11, but any later version also works. For more information, see [Setup](development/setup.md).
* You need git installed on your system to clone the DJL repository.

## Try DJL

We developed several interactive toolkits for you to experience DJL.
You can start from here to run inference online and download starter template with DJL.

## Beginner tutorial

To get started, we recommend that you follow our short [beginner tutorial](https://docs.djl.ai/master/docs/demos/jupyter/tutorial/index.html). It takes you through some of the basics of deep learning to create a model, train your model, and run inference using your trained model.

## Run examples

DJL also provides examples for both training and performing inference with deep learning models. You can find the examples and their source code in the [examples](https://github.com/deepjavalibrary/djl/tree/master/examples) directory.
 
All of our examples are executed by a simple command. For detailed command line instructions, see each example’s Readme.md file.

- [Train your first model](../examples/docs/train_mnist_mlp.md)
- [Single-shot Object Detection inference example](../examples/docs/object_detection.md)
- [More examples](https://github.com/deepjavalibrary/djl/tree/master/examples)
- [Jupyter examples](https://docs.djl.ai/master/docs/demos/jupyter/index.html)

## Other resources

- [JavaDoc API Reference](https://djl.ai/website/javadoc.html)
- [Contributor Documentation](development/README.md)
- [FAQ](faq.md)
