# Forums

There are many forums where the DJL community interacts and ideas for DJL are discussed. Here are a list of the best ways to find what interests you in DJL:

## Questions

The best place to ask questions is on the [Discussions Q&A](https://github.com/deepjavalibrary/djl/discussions/categories/q-a). You can also join the [DJL Slack](http://tiny.cc/djl_slack) under the `#help` channel.

## Ideas

If you have an idea or a feature request for DJL, there are a few places you can share it. If it is an enhancement for DJL directly, you can open an [enhancement issue](https://github.com/deepjavalibrary/djl/issues/new?assignees=&labels=enhancement&template=feature_request.md&title=).

If you think that the issue requires some discussion to determine quite what to do, you may want to start a discussion before branching it out into an issue. The best places for those discussions are the [ideas forum](https://github.com/deepjavalibrary/djl/discussions/categories/ideas) if the issue might attract broader interest or the [development Forum](https://github.com/deepjavalibrary/djl/discussions/categories/development) to share it only with the more focused DJL API developers.

Once you decide on a forum, there are two main formats your discussion might take. If you want to just raise a question, use the question as the name of your post and people can discuss the question. If you have a proposal and you are looking for input before you start making changes, you should frame it as a Request for Comments (RFC). The RFC doesn't have a template at this time, so just add `[RFC]` before your proposal title.

Don't forget that DJL is a community project. If you have an idea, you are always welcome to implement it yourself! If you have any questions along the way or don't know how to get started, just ask for help in your issue and some friendly DJL developers will be happy to guide you on your way.

## Bug Report

Bugs happen. If you see something wrong with DJL or just aren't sure, you should open a [bug issue](https://github.com/deepjavalibrary/djl/issues/new?assignees=&labels=bug&template=bug_report.md&title=). Make sure to give us enough information to help figure out what is wrong and how to fix it.

## Share projects, blog posts, talks, etc.

If you have a cool project with DJL, wrote a blog post, or are giving a talk, we would love to hear about it! You should write a short post it on our [show-and-tell](https://github.com/deepjavalibrary/djl/discussions/categories/show-and-tell). If you mention us on [twitter](https://twitter.com/deepjavalibrary), we can also retweet it. Once we learn about it, we will also add it to our monthly news update as well. You can also use You can also join the [DJL Slack](http://tiny.cc/djl_slack) under the `#projects` channel.

## Research

If you like following the latest research and are looking for a place to discuss, check out our [deep learning discussions](https://github.com/deepjavalibrary/djl/discussions/categories/deep-learning). There, you can find other people interested in the theory of deep learning. You can also join the [DJL Slack](http://tiny.cc/djl_slack) under the `#deep-learning` channel.

## Development

If you want to talk about the development of DJL itself, look at our [development discussions](https://github.com/deepjavalibrary/djl/discussions/categories/development). You can also join the [DJL Slack](http://tiny.cc/djl_slack) under the `#development` channel.

## Pull Request

If you have an idea that you want to implement for changes to DJL, a bug fix, new datasets, new models, or anything else, open a new [pull request](https://github.com/deepjavalibrary/djl/compare). You can view this guide on [git and how to fork the project and make a pull request](https://docs.github.com/en/get-started/quickstart/contributing-to-projects). We also have [documentation for contributors](development/README.md) that can help setup development, explain DJL coding conventions, working with DJL CI, and troubleshooting common problems.

## Follow DJL

To follow the latest updates and content in DJL, you can follow our [twitter](https://twitter.com/deepjavalibrary). It usually posts up to a few times a week.

You can also find DJL updates in our monthly newsletter including all features, fixes, and community events. You can get the newsletter by joining our mailing list from the [DJL site](https://djl.ai/). We respect your email and will not overuse or share your emails with anyone. You will only receive one to two emails per month: the monthly newsletter and release announcements for new DJL releases.

## 关注我们

[<img src='https://www.iconfinder.com/icons/5060515/download/svg/512' width='20px' /> 知乎专栏](https://zhuanlan.zhihu.com/c_1255493231133417472) 获取DJL最新的内容！

## General

If you have read through these forums and nothing seems quite right, you can share it on [general discussions](https://github.com/deepjavalibrary/djl/discussions/categories/general). We try to keep our discussions organized so people can find what they are looking for. If you aren't sure about your choice of channel, don't worry about it and just use something that seems reasonable. You can also join the [DJL Slack](http://tiny.cc/djl_slack) under the `#random` channel.
