# DJL dependency management

This document outlines how DJL manages its dependencies and how developers can find DJL packages they need.

## External dependencies

We try our best to minimize the external dependencies. The core DJL library only has 4 external dependencies:

- [sl4fj-api](https://mvnrepository.com/artifact/org.slf4j/slf4j-api)
- [Gson](https://mvnrepository.com/artifact/com.google.code.gson/gson)
- [JNA](https://mvnrepository.com/artifact/net.java.dev.jna/jna)
- [apache-commons-compress](https://mvnrepository.com/artifact/org.apache.commons/commons-compress)

## Which DJL package do I need?

Although DJL itself has many packages, but in a real production environment, the minimal dependencies can be:

- ai.djl:api
- one of the engine package (e.g. ai.djl.pytorch:pytorch-engine)
- native library of selected engine for no internet use case 
  (e.g. ai.djl.pytorch:pytorch-native-cpu:1.11.0:linux-x86_64 + ai.djl.pytorch:pytorch-jni).
  See [How to distribute DJL application](https://github.com/deepjavalibrary/djl-demo/tree/master/development/fatjar#readme) for more detail.

We don't recommend include more than one engine into your project unless you need both of them. DJL will load
all engines into memory as long as they are in classpath, and those engines usually consume significant of memory.

## Using Bill of Materials module (BOM)

To automatically manage DJL packages' versions, we recommend you use the
[Bill of Materials](https://search.maven.org/search?q=g:ai.djl%20AND%20a:bom).
It can simplify your project's dependency management and make sure Maven picks the compatible versions of DJL modules.

See [How to use DJL's BOM](../../bom/README.md#how-to-use-djls-bom) for detail.

## List of DJL packages published on Maven Central

| Group ID                                                                         | Artifact ID                                                                                                       | Description                                                                                      |
|----------------------------------------------------------------------------------|-------------------------------------------------------------------------------------------------------------------|--------------------------------------------------------------------------------------------------|
| [ai.djl](https://search.maven.org/search?q=g:ai.djl)                             | [api](../../api/README.md#installation)                                                                           | DJL core API, contains top level, engine-agnostic classes for both inference and training        |
|                                                                                  | [bom](../../bom/README.md)                                                                                        | Bill of Materials (BOM), used to manage DJL package dependencies                                 |
|                                                                                  | [basicdataset](../../basicdataset/README.md#installation)                                                         | Contains a collection of built-in datasets                                                       |
|                                                                                  | [model-zoo](../../model-zoo/README.md#installation)                                                               | Contains a collection of built-in engine-agnostic models                                         |
|                                                                                  | examples (deprecated)                                                                                             | Contains DJL examples                                                                            |
|                                                                                  | repository (deprecated, use api instead)                                                                          | Contain classes for DJL Repository API. The package is moved into api in newer releases          |
|                                                                                  |                                                                                                                   |                                                                                                  |
| [ai.djl.mxnet](https://search.maven.org/search?q=g:ai.djl.mxnet)                 | [mxnet-engine](../../engines/mxnet/mxnet-engine/README.md#installation)                                           | Apache MXNet engine adapter                                                                      |
|                                                                                  | [mxnet-model-zoo](../../engines/mxnet/mxnet-model-zoo/README.md#installation)                                     | Contains state of the art Apache MXNet symbolic models                                           |
|                                                                                  | [mxnet-native-mkl(osx-x86_64)](../../engines/mxnet/mxnet-engine/README.md#macos)                                  | Contains Apache MXNet native library for macOS                                                   |
|                                                                                  | [mxnet-native-mkl(win-x86_64)](../../engines/mxnet/mxnet-engine/README.md#windows-cpu)                            | Contains Apache MXNet native library for Windows                                                 |
|                                                                                  | [mxnet-native-mkl(linux-x86_64)](../../engines/mxnet/mxnet-engine/README.md#linux-cpu)                            | Contains Apache MXNet native library for Linux                                                   |
|                                                                                  | [mxnet-native-cu112(linux-x86_64)](../../engines/mxnet/mxnet-engine/README.md#linux-gpu)                          | Contains Apache MXNet native library for Linux with CUDA 11.2                                    |
|                                                                                  | [mxnet-native-cu102(linux-x86_64)](../../engines/mxnet/mxnet-engine/README.md#linux-gpu)                          | Contains Apache MXNet native library for Linux with CUDA 10.2                                    |
|                                                                                  | mxnet-native-auto (deprecated)                                                                                    | No longer needed since DJL 0.15.0                                                                |
|                                                                                  | mxnet-native-cu110(linux-x86_64) (deprecated)                                                                     | Contains Apache MXNet native library <= 1.8.1 for Linux with CUDA 11.0                           |
|                                                                                  | mxnet-native-cu101(linux-x86_64) (deprecated)                                                                     | Contains Apache MXNet native library <= 1.7.0 for Linux with CUDA 10.1                           |
|                                                                                  | mxnet-native-cu92(linux-x86_64) (deprecated)                                                                      | Contains Apache MXNet native library <= 1.6.0 for Linux with CUDA 9.2                            |
|                                                                                  |                                                                                                                   |                                                                                                  |
| [ai.djl.pytorch](https://search.maven.org/search?q=g:ai.djl.pytorch)             | [pytorch-engine](../../engines/pytorch/pytorch-engine/README.md#installation)                                     | PyTorch engine adapter                                                                           |
|                                                                                  | [pytorch-model-zoo](../../engines/pytorch/pytorch-model-zoo/README.md#installation)                               | Contains state of the art PyTorch torch script models                                            |
|                                                                                  | [pytorch-native-cpu(osx-x86_64)](../../engines/pytorch/pytorch-engine/README.md#macos)                            | Contains PyTorch native library for macOS                                                        |
|                                                                                  | [pytorch-native-cpu(osx-aarch64)](../../engines/pytorch/pytorch-engine/README.md#macos-m1)                        | Contains PyTorch native library for macOS M1                                                     |
|                                                                                  | [pytorch-native-cpu(win-x86_64)](../../engines/pytorch/pytorch-engine/README.md#windows-cpu)                      | Contains PyTorch native library for Windows                                                      |
|                                                                                  | [pytorch-native-cpu(linux-x86_64)](../../engines/pytorch/pytorch-engine/README.md#linux-cpu)                      | Contains PyTorch native library for Linux                                                        |
|                                                                                  | [pytorch-native-cu118(linux-x86_64)](../../engines/pytorch/pytorch-engine/README.md#linux-gpu)                    | Contains PyTorch native library for Linux with CUDA 11.7                                         |
|                                                                                  | [pytorch-native-cu118(win-x86_64)](../../engines/pytorch/pytorch-engine/README.md#windows-gpu)                    | Contains PyTorch native library for Windows with CUDA 11.7                                       |
|                                                                                  | [pytorch-native-cu118-precxx11(linux-x86_64)](../../engines/pytorch/pytorch-engine/README.md#for-pre-cxx11-build) | Contains PyTorch native library for Linux with CUDA 11.7                                         |
|                                                                                  | [pytorch-native-cpu-precxx11(linux-x86_64)](../../engines/pytorch/pytorch-engine/README.md#for-pre-cxx11-build)   | Contains PyTorch native library for centOS 7 and Ubuntu 14.04                                    |
|                                                                                  | [pytorch-native-cpu-precxx11(linux-aarch64)](../../engines/pytorch/pytorch-engine/README.md#for-aarch64-build)    | Contains PyTorch native library for Linux ARM                                                    |
|                                                                                  | [pytorch-jni](../../engines/pytorch/pytorch-engine/README.md)                                                     | Contains PyTorch JNI native library                                                              |
|                                                                                  | pytorch-native-auto (deprecated)                                                                                  | No longer needed since DJL 0.15.0                                                                |
|                                                                                  | pytorch-native-cu117(linux-x86_64) (deprecated)                                                                   | Contains PyTorch native library for Linux with CUDA 11.7                                         |
|                                                                                  | pytorch-native-cu117(win-x86_64) (deprecated)                                                                     | Contains PyTorch native library for Windows with CUDA 11.7                                       |
|                                                                                  | pytorch-native-cu117-precxx11(linux-x86_64) (deprecated)                                                          | Contains PyTorch native library for Linux with CUDA 11.7                                         |
|                                                                                  | pytorch-native-cu116(linux-x86_64) (deprecated)                                                                   | Contains PyTorch native library for Linux with CUDA 11.6                                         |
|                                                                                  | pytorch-native-cu116(win-x86_64) (deprecated)                                                                     | Contains PyTorch native library for Windows with CUDA 11.6                                       |
|                                                                                  | pytorch-native-cu116-precxx11(linux-x86_64) (deprecated)                                                          | Contains PyTorch native library for Linux with CUDA 11.6                                         |
|                                                                                  | pytorch-native-cu113(linux-x86_64) (deprecated)                                                                   | Contains PyTorch native library for Linux with CUDA 11.3                                         |
|                                                                                  | pytorch-native-cu113(win-x86_64) (deprecated)                                                                     | Contains PyTorch native library for Windows with CUDA 11.3                                       |
|                                                                                  | pytorch-native-cu111(linux-x86_64) (deprecated)                                                                   | Contains PyTorch native library for Linux with CUDA 11.1                                         |
|                                                                                  | pytorch-native-cu111(win-x86_64) (deprecated)                                                                     | Contains PyTorch native library for Windows with CUDA 11.1                                       |
|                                                                                  | pytorch-native-cu102(linux-x86_64) (deprecated)                                                                   | Contains PyTorch native library for Linux with CUDA 10.2                                         |
|                                                                                  | pytorch-native-cu102(win-x86_64) (deprecated)                                                                     | Contains PyTorch native library for Windows with CUDA 10.2                                       |
|                                                                                  | pytorch-native-cu101(linux-x86_64) (deprecated)                                                                   | Contains PyTorch native library <= 1.7.1 for Linux with CUDA 10.1                                |
|                                                                                  | pytorch-native-cu101(win-x86_64) (deprecated)                                                                     | Contains PyTorch native library <= 1.7.1 for Windows with CUDA 10.1                              |
|                                                                                  | pytorch-native-cu92(linux-x86_64) (deprecated)                                                                    | Contains PyTorch native library <= 1.6.0 for Linux with CUDA 9.2                                 |
|                                                                                  | pytorch-native-cu92(win-x86_64) (deprecated)                                                                      | Contains PyTorch native library <= 1.6.0 for Windows with CUDA 9.2                               |
|                                                                                  | pytorch-engine-precxx11 (deprecated)                                                                              | PyTorch engine adapter <= 0.9.0 specific for precxx11 environment like CentOs 7 and Ubuntu 14.04 |
|                                                                                  |                                                                                                                   |                                                                                                  |
| [ai.djl.tensorflow](https://search.maven.org/search?q=g:ai.djl.tensorflow)       | [tensorflow-engine](../../engines/tensorflow/tensorflow-engine/README.md#installation)                            | TensorFlow engine adapter                                                                        |
|                                                                                  | [tensorflow-api](../../engines/tensorflow/tensorflow-api/README.md#installation)                                  | A redistribution of tensorFlow core java API 2.x                                                 |
|                                                                                  | [tensorflow-model-zoo](../../engines/tensorflow/tensorflow-model-zoo/README.md#installation)                      | Contains state of the art TensorFlow saved bundle models                                         |
|                                                                                  | [tensorflow-native-cpu(osx-x86_64)](../../engines/tensorflow/tensorflow-engine/README.md#macos)                   | Contains TensorFlow native library for macOS                                                     |
|                                                                                  | [tensorflow-native-cpu(linux-x86_64)](../../engines/tensorflow/tensorflow-engine/README.md#linux-cpu)             | Contains TensorFlow native library for Linux                                                     |
|                                                                                  | [tensorflow-native-cpu(win-x86_64)](../../engines/tensorflow/tensorflow-engine/README.md#windows-cpu)             | Contains TensorFlow native library for Windows                                                   |
|                                                                                  | [tensorflow-native-cu113(linux-x86_84)](../../engines/tensorflow/tensorflow-engine/README.md#linux-gpu)           | Contains TensorFlow native library for Linux with CUDA 11.3                                      |
|                                                                                  | tensorflow-native-cu110 (linux-x86_84) (deprecated)                                                               | Contains TensorFlow native library for Linux with CUDA 11.0                                      |
|                                                                                  | tensorflow-native-auto (deprecated)                                                                               | No longer needed since DJL 0.15.0                                                                |
|                                                                                  | tensorflow-native-cu101(linux-x86_84) (deprecated)                                                                | Contains TensorFlow native library <= 2.3.0 for Linux with CUDA 10.1                             |
|                                                                                  |                                                                                                                   |                                                                                                  |
| [ai.djl.paddlepaddle](https://search.maven.org/search?q=g:ai.djl.paddlepaddle)   | paddlepaddle-engine (deprecated)                                                                                  | PaddlePaddle engine adapter                                                                      |
|                                                                                  | paddlepaddle-model-zoo (deprecated)                                                                               | Contains state of the art PaddlePaddle models                                                    |
|                                                                                  | paddlepaddle-native-cpu(osx-x86_64) (deprecated)                                                                  | Contains PaddlePaddle native library for macOS                                                   |
| paddlepaddle-native-cpu(linux-x86_64) (deprecated)                               | Contains PaddlePaddle native library for Linux                                                                    |
|                                                                                  | paddlepaddle-native-cpu(win-x86_64) (deprecated)                                                                  | Contains PaddlePaddle native library for Windows                                                 |
|                                                                                  | paddlepaddle-native-cu102(linux-x86_64) (deprecated)                                                              | Contains PaddlePaddle native library for Linux with CUDA 10.2                                    |
|                                                                                  | paddlepaddle-native-cu112(linux-x86_64) (deprecated)                                                              | Contains PaddlePaddle native library for Linux with CUDA 11.2                                    |
|                                                                                  | paddlepaddle-native-cu110(win-x86_64) (deprecated)                                                                | Contains PaddlePaddle native library for Windows with CUDA 11.0                                  |
|                                                                                  | paddlepaddle-native-cu101 (deprecated)                                                                            | Contains PaddlePaddle native library <= 2.0.2 for Linux with CUDA 10.1                           |
|                                                                                  | paddlepaddle-native-auto (deprecated)                                                                             | No longer needed since DJL 0.15.0                                                                |
|                                                                                  |                                                                                                                   |                                                                                                  |
| [ai.djl.onnxruntime](https://search.maven.org/search?q=g:ai.djl.onnxruntime)     | [onnxruntime-engine](../../engines/onnxruntime/onnxruntime-engine/README.md#installation)                         | ONNX Runtime engine adapter                                                                      |
|                                                                                  | onnxruntime-api(deprecated)                                                                                       | Please use com.microsoft.onnxruntime:onnxruntime instead                                         |
|                                                                                  | onnxruntime-native-auto(deprecated)                                                                               | Please use com.microsoft.onnxruntime:onnxruntime instead                                         |
|                                                                                  | onnxruntime-native-cpu(deprecated)                                                                                | Please use com.microsoft.onnxruntime:onnxruntime instead                                         |
|                                                                                  |                                                                                                                   |                                                                                                  |
| [ai.djl.tflite](https://search.maven.org/search?q=g:ai.djl.tflite)               | tflite-engine (deprecated)                                                                                        | TensorFlow Lite engine adapter                                                                   |
|                                                                                  | tflite-native-cpu(osx-x86_64) (deprecated)                                                                        | Contains TensorFlow Lite native library for macOS                                                |
|                                                                                  | tflite-native-cpu(linux-x86_64) (deprecated)                                                                      | Contains TensorFlow Lite native library for Linux                                                |
|                                                                                  | tflite-native-auto (deprecated)                                                                                   | No longer needed since DJL 0.15.0                                                                |
|                                                                                  |                                                                                                                   |                                                                                                  |
| [ai.djl.tensorrt](https://search.maven.org/search?q=g:ai.djl.tensorrt)           | [tensorrt](../../engines/tensorrt/README.md#installation)                                                         | TensorRT engine adapter                                                                          |
|                                                                                  |                                                                                                                   |                                                                                                  |
| [ai.djl.python](https://search.maven.org/search?q=g:ai.djl.python)               | [python](https://github.com/deepjavalibrary/djl-serving/tree/master/engines/python/README.md#installation)        | Python engine adapter                                                                            |
|                                                                                  |                                                                                                                   |                                                                                                  |
| [ai.djl.ml.lightgbm](https://search.maven.org/search?q=g:ai.djl.ml.lightgbm)     | [lightgbm](../../engines/ml/lightgbm/README.md#installation)                                                      | LightGBM engine adapter                                                                          |
|                                                                                  |                                                                                                                   |                                                                                                  |
| [ai.djl.ml.xgboost](https://search.maven.org/search?q=g:ai.djl.ml.xgboost)       | [xgboost](../../engines/ml/xgboost/README.md#installation)                                                        | XGBoost engine adapter                                                                           |
|                                                                                  | [xgboost-gpu](../../engines/ml/xgboost/README.md#installation)                                                    | XGBoost engine adapter for GPU                                                                   |
|                                                                                  |                                                                                                                   |                                                                                                  |
| [ai.djl.android](https://search.maven.org/search?q=g:ai.djl.android)             | [core](../../android/README.md#installation)                                                                      | Contains Android specific utilities (e.g. ImageFactory) for DJL                                  |
|                                                                                  | [pytorch-native](../../android/pytorch-native/README.md)                                                          | Contains DJL PyTorch Android native package                                                      |
|                                                                                  | [onnxruntime](../../engines/onnxruntime/onnxruntime-android/README.md#installation)                               | Contains DJL Onnxruntime Android package                                                         |
|                                                                                  |                                                                                                                   |                                                                                                  |
| [ai.djl.audio](https://search.maven.org/search?q=g:ai.djl.audio)                 | [audio](../../extensions/audio/README.md#installation)                                                            | DJL audio support extension                                                                      |
|                                                                                  |                                                                                                                   |                                                                                                  |
| [ai.djl.aws](https://search.maven.org/search?q=g:ai.djl.aws)                     | [aws-ai](../../extensions/aws-ai/README.md#installation)                                                          | Contains classes that make it easy for DJL to access AWS services                                |
|                                                                                  |                                                                                                                   |                                                                                                  |
| [ai.djl.fasttext](https://search.maven.org/search?q=g:ai.djl.fasttext)           | [fasttext](../../extensions/fasttext/README.md#installation)                                                      | Contains NLP utility classes NLP for fastText                                                    |
|                                                                                  |                                                                                                                   |                                                                                                  |
| [ai.djl.hadoop](https://search.maven.org/search?q=g:ai.djl.hadoop)               | [hadoop](../../extensions/hadoop/README.md#installation)                                                          | Contains classes that make it easy for DJL access HDFS                                           |
|                                                                                  |                                                                                                                   |                                                                                                  |
| [ai.djl.opencv](https://search.maven.org/search?q=g:ai.djl.opencv)               | [opencv](../../extensions/opencv/README.md#installation)                                                          | DJL OpenCV extension for high performance image processing                                       |
|                                                                                  |                                                                                                                   |                                                                                                  |
| [ai.djl.sentencepiece](https://search.maven.org/search?q=g:ai.djl.sentencepiece) | [sentencepiece](../../extensions/sentencepiece/README.md#installation)                                            | Contains NLP utility classes for SentencePiece                                                   |
|                                                                                  |                                                                                                                   |                                                                                                  |
| [ai.djl.timeseries](https://search.maven.org/search?q=g:ai.djl.timeseries)       | [timeseries](../../extensions/timeseries/README.md#installation)                                                  | Contains Time Series data processing utility classes                                             |
|                                                                                  |                                                                                                                   |                                                                                                  |
| [ai.djl.tablesaw](https://search.maven.org/search?q=g:ai.djl.tablesaw)           | [tablesaw](../../extensions/tablesaw/README.md#installation)                                                      | Contains Tabular data processing utility classes                                                 |
|                                                                                  |                                                                                                                   |                                                                                                  |
| [ai.djl.tokenizers](https://search.maven.org/search?q=g:ai.djl.tokenizers)       | [tokenizers](../../extensions/tokenizers/README.md#installation)                                                  | DJL Huggingface tokenizers extension for NLP tokenize processing                                 |
|                                                                                  |                                                                                                                   |                                                                                                  |
| [ai.djl.serving](https://search.maven.org/search?q=g:ai.djl.serving)             | [wlm](https://github.com/deepjavalibrary/djl-serving/tree/master/wlm)                                             | DJL Serving WorkLoadManager                                                                      |
|                                                                                  |                                                                                                                   |                                                                                                  |
| [ai.djl.spark](https://search.maven.org/search?q=g:ai.djl.spark)                 | [spark_2.12](../../extensions/spark/README.md#installation)                                                       | DJL Spark extension                                                                              |
|                                                                                  | spark (deprecated)                                                                                                |                                                                                                  |
