# Documentation

This folder contains examples and documentation for the Deep Java Library (DJL) project.

## [JavaDoc API Reference](https://djl.ai/website/javadoc.html)

Note: when searching in JavaDoc, if your access is denied, please try removing the string `undefined` in the url.

## [Demos](https://djl.ai/website/demo.html)

## Cheat sheet

- [How to load a model](load_model.md)
- [How to collect metrics](how_to_collect_metrics.md)
- [How to use a dataset](development/how_to_use_dataset.md)
- [How to set log level](development/configure_logging.md)
- [Dependency Management](development/dependency_management.md)
- [Cache Management](development/cache_management.md)
- [Memory Management](development/memory_management.md)
- [Troubleshooting](development/troubleshooting.md)
- [Inference Optimization](development/inference_performance_optimization.md)

## [Jupyter notebook tutorials](https://docs.djl.ai/master/docs/demos/jupyter/index.html)

- **[Beginner Jupyter Tutorial](https://docs.djl.ai/master/docs/demos/jupyter/tutorial/index.html)**
- [Run object detection with model zoo](https://docs.djl.ai/master/docs/demos/jupyter/object_detection_with_model_zoo.html)
- [Load pre-trained PyTorch model](https://docs.djl.ai/master/docs/demos/jupyter/load_pytorch_model.html)
- [Load pre-trained Apache MXNet model](https://docs.djl.ai/master/docs/demos/jupyter/load_mxnet_model.html)
- [Transfer learning example](https://docs.djl.ai/master/docs/demos/jupyter/transfer_learning_on_cifar10.html)
- [Question answering example](https://docs.djl.ai/master/docs/demos/jupyter/BERTQA.html)

## [API Examples](../examples/README.md)

- [Single-shot Object Detection example](../examples/docs/object_detection.md)
- [Train your first model](../examples/docs/train_mnist_mlp.md)
- [Image classification example](../examples/docs/image_classification.md)
- [Transfer learning example](../examples/docs/train_cifar10_resnet.md)
- [Train SSD model example](../examples/docs/train_pikachu_ssd.md)
- [Bert question and answer example](../examples/docs/BERT_question_and_answer.md)
- [Instance segmentation example](../examples/docs/instance_segmentation.md)
- [Pose estimation example](../examples/docs/pose_estimation.md)
- [Action recognition example](../examples/docs/action_recognition.md)
- [Sentiment Analysis example](../examples/docs/sentiment_analysis.md)

## Engine Documentation

### [Apache MXNet](../engines/mxnet/README.md)

- [Apache MXNet Gluon Importing](mxnet/how_to_convert_your_model_to_symbol.md) - Apache MXNet Gluon Importing

### [PyTorch](../engines/pytorch/README.md)

- [PyTorch Importing](pytorch/how_to_convert_your_model_to_torchscript.md) - Import TorchScript model

### [TensorFlow](../engines/tensorflow/README.md)

- [TensorFlow Importing](tensorflow/how_to_import_tensorflow_models_in_DJL.md)

### [ONNX Runtime](../engines/onnxruntime/onnxruntime-engine/README.md)

- [Hybrid Engine Operations](hybrid_engine.md) - Using an alternative full Engine for supplemental API support

## Extensions and utilities

- [Android support](../android/README.md)
- [Audio support](../extensions/audio/README.md)
- [AWS S3 support](../extensions/aws-ai/README.md)
- [NLP support with fastText](../extensions/fasttext/README.md)
- [Hadoop support](../extensions/hadoop/README.md)
- [Image support with OpenCV](../extensions/opencv/README.md)
- [NLP support with SentencePiece](../extensions/sentencepiece/README.md)
- [Spark Support](../extensions/spark/README.md)
- [Tabular Dataset Support](../extensions/tablesaw/README.md)
- [TimeSeries support](../extensions/timeseries/README.md)
- [NLP support with Huggingface Tokenizers](../extensions/tokenizers/README.md)

## [Contributor Documentation](development/README.md)

- [Setup development environment](development/setup.md)
- [Development guideline](development/development_guideline.md)

## [Roadmap](roadmap.md)

## [Blogposts](blogposts.md)

## [FAQ](faq.md)
