# Решение возможных проблем при установке Elementary OS

К сожалению, несмотря на все прелести Elementary OS, уже на этапе установки у многих проявляются [проблемы](https://youtu.be/NPx8aH6oS14), которые могут напрочь лишить пользователей желания воспользоваться этой красивой и минималистичной системой.

В этом разделе я попытался собрать информацию, которая поможет установочные проблемы избежать.

**Содержание**

* [Проверка контрольной суммы образа ОС](#проверка-контрольной-суммы-скачанного-образа-ос)

* [Разметка диска](#разметка-диска)

* [Выбор системного языка](#выбор-системного-языка)

---

## Проверка контрольной суммы скачанного образа ОС

Проверьте контрольную сумму файла-образа Elementary ОС, чтобы убедиться в его целостности. Если образ был поврежден при скачивании, лучше узнать об этом сразу и скачать заново.

Как это сделать, [описано на официальном сайте](https://elementary.io/ru/docs/installation#verify-your-download).

1. В файловом менеджере перейдите в папку, куда скачали образ Elementary OS.

2. Нажмите ПКМ на свободном месте в поле с содержимым папки (где лежат файлы).

3. Из контекстного меню выберите **Открыть в → Терминал**.

4. В терминале выполните команду:

```
sha256sum elementaryos-7.0-stable.20230129rc.iso
```

где `elementaryos-7.0-stable.20230129rc.iso` имя актуального на текущий момент файла с образом Elementary ОС.

Полученный в терминале результат должен совпасть с [указанным на сайте](https://elementary.io/ru/docs/installation#verify-your-download).   
Например, для указанного выше образа, результат такой:

```
2bdffe0b0944405e87d6612fe7879b7af770ced20346453b9ef4b6057f4dd0af
```

Если есть расхождения, значит образ битый и его нужно скачать заново.

> ⚠️ **Примечание.**
> 
> При каждом обновлении файла, меняются его имя и контрольная сумма. Актуальность проверяйте на официальном сайте Elementary OS.

---

## Разметка диска

Одна из проблем при установке **Elementary OS** это, как ни странно, невозможность установки, если разметку диска доверить автоматике. Как правило, установка зависает на 35% или 70% и дальше не идет, либо установка прерывается, выдает ошибку и на этом все.

При ручной разметке лично у меня ни разу подобных печалей не возникало.

Будет здорово изучить тему разметки диска для Linux систем и при установке выбрать режим для опытных пользователей.

![эксперт](https://github.com/ded-ared/eos-all-about/blob/main/images/partition.png)

Во-первых, вы благополучно установите систему, а во-вторых, сами распределите дисковое пространство так, как надо именно вам.

🔵 Вот такая разметка, например, у меня:

| Order | Size     | File System | Mount Point | Flags     |
|-------|----------|-------------|-------------|-----------|
| 1     | 512 Mb   | fat32       | /boot/efi   | boot, esp |
| 2     | 50-55 Gb | btrfs       | /           |           |
| 3     | 8 GB     | linux-swap  |             | swap      |
| 4     | All      | btrfs       | /home       |           |

![gparted](https://github.com/ded-ared/eos-all-about/blob/main/images/gparted-disk-partition.png)

> **⚠️ Примечание:**
>
>Объем под ROOT и SWAP, файловую систему под ROOT и HOME выбирайте по своим потребностям и на свое усмотрение. Аналогично с видами и количеством разделов. Флаги, если что, можно присвоить после разметки в программе установки.
>

---

## Выбор системного языка

Многие говорят, что если при установке выбрать системным языком любой кроме английского, установка может глючить, застыть в вечности, а то и уже установленная ситема можоет чудить и т.д.

Лично я такого не замечал, но раз уж проблема встречается, как говорится, лучше перебдеть. Поэтому, чтобы подстраховаться:

* При установке оставьте английский язык, как он есть по умолчанию.

![lang-before](https://github.com/ded-ared/eos-all-about/blob/main/images/language-before.png)

* Нужный вам язык системы выберите уже после установки.   
  Для этого перейдите в **Параметры системы → Язык и регион**, настройте языковые параметры и перезагрузитесь.

![lang-after](https://github.com/ded-ared/eos-all-about/blob/main/images/language-after.png)
