# Настройка **Elementary OS** после установки

В этом разделе вы можете ознакомиться с некоторыми полезными, но не всегда очевидными дополнениями и настройками, которые помогут "допилить" [**Elementary OS**](https://elementary.io) под себя и сделать работу в системе комфоротнее.

После установки **Elementary OS** обязательно обновите систему штатными средствами и переходите к дальнейшей настройке, во время которой вы можете сделать следующее:

* [Скрыть меню GRUB при загрузке ОС](#скрыть-меню-grub-при-загрузке-ос)

* [Добавить возможность установки из репозиториев РРА](#добавить-возможность-устанавливать-программы-из-репозиториев-рра).

* [Заполнить App Center приложениями](#заполнить-app-center-приложениями)

* [Установить Pantheon Tweaks для расширенной настройки ОС](#установить-pantheon-tweaks-для-расширенной-настройки-ос)

* [Установить дополнительные настройки GNOME](#установить-дополнительные-настройки-gnome)

* [Добавить шрифты в систему](#установить-дополнительные-шрифты)

* [Подключить поддержку GTK тем для QT приложений](#подключить-поддержку-тем-gtk-для-qt-приложений)

* [Установить медиа кодеки](#установить-медиа-кодеки)

* [Вернуть системный трей](#вернуть-системный-трей)

---

## Скрыть меню GRUB при загрузке ОС

Возможно, вы заметили, что во время загрузки ОС сначала появляется меню [GRUB](https://ru.wikipedia.org/wiki/GNU_GRUB).

Это может быть полезно в редких случаях, но в повседневном использовании не нужно, тем более этот GRUB зависает на полминуты и нужно нажать **Enter**, чтобы миновать его побыстрее.   

🔵 Чтобы убрать эту тридцатисекундную медитацию, выполните следующее:

1. От имени админа откройте в текстовом редакторе файл:   

```
/etc/default/grub
```

2. Добавьте в него строку:   
```
GRUB_RECORDFAIL_TIMEOUT=0
```

![grub](https://github.com/ded-ared/eos-all-about/blob/main/images/grub-setup.png)

3. Сохраните изменения в файле.

4. В терминале обновите GRUB командой:   

```
sudo update-grub
```

5. Перезагрузитесь. Более GRUB вас раздражать не будет

>
> ⚠️ Если GRUB понадобится снова, удалите добавленную строку и не забудьте `sudo update-grub`.
>

---



## Добавить возможность устанавливать программы из репозиториев [РРА](https://help.ubuntu.ru/wiki/ppa)

**Elementary OS** настойчиво склоняет пользователей к установке программ через [**Flatpak**](https://docs.flatpak.org/ru/latest/introduction.html).   

Кому-то норм, кому-то все равно, а кому-то это категорически не нравится. Программы, установленные через **Flatpak**, далеко не всегда поддерживают общий стиль системы, у некоторых менее шустро работают и т.д.

🔵 Чтобы устанавливать программы по старинке через `sudo apt install`, выполните в терминале:

```
sudo apt install -y software-properties-common software-properties-gtk
```

Теперь командам [APT](https://pingvinus.ru/note/apt) есть, где развернуться. Вот несколько нужных:

* Найти программу: `sudo apt search <program-name>`

* Установить: `sudo apt install <program-name>`

* Удалить: `sudo apt remove <program-name>`

* Или удалить с тщательной подчисткой следов программы в системе: `sudo spt purge <program-name>`

|  🛈   Подробнее о командах APT можете почитать [здесь](https://pingvinus.ru/note/apt).  |
|---|

А еще теперь вы можете запустить в терминале

```
software-properties-gtk
```

и открыть вот такую штуку:

![ppa](https://github.com/ded-ared/eos-all-about/blob/main/images/software-property-gtk.png)

Мне отсюда удобно удалять поломанные репозитории. Если поизучать, много еще чего делать можно (но очень осторожно).

---

## Заполнить App Center приложениями

APT — это конечно хорошо, но так или иначе, Flatpak нужен.

После установки **Elementary** вы наверняка заметили, что в магазине приложений как-то пустовато. Почему так? Вопросы к разработчикам. Но исправить это легко. Нужно просто установить что-то из Флэтхаба.

1. Перейдите на сайт [Flathub](https://flathub.org/home).

2. Выберите нужное вам приложение.

3. Установите, как на примере ниже:

![flathub](https://github.com/ded-ared/eos-all-about/blob/main/images/install-from-flathub.png "установка через флэтхаб")

🔵 Во время установки в магазин приложений подтянутся все приложения с ресурса, ассортимент существенно расширится и в дальнейшем вы сможете устанавливать программы непосредственно из магазина.

---

## Установить Pantheon Tweaks для расширенной настройки ОС

Штатные системные настройки **Elementary** сведены к минимальному набору. С помощью [Pantheon Tweaks](https://github.com/pantheon-tweaks/pantheon-tweaks) можно этот набор расширить и получить дополнительные возможности.

![pt-tweaks](https://github.com/ded-ared/eos-all-about/blob/main/images/pantheon-tweaks.png)

Например, после установки **Pantheon Tweaks** вы сможете:

* выбрать системный шрифт;
* менять темы иконок и курсоров;
* настроить расположение кнопок управления окнами, а также добавить кнопку "свернуть окно";
* усилить громкость звука и еще некоторые вещи.

Чтобы установить **Pantheon Tweaks** и воспользоваться его возможностями, выполните следующее:

1. [Добавьте](#добавить-возможность-устанавливать-программы-из-репозиториев-рра) возможность установки приложений из репозиториев РРА, если еще этого не сделали.

2. В терминале поочередно выполните команды:

```
sudo add-apt-repository -y ppa:philip.scott/pantheon-tweaks
sudo apt install -y pantheon-tweaks
```

3. Откройте **Параметры системы**. Там появится дополнительный раздел **Твики**

![pt-tweaks-in](https://github.com/ded-ared/eos-all-about/blob/main/images/pantheon-tweaks-in-settings.png)

Теперь можно приступать к дополнительнм настройкам. (Лично я первым делом поменял шрифт по умолчанию. Штатный **Inter** очень уж "мыльный").

## Установить дополнительные настройки GNOME

**Дополнительные настройки GNOME** не очень рекомендую использовать в качестве основных, но среди них есть очень полезные, каких не хватает в **Pantheon Tweaks**, а именно:

🔵 Хинтинг и сглаживание шрифтов.

Со шрифтами в **Linux**... ну... такое себе. Они никогда не будут выглядеть настолько же четко, как в Windows. Именно поэтому пытаешься использовать все доступные средства, чтобы сберечь себе глаза.

Чтобы установить допнастройки GNOME, выполните в терминале:

```
sudo apt install gnome-tweaks
```

Чтобы запустить приложение, выполните:

```
gnome-tweaks
```

Можете приступать к настройке.

![gnome-settings](https://github.com/ded-ared/eos-all-about/blob/main/images/gnome-settings.png)

---

## Установить дополнительные шрифты

Поскольку рано или поздно придется иметь дело с файлами, созданными в MS Office, будет полезно установить шрифты MS в Linux.

В терминале выполните:

```
sudo apt install ttf-mscorefonts-installer
```
>
> ⚠️ При запуске команда Apt, приведенная выше загрузит и установит установщик Microsoft Core Fonts на ваш ПК и выведет текстовое лицензионное соглашение. Прочтите и выберите OK, чтобы согласиться, иначе шрифты не установятся.
>

Если хотите, можно установить еще несколько интересных шрифтов через терминал:

```
sudo apt install xfonts-terminus fonts-terminus ttf-dejavu fonts-liberation fonts-liberation2 fonts-crosextra-carlito fonts-crosextra-caladea fonts-cantarell
```

🔵 Чтобы установить любые сторонние шрифты в систему, создайте в домашней папке скрытую папку `/.fonts/` и копируйте в нее файлы шрифтов, например, в формате `<font-name.ttf>`

---

## Подключить поддержку тем GTK для QT приложений

**Elementary OS** основана на **Ubuntu 22.04** и использует библиотеки **GTK**. Иногда бывает нужно установить программу, которая основана на **Qt** (что это за библиотеки, рассказывать не буду, ибо сам не до конца понимаю, поэтому простите, Гугл в помощь). Основное разочарование возникает, когда видишь, что свежеустановленное приложение (например, Ksnip, qBittorrent и др.) не вписывается в общий стиль системы, не поддерживает темы, значки и т.д.

Чтобы хоть немного это исправить, можно установить средство настройки **Qt**. В моем случае **Qt5**.

1. В терминале выполните:

```
sudo apt install qt5-style-plugins qt5ct
```

2. Запустите приложение командой:

```
qt5ct
```

Можно настраивать и сразу понимать, как меняется вид **Qt** приложений.

![qt-settings](https://github.com/ded-ared/eos-all-about/blob/main/images/qt5-setting.png)

⚠️ Если программа настройки QT будет ругаться (в верхней части появится сообщение, что программа не настроена, а по клику всплывет предупреждение):

![qt-error](https://github.com/ded-ared/eos-all-about/blob/main/images/qt-error.png)

подправьте файлы в папке `~/etc/`, открыв их от имени администратора.

* В файле `/etc/profile.d/qt-style-override.sh` удалите строку `export QT_STYLE_OVERRIDE=adwaita` и сохраните.

* В файле `/etc/profile.d/qt-qpa-platformtheme.sh` должно быть так: `export QT_QPA_PLATFORMTHEME=qt5ct`.

---

## Установить медиа кодеки

Чтобы не возникло проблем с воспроизведением различных медиа файлов, будет не лишним установить в систему медиа кодеки.

В терминале выполните:

```
sudo apt install ubuntu-restricted-extras
```

---

## Вернуть системный трей

В Elementary OS, как вы заметили, отсутствует возможность сворачивать приложения в системный трей. Там только те опции, которые разработчики оставили штатно (прибили гвоздями).

Лично я к этому уже привык и легко обхожусь без трея. Однако, если он вам жизненно необходим, можете рискнуть и попробовать его вернуть.

* [Возвращаем системный трей](https://vk.com/@elementary_os-vozvraschaem-sistemnyi-trei) (статья из сообщества ВК)

* [Как вернуть системный трей в Elementary Juno](https://elementaryos.stackexchange.com/questions/17452/how-to-display-system-tray-icons-in-elementary-os-juno) (из англоязычного форума)

* [Как убрать задвоенную иконку WiFi после подключения системного трея](https://elementaryos.stackexchange.com/questions/21547/double-wi-fi-icon-after-installing-wingpanel-indicator-ayatana) (из англоязычного форума)

> ⚠️ Внимание!
> 
> Сам я описанные способы не пробовал. Пишут, что это работало в версиях Elementary до Juno. Сработает ли в Horus, неизвестно. Пробуйте на свой страх и риск!
