/*
 * Manual tuning file
 */
#include <samprate.h>
const short paul_8_tune[SPDEF] =
{
	0,				/* SEX */
	0,				/* SM (smoothness in %, actually spectral tilt offset) */
	0,				/* AS (assertiveness, degree of final f0 fall in % */
	0,				/* AP (Average pitch in Hz) */
	0,				/* PR (pitch range in percent of Paul's range) */
	0,				/* BR (breathiness in dB) */
	0,				/* RI (Richness in %, actually nopen is 100-RI % of T0) */
	0,				/* NF (additional fixed number of samples in nopen) */
	0,				/* LA (laryngealization, in percent) */
	0,				/* HS (head size, in percent relative to normal for SEX) */
	0,				/* F4 (frequency in Hz of cascade 4th formant = F4*100/HS) */
	0,				/* B4 (bandwidth in Hz of cascade 4th formant) */
	0,				/* F5 (frequency in Hz of cascade 5th formant = F5*100/HS) */
	0,				/* B5 (bandwidth in Hz of cascaded 5th formant) */
	0,				/* F7 (frequency in Hz of parallel 4th formant = F7) */
	0,				/* F8 (frequency in Hz of parallel 5th formant = F8) */
	0,				/* GF (gain of frication source in dB) */
	0,				/* GH (gain of aspiration source in dB) */
	0,				/* GV (gain of voicing source in dB ) */
	0,				/* GN (gain of input to cascade nasal pole pair in dB) */
	0,				/* G1 (gain of input to cascade 5th formant in dB) */
	0,				/* G2 (gain of input to cascade 4th formant in dB) */
	0,				/* G3 (gain of input to cascade 3rd formant in dB) */
	0,				/* G4 (gain of input to cascade 2nd formant in dB) */
	0,				/* LO (Loudness, gain input to cascade 1st formant in dB) */
	0,				/* FT (f0-dependent spectral tilt in % of max) */
	0,				/* BF (baseline f0 fall in Hz) */
	0,				/* LX (lax folds adjacent to voiceless sound -> breathiness) */
	0,				/* QU (quickness of larynx gestures in % of max quickness) */
	0,				/* HR (hat-pattern fundamental frequency rise in Hz) */
	0,				/* SR (height of max stress-rise impulse of f0 in Hz) */
	0,				/* AGO */
	0,				/* agvo */
	0,				/* aguo */
	0,				/* unvow */
	0,				/* chink area */
	0,				/* open quotient*/
	-33,				/* Output gain multiplier  */
}; /* PAUL_8 */

const short betty_8_tune[SPDEF] =
{
	0,				/* SEX */
	0,				/* SM (smoothness in %, actually spectral tilt offset) */
	0,				/* AS (assertiveness, degree of final f0 fall in % */
	0,				/* AP (Average pitch in Hz) */
	0,				/* PR (pitch range in percent of Paul's range) */
	0,				/* BR (breathiness in dB) */
	0,				/* RI (Richness in %, actually nopen is 100-RI % of T0) */
	0,				/* NF (additional fixed number of samples in nopen) */
	0,				/* LA (laryngealization, in percent) */
	0,				/* HS (head size, in percent relative to normal for SEX) */
	0,				/* F4 (frequency in Hz of cascade 4th formant = F4*100/HS) */
	0,				/* B4 (bandwidth in Hz of cascade 4th formant) */
	0,				/* F5 (frequency in Hz of cascade 5th formant = F5*100/HS) */
	0,				/* B5 (bandwidth in Hz of cascaded 5th formant) */
	0,				/* F7 (frequency in Hz of parallel 4th formant = F7) */
	0,				/* F8 (frequency in Hz of parallel 5th formant = F8) */
	0,				/* GF (gain of frication source in dB) */
	0,				/* GH (gain of aspiration source in dB) */
	0,				/* GV (gain of voicing source in dB ) */
	0,				/* GN (gain of input to cascade nasal pole pair in dB) */
	0,				/* G1 (gain of input to cascade 5th formant in dB) */
	0,				/* G2 (gain of input to cascade 4th formant in dB) */
	0,				/* G3 (gain of input to cascade 3rd formant in dB) */
	0,				/* G4 (gain of input to cascade 2nd formant in dB) */
	0,				/* LO (Loudness, gain input to cascade 1st formant in dB) */
	0,				/* FT (f0-dependent spectral tilt in % of max) */
	0,				/* BF (baseline f0 fall in Hz) */
	0,				/* LX (lax folds adjacent to voiceless sound -> breathiness) */
	0,				/* QU (quickness of larynx gestures in % of max quickness) */
	0,				/* HR (hat-pattern fundamental frequency rise in Hz) */
	0,				/* SR (height of max stress-rise impulse of f0 in Hz) */
	0,				/* AGO */
	0,				/* agvo */
	0,				/* aguo */
	0,				/* unvow */
	0,				/* chink area */
	0,				/* open quotient*/
	-24,				/* Output gain multiplier  */
}; /* BETTY_8 */

const short harry_8_tune[SPDEF] =
{
	0,				/* SEX */
	0,				/* SM (smoothness in %, actually spectral tilt offset) */
	0,				/* AS (assertiveness, degree of final f0 fall in % */
	0,				/* AP (Average pitch in Hz) */
	0,				/* PR (pitch range in percent of Paul's range) */
	0,				/* BR (breathiness in dB) */
	0,				/* RI (Richness in %, actually nopen is 100-RI % of T0) */
	0,				/* NF (additional fixed number of samples in nopen) */
	0,				/* LA (laryngealization, in percent) */
	0,				/* HS (head size, in percent relative to normal for SEX) */
	0,				/* F4 (frequency in Hz of cascade 4th formant = F4*100/HS) */
	0,				/* B4 (bandwidth in Hz of cascade 4th formant) */
	0,				/* F5 (frequency in Hz of cascade 5th formant = F5*100/HS) */
	0,				/* B5 (bandwidth in Hz of cascaded 5th formant) */
	0,				/* F7 (frequency in Hz of parallel 4th formant = F7) */
	0,				/* F8 (frequency in Hz of parallel 5th formant = F8) */
	0,				/* GF (gain of frication source in dB) */
	0,				/* GH (gain of aspiration source in dB) */
	0,				/* GV (gain of voicing source in dB ) */
	0,				/* GN (gain of input to cascade nasal pole pair in dB) */
	0,				/* G1 (gain of input to cascade 5th formant in dB) */
	0,				/* G2 (gain of input to cascade 4th formant in dB) */
	0,				/* G3 (gain of input to cascade 3rd formant in dB) */
	0,				/* G4 (gain of input to cascade 2nd formant in dB) */
	0,				/* LO (Loudness, gain input to cascade 1st formant in dB) */
	0,				/* FT (f0-dependent spectral tilt in % of max) */
	0,				/* BF (baseline f0 fall in Hz) */
	0,				/* LX (lax folds adjacent to voiceless sound -> breathiness) */
	0,				/* QU (quickness of larynx gestures in % of max quickness) */
	0,				/* HR (hat-pattern fundamental frequency rise in Hz) */
	0,				/* SR (height of max stress-rise impulse of f0 in Hz) */
	0,				/* AGO */
	0,				/* agvo */
	0,				/* aguo */
	0,				/* unvow */
	0,				/* chink area */
	0,				/* open quotient*/
	-30,				/* Output gain multiplier  */
}; /* HARRY_8 */

const short frank_8_tune[SPDEF] =
{
	0,				/* SEX */
	0,				/* SM (smoothness in %, actually spectral tilt offset) */
	0,				/* AS (assertiveness, degree of final f0 fall in % */
	0,				/* AP (Average pitch in Hz) */
	0,				/* PR (pitch range in percent of Paul's range) */
	0,				/* BR (breathiness in dB) */
	0,				/* RI (Richness in %, actually nopen is 100-RI % of T0) */
	0,				/* NF (additional fixed number of samples in nopen) */
	0,				/* LA (laryngealization, in percent) */
	0,				/* HS (head size, in percent relative to normal for SEX) */
	0,				/* F4 (frequency in Hz of cascade 4th formant = F4*100/HS) */
	0,				/* B4 (bandwidth in Hz of cascade 4th formant) */
	0,				/* F5 (frequency in Hz of cascade 5th formant = F5*100/HS) */
	0,				/* B5 (bandwidth in Hz of cascaded 5th formant) */
	0,				/* F7 (frequency in Hz of parallel 4th formant = F7) */
	0,				/* F8 (frequency in Hz of parallel 5th formant = F8) */
	0,				/* GF (gain of frication source in dB) */
	0,				/* GH (gain of aspiration source in dB) */
	0,				/* GV (gain of voicing source in dB ) */
	0,				/* GN (gain of input to cascade nasal pole pair in dB) */
	0,				/* G1 (gain of input to cascade 5th formant in dB) */
	0,				/* G2 (gain of input to cascade 4th formant in dB) */
	0,				/* G3 (gain of input to cascade 3rd formant in dB) */
	0,				/* G4 (gain of input to cascade 2nd formant in dB) */
	0,				/* LO (Loudness, gain input to cascade 1st formant in dB) */
	0,				/* FT (f0-dependent spectral tilt in % of max) */
	0,				/* BF (baseline f0 fall in Hz) */
	0,				/* LX (lax folds adjacent to voiceless sound -> breathiness) */
	0,				/* QU (quickness of larynx gestures in % of max quickness) */
	0,				/* HR (hat-pattern fundamental frequency rise in Hz) */
	0,				/* SR (height of max stress-rise impulse of f0 in Hz) */
	0,				/* AGO */
	0,				/* agvo */
	0,				/* aguo */
	0,				/* unvow */
	0,				/* chink area */
	0,				/* open quotient*/
	-33,				/* Output gain multiplier  */
}; /* FRANK_8 */

const short kit_8_tune[SPDEF] =
{
	0,				/* SEX */
	0,				/* SM (smoothness in %, actually spectral tilt offset) */
	0,				/* AS (assertiveness, degree of final f0 fall in % */
	0,				/* AP (Average pitch in Hz) */
	0,				/* PR (pitch range in percent of Paul's range) */
	0,				/* BR (breathiness in dB) */
	0,				/* RI (Richness in %, actually nopen is 100-RI % of T0) */
	0,				/* NF (additional fixed number of samples in nopen) */
	0,				/* LA (laryngealization, in percent) */
	0,				/* HS (head size, in percent relative to normal for SEX) */
	0,				/* F4 (frequency in Hz of cascade 4th formant = F4*100/HS) */
	0,				/* B4 (bandwidth in Hz of cascade 4th formant) */
	0,				/* F5 (frequency in Hz of cascade 5th formant = F5*100/HS) */
	0,				/* B5 (bandwidth in Hz of cascaded 5th formant) */
	0,				/* F7 (frequency in Hz of parallel 4th formant = F7) */
	0,				/* F8 (frequency in Hz of parallel 5th formant = F8) */
	0,				/* GF (gain of frication source in dB) */
	0,				/* GH (gain of aspiration source in dB) */
	0,				/* GV (gain of voicing source in dB ) */
	0,				/* GN (gain of input to cascade nasal pole pair in dB) */
	0,				/* G1 (gain of input to cascade 5th formant in dB) */
	0,				/* G2 (gain of input to cascade 4th formant in dB) */
	0,				/* G3 (gain of input to cascade 3rd formant in dB) */
	0,				/* G4 (gain of input to cascade 2nd formant in dB) */
	0,				/* LO (Loudness, gain input to cascade 1st formant in dB) */
	0,				/* FT (f0-dependent spectral tilt in % of max) */
	0,				/* BF (baseline f0 fall in Hz) */
	0,				/* LX (lax folds adjacent to voiceless sound -> breathiness) */
	0,				/* QU (quickness of larynx gestures in % of max quickness) */
	0,				/* HR (hat-pattern fundamental frequency rise in Hz) */
	0,				/* SR (height of max stress-rise impulse of f0 in Hz) */
	0,				/* AGO */
	0,				/* agvo */
	0,				/* aguo */
	0,				/* unvow */
	0,				/* chink area */
	0,				/* open quotient*/
	-9,				/* Output gain multiplier  */
}; /* KIT_8 */

const short ursula_8_tune[SPDEF] =
{
	0,				/* SEX */
	0,				/* SM (smoothness in %, actually spectral tilt offset) */
	0,				/* AS (assertiveness, degree of final f0 fall in % */
	0,				/* AP (Average pitch in Hz) */
	0,				/* PR (pitch range in percent of Paul's range) */
	0,				/* BR (breathiness in dB) */
	0,				/* RI (Richness in %, actually nopen is 100-RI % of T0) */
	0,				/* NF (additional fixed number of samples in nopen) */
	0,				/* LA (laryngealization, in percent) */
	0,				/* HS (head size, in percent relative to normal for SEX) */
	0,				/* F4 (frequency in Hz of cascade 4th formant = F4*100/HS) */
	0,				/* B4 (bandwidth in Hz of cascade 4th formant) */
	0,				/* F5 (frequency in Hz of cascade 5th formant = F5*100/HS) */
	0,				/* B5 (bandwidth in Hz of cascaded 5th formant) */
	0,				/* F7 (frequency in Hz of parallel 4th formant = F7) */
	0,				/* F8 (frequency in Hz of parallel 5th formant = F8) */
	0,				/* GF (gain of frication source in dB) */
	0,				/* GH (gain of aspiration source in dB) */
	0,				/* GV (gain of voicing source in dB ) */
	0,				/* GN (gain of input to cascade nasal pole pair in dB) */
	0,				/* G1 (gain of input to cascade 5th formant in dB) */
	0,				/* G2 (gain of input to cascade 4th formant in dB) */
	0,				/* G3 (gain of input to cascade 3rd formant in dB) */
	0,				/* G4 (gain of input to cascade 2nd formant in dB) */
	0,				/* LO (Loudness, gain input to cascade 1st formant in dB) */
	0,				/* FT (f0-dependent spectral tilt in % of max) */
	0,				/* BF (baseline f0 fall in Hz) */
	0,				/* LX (lax folds adjacent to voiceless sound -> breathiness) */
	0,				/* QU (quickness of larynx gestures in % of max quickness) */
	0,				/* HR (hat-pattern fundamental frequency rise in Hz) */
	0,				/* SR (height of max stress-rise impulse of f0 in Hz) */
	0,				/* AGO */
	0,				/* agvo */
	0,				/* aguo */
	0,				/* unvow */
	0,				/* chink area */
	0,				/* open quotient*/
	-24,				/* Output gain multiplier  */
}; /* URSULA_8 */

const short rita_8_tune[SPDEF] =
{
	0,				/* SEX */
	0,				/* SM (smoothness in %, actually spectral tilt offset) */
	0,				/* AS (assertiveness, degree of final f0 fall in % */
	0,				/* AP (Average pitch in Hz) */
	0,				/* PR (pitch range in percent of Paul's range) */
	0,				/* BR (breathiness in dB) */
	0,				/* RI (Richness in %, actually nopen is 100-RI % of T0) */
	0,				/* NF (additional fixed number of samples in nopen) */
	0,				/* LA (laryngealization, in percent) */
	0,				/* HS (head size, in percent relative to normal for SEX) */
	0,				/* F4 (frequency in Hz of cascade 4th formant = F4*100/HS) */
	0,				/* B4 (bandwidth in Hz of cascade 4th formant) */
	0,				/* F5 (frequency in Hz of cascade 5th formant = F5*100/HS) */
	0,				/* B5 (bandwidth in Hz of cascaded 5th formant) */
	0,				/* F7 (frequency in Hz of parallel 4th formant = F7) */
	0,				/* F8 (frequency in Hz of parallel 5th formant = F8) */
	0,				/* GF (gain of frication source in dB) */
	0,				/* GH (gain of aspiration source in dB) */
	0,				/* GV (gain of voicing source in dB ) */
	0,				/* GN (gain of input to cascade nasal pole pair in dB) */
	0,				/* G1 (gain of input to cascade 5th formant in dB) */
	0,				/* G2 (gain of input to cascade 4th formant in dB) */
	0,				/* G3 (gain of input to cascade 3rd formant in dB) */
	0,				/* G4 (gain of input to cascade 2nd formant in dB) */
	0,				/* LO (Loudness, gain input to cascade 1st formant in dB) */
	0,				/* FT (f0-dependent spectral tilt in % of max) */
	0,				/* BF (baseline f0 fall in Hz) */
	0,				/* LX (lax folds adjacent to voiceless sound -> breathiness) */
	0,				/* QU (quickness of larynx gestures in % of max quickness) */
	0,				/* HR (hat-pattern fundamental frequency rise in Hz) */
	0,				/* SR (height of max stress-rise impulse of f0 in Hz) */
	0,				/* AGO */
	0,				/* agvo */
	0,				/* aguo */
	0,				/* unvow */
	0,				/* chink area */
	0,				/* open quotient*/
	-27,				/* Output gain multiplier  */
}; /* RITA_8 */

const short wendy_8_tune[SPDEF] =
{
	0,				/* SEX */
	0,				/* SM (smoothness in %, actually spectral tilt offset) */
	0,				/* AS (assertiveness, degree of final f0 fall in % */
	0,				/* AP (Average pitch in Hz) */
	0,				/* PR (pitch range in percent of Paul's range) */
	0,				/* BR (breathiness in dB) */
	0,				/* RI (Richness in %, actually nopen is 100-RI % of T0) */
	0,				/* NF (additional fixed number of samples in nopen) */
	0,				/* LA (laryngealization, in percent) */
	0,				/* HS (head size, in percent relative to normal for SEX) */
	0,				/* F4 (frequency in Hz of cascade 4th formant = F4*100/HS) */
	0,				/* B4 (bandwidth in Hz of cascade 4th formant) */
	0,				/* F5 (frequency in Hz of cascade 5th formant = F5*100/HS) */
	0,				/* B5 (bandwidth in Hz of cascaded 5th formant) */
	0,				/* F7 (frequency in Hz of parallel 4th formant = F7) */
	0,				/* F8 (frequency in Hz of parallel 5th formant = F8) */
	0,				/* GF (gain of frication source in dB) */
	0,				/* GH (gain of aspiration source in dB) */
	0,				/* GV (gain of voicing source in dB ) */
	0,				/* GN (gain of input to cascade nasal pole pair in dB) */
	0,				/* G1 (gain of input to cascade 5th formant in dB) */
	0,				/* G2 (gain of input to cascade 4th formant in dB) */
	0,				/* G3 (gain of input to cascade 3rd formant in dB) */
	0,				/* G4 (gain of input to cascade 2nd formant in dB) */
	0,				/* LO (Loudness, gain input to cascade 1st formant in dB) */
	0,				/* FT (f0-dependent spectral tilt in % of max) */
	0,				/* BF (baseline f0 fall in Hz) */
	0,				/* LX (lax folds adjacent to voiceless sound -> breathiness) */
	0,				/* QU (quickness of larynx gestures in % of max quickness) */
	0,				/* HR (hat-pattern fundamental frequency rise in Hz) */
	0,				/* SR (height of max stress-rise impulse of f0 in Hz) */
	0,				/* AGO */
	0,				/* agvo */
	0,				/* aguo */
	0,				/* unvow */
	0,				/* chink area */
	0,				/* open quotient*/
	-12,				/* Output gain multiplier  */
}; /* WENDY_8 */

const short dennis_8_tune[SPDEF] =
{
	0,				/* SEX */
	0,				/* SM (smoothness in %, actually spectral tilt offset) */
	0,				/* AS (assertiveness, degree of final f0 fall in % */
	0,				/* AP (Average pitch in Hz) */
	0,				/* PR (pitch range in percent of Paul's range) */
	0,				/* BR (breathiness in dB) */
	0,				/* RI (Richness in %, actually nopen is 100-RI % of T0) */
	0,				/* NF (additional fixed number of samples in nopen) */
	0,				/* LA (laryngealization, in percent) */
	0,				/* HS (head size, in percent relative to normal for SEX) */
	0,				/* F4 (frequency in Hz of cascade 4th formant = F4*100/HS) */
	0,				/* B4 (bandwidth in Hz of cascade 4th formant) */
	0,				/* F5 (frequency in Hz of cascade 5th formant = F5*100/HS) */
	0,				/* B5 (bandwidth in Hz of cascaded 5th formant) */
	0,				/* F7 (frequency in Hz of parallel 4th formant = F7) */
	0,				/* F8 (frequency in Hz of parallel 5th formant = F8) */
	0,				/* GF (gain of frication source in dB) */
	0,				/* GH (gain of aspiration source in dB) */
	0,				/* GV (gain of voicing source in dB ) */
	0,				/* GN (gain of input to cascade nasal pole pair in dB) */
	0,				/* G1 (gain of input to cascade 5th formant in dB) */
	0,				/* G2 (gain of input to cascade 4th formant in dB) */
	0,				/* G3 (gain of input to cascade 3rd formant in dB) */
	0,				/* G4 (gain of input to cascade 2nd formant in dB) */
	0,				/* LO (Loudness, gain input to cascade 1st formant in dB) */
	0,				/* FT (f0-dependent spectral tilt in % of max) */
	0,				/* BF (baseline f0 fall in Hz) */
	0,				/* LX (lax folds adjacent to voiceless sound -> breathiness) */
	0,				/* QU (quickness of larynx gestures in % of max quickness) */
	0,				/* HR (hat-pattern fundamental frequency rise in Hz) */
	0,				/* SR (height of max stress-rise impulse of f0 in Hz) */
	0,				/* AGO */
	0,				/* agvo */
	0,				/* aguo */
	0,				/* unvow */
	0,				/* chink area */
	0,				/* open quotient*/
	-27,				/* Output gain multiplier  */
}; /* DENNIS_8 */

const short paul_tune[SPDEF] =
{
	0,				/* SEX */
	0,				/* SM (smoothness in %, actually spectral tilt offset) */
	0,				/* AS (assertiveness, degree of final f0 fall in % */
	0,				/* AP (Average pitch in Hz) */
	0,				/* PR (pitch range in percent of Paul's range) */
	0,				/* BR (breathiness in dB) */
	0,				/* RI (Richness in %, actually nopen is 100-RI % of T0) */
	0,				/* NF (additional fixed number of samples in nopen) */
	0,				/* LA (laryngealization, in percent) */
	0,				/* HS (head size, in percent relative to normal for SEX) */
	0,				/* F4 (frequency in Hz of cascade 4th formant = F4*100/HS) */
	0,				/* B4 (bandwidth in Hz of cascade 4th formant) */
	0,				/* F5 (frequency in Hz of cascade 5th formant = F5*100/HS) */
	0,				/* B5 (bandwidth in Hz of cascaded 5th formant) */
	0,				/* F7 (frequency in Hz of parallel 4th formant = F7) */
	0,				/* F8 (frequency in Hz of parallel 5th formant = F8) */
	0,				/* GF (gain of frication source in dB) */
	0,				/* GH (gain of aspiration source in dB) */
	0,				/* GV (gain of voicing source in dB ) */
	0,				/* GN (gain of input to cascade nasal pole pair in dB) */
	0,				/* G1 (gain of input to cascade 5th formant in dB) */
	0,				/* G2 (gain of input to cascade 4th formant in dB) */
	0,				/* G3 (gain of input to cascade 3rd formant in dB) */
	0,				/* G4 (gain of input to cascade 2nd formant in dB) */
	0,				/* LO (Loudness, gain input to cascade 1st formant in dB) */
	0,				/* FT (f0-dependent spectral tilt in % of max) */
	0,				/* BF (baseline f0 fall in Hz) */
	0,				/* LX (lax folds adjacent to voiceless sound -> breathiness) */
	0,				/* QU (quickness of larynx gestures in % of max quickness) */
	0,				/* HR (hat-pattern fundamental frequency rise in Hz) */
	0,				/* SR (height of max stress-rise impulse of f0 in Hz) */
	0,				/* AGO */
	0,				/* agvo */
	0,				/* aguo */
	0,				/* unvow */
	0,				/* chink area */
	0,				/* open quotient*/
#if PC_SAMPLE_RATE == 22050
	-1,				/* Output gain multiplier  */
#else
	-1,				/* Output gain multiplier  */
#endif
}; /* PAUL */

const short betty_tune[SPDEF] =
{
	0,				/* SEX */
	0,				/* SM (smoothness in %, actually spectral tilt offset) */
	0,				/* AS (assertiveness, degree of final f0 fall in % */
	0,				/* AP (Average pitch in Hz) */
	0,				/* PR (pitch range in percent of Paul's range) */
	0,				/* BR (breathiness in dB) */
	0,				/* RI (Richness in %, actually nopen is 100-RI % of T0) */
	0,				/* NF (additional fixed number of samples in nopen) */
	0,				/* LA (laryngealization, in percent) */
	0,				/* HS (head size, in percent relative to normal for SEX) */
	0,				/* F4 (frequency in Hz of cascade 4th formant = F4*100/HS) */
	0,				/* B4 (bandwidth in Hz of cascade 4th formant) */
	0,				/* F5 (frequency in Hz of cascade 5th formant = F5*100/HS) */
	0,				/* B5 (bandwidth in Hz of cascaded 5th formant) */
	0,				/* F7 (frequency in Hz of parallel 4th formant = F7) */
	0,				/* F8 (frequency in Hz of parallel 5th formant = F8) */
	0,				/* GF (gain of frication source in dB) */
	0,				/* GH (gain of aspiration source in dB) */
	0,				/* GV (gain of voicing source in dB ) */
	0,				/* GN (gain of input to cascade nasal pole pair in dB) */
	0,				/* G1 (gain of input to cascade 5th formant in dB) */
	0,				/* G2 (gain of input to cascade 4th formant in dB) */
	0,				/* G3 (gain of input to cascade 3rd formant in dB) */
	0,				/* G4 (gain of input to cascade 2nd formant in dB) */
	0,				/* LO (Loudness, gain input to cascade 1st formant in dB) */
	0,				/* FT (f0-dependent spectral tilt in % of max) */
	0,				/* BF (baseline f0 fall in Hz) */
	0,				/* LX (lax folds adjacent to voiceless sound -> breathiness) */
	0,				/* QU (quickness of larynx gestures in % of max quickness) */
	0,				/* HR (hat-pattern fundamental frequency rise in Hz) */
	0,				/* SR (height of max stress-rise impulse of f0 in Hz) */
	0,				/* AGO */
	0,				/* agvo */
	0,				/* aguo */
	0,				/* unvow */
	0,				/* chink area */
	0,				/* open quotient*/
#if PC_SAMPLE_RATE == 22050
	9,				/* Output gain multiplier  */
#else
	-1,				/* Output gain multiplier  */
#endif
}; /* BETTY */

const short harry_tune[SPDEF] =
{
	0,				/* SEX */
	0,				/* SM (smoothness in %, actually spectral tilt offset) */
	0,				/* AS (assertiveness, degree of final f0 fall in % */
	0,				/* AP (Average pitch in Hz) */
	0,				/* PR (pitch range in percent of Paul's range) */
	0,				/* BR (breathiness in dB) */
	0,				/* RI (Richness in %, actually nopen is 100-RI % of T0) */
	0,				/* NF (additional fixed number of samples in nopen) */
	0,				/* LA (laryngealization, in percent) */
	0,				/* HS (head size, in percent relative to normal for SEX) */
	0,				/* F4 (frequency in Hz of cascade 4th formant = F4*100/HS) */
	0,				/* B4 (bandwidth in Hz of cascade 4th formant) */
	0,				/* F5 (frequency in Hz of cascade 5th formant = F5*100/HS) */
	0,				/* B5 (bandwidth in Hz of cascaded 5th formant) */
	0,				/* F7 (frequency in Hz of parallel 4th formant = F7) */
	0,				/* F8 (frequency in Hz of parallel 5th formant = F8) */
	0,				/* GF (gain of frication source in dB) */
	0,				/* GH (gain of aspiration source in dB) */
	0,				/* GV (gain of voicing source in dB ) */
	0,				/* GN (gain of input to cascade nasal pole pair in dB) */
	0,				/* G1 (gain of input to cascade 5th formant in dB) */
	0,				/* G2 (gain of input to cascade 4th formant in dB) */
	0,				/* G3 (gain of input to cascade 3rd formant in dB) */
	0,				/* G4 (gain of input to cascade 2nd formant in dB) */
	0,				/* LO (Loudness, gain input to cascade 1st formant in dB) */
	0,				/* FT (f0-dependent spectral tilt in % of max) */
	0,				/* BF (baseline f0 fall in Hz) */
	0,				/* LX (lax folds adjacent to voiceless sound -> breathiness) */
	0,				/* QU (quickness of larynx gestures in % of max quickness) */
	0,				/* HR (hat-pattern fundamental frequency rise in Hz) */
	0,				/* SR (height of max stress-rise impulse of f0 in Hz) */
	0,				/* AGO */
	0,				/* agvo */
	0,				/* aguo */
	0,				/* unvow */
	0,				/* chink area */
	0,				/* open quotient*/
#if PC_SAMPLE_RATE == 22050
	-5,				/* Output gain multiplier  */
#else
	-3,				/* Output gain multiplier  */
#endif
}; /* HARRY */

const short frank_tune[SPDEF] =
{
	0,				/* SEX */
	0,				/* SM (smoothness in %, actually spectral tilt offset) */
	0,				/* AS (assertiveness, degree of final f0 fall in % */
	0,				/* AP (Average pitch in Hz) */
	0,				/* PR (pitch range in percent of Paul's range) */
	0,				/* BR (breathiness in dB) */
	0,				/* RI (Richness in %, actually nopen is 100-RI % of T0) */
	0,				/* NF (additional fixed number of samples in nopen) */
	0,				/* LA (laryngealization, in percent) */
	0,				/* HS (head size, in percent relative to normal for SEX) */
	0,				/* F4 (frequency in Hz of cascade 4th formant = F4*100/HS) */
	0,				/* B4 (bandwidth in Hz of cascade 4th formant) */
	0,				/* F5 (frequency in Hz of cascade 5th formant = F5*100/HS) */
	0,				/* B5 (bandwidth in Hz of cascaded 5th formant) */
	0,				/* F7 (frequency in Hz of parallel 4th formant = F7) */
	0,				/* F8 (frequency in Hz of parallel 5th formant = F8) */
	0,				/* GF (gain of frication source in dB) */
	0,				/* GH (gain of aspiration source in dB) */
	0,				/* GV (gain of voicing source in dB ) */
	0,				/* GN (gain of input to cascade nasal pole pair in dB) */
	0,				/* G1 (gain of input to cascade 5th formant in dB) */
	0,				/* G2 (gain of input to cascade 4th formant in dB) */
	0,				/* G3 (gain of input to cascade 3rd formant in dB) */
	0,				/* G4 (gain of input to cascade 2nd formant in dB) */
	0,				/* LO (Loudness, gain input to cascade 1st formant in dB) */
	0,				/* FT (f0-dependent spectral tilt in % of max) */
	0,				/* BF (baseline f0 fall in Hz) */
	0,				/* LX (lax folds adjacent to voiceless sound -> breathiness) */
	0,				/* QU (quickness of larynx gestures in % of max quickness) */
	0,				/* HR (hat-pattern fundamental frequency rise in Hz) */
	0,				/* SR (height of max stress-rise impulse of f0 in Hz) */
	0,				/* AGO */
	0,				/* agvo */
	0,				/* aguo */
	0,				/* unvow */
	0,				/* chink area */
	0,				/* open quotient*/
#if PC_SAMPLE_RATE == 22050
	2,				/* Output gain multiplier  */
#else
	3,				/* Output gain multiplier  */
#endif
}; /* FRANK */

const short kit_tune[SPDEF] =
{
	0,				/* SEX */
	0,				/* SM (smoothness in %, actually spectral tilt offset) */
	0,				/* AS (assertiveness, degree of final f0 fall in % */
	0,				/* AP (Average pitch in Hz) */
	0,				/* PR (pitch range in percent of Paul's range) */
	0,				/* BR (breathiness in dB) */
	0,				/* RI (Richness in %, actually nopen is 100-RI % of T0) */
	0,				/* NF (additional fixed number of samples in nopen) */
	0,				/* LA (laryngealization, in percent) */
	0,				/* HS (head size, in percent relative to normal for SEX) */
	0,				/* F4 (frequency in Hz of cascade 4th formant = F4*100/HS) */
	0,				/* B4 (bandwidth in Hz of cascade 4th formant) */
	0,				/* F5 (frequency in Hz of cascade 5th formant = F5*100/HS) */
	0,				/* B5 (bandwidth in Hz of cascaded 5th formant) */
	0,				/* F7 (frequency in Hz of parallel 4th formant = F7) */
	0,				/* F8 (frequency in Hz of parallel 5th formant = F8) */
	0,				/* GF (gain of frication source in dB) */
	0,				/* GH (gain of aspiration source in dB) */
	0,				/* GV (gain of voicing source in dB ) */
	0,				/* GN (gain of input to cascade nasal pole pair in dB) */
	0,				/* G1 (gain of input to cascade 5th formant in dB) */
	0,				/* G2 (gain of input to cascade 4th formant in dB) */
	0,				/* G3 (gain of input to cascade 3rd formant in dB) */
	0,				/* G4 (gain of input to cascade 2nd formant in dB) */
	0,				/* LO (Loudness, gain input to cascade 1st formant in dB) */
	0,				/* FT (f0-dependent spectral tilt in % of max) */
	0,				/* BF (baseline f0 fall in Hz) */
	0,				/* LX (lax folds adjacent to voiceless sound -> breathiness) */
	0,				/* QU (quickness of larynx gestures in % of max quickness) */
	0,				/* HR (hat-pattern fundamental frequency rise in Hz) */
	0,				/* SR (height of max stress-rise impulse of f0 in Hz) */
	0,				/* AGO */
	0,				/* agvo */
	0,				/* aguo */
	0,				/* unvow */
	0,				/* chink area */
	0,				/* open quotient*/
#if PC_SAMPLE_RATE == 22050
	15,				/* Output gain multiplier  */
#else
	-1,				/* Output gain multiplier  */
#endif
}; /* KIT */

const short ursula_tune[SPDEF] =
{
	0,				/* SEX */
	0,				/* SM (smoothness in %, actually spectral tilt offset) */
	0,				/* AS (assertiveness, degree of final f0 fall in % */
	0,				/* AP (Average pitch in Hz) */
	0,				/* PR (pitch range in percent of Paul's range) */
	0,				/* BR (breathiness in dB) */
	0,				/* RI (Richness in %, actually nopen is 100-RI % of T0) */
	0,				/* NF (additional fixed number of samples in nopen) */
	0,				/* LA (laryngealization, in percent) */
	0,				/* HS (head size, in percent relative to normal for SEX) */
	0,				/* F4 (frequency in Hz of cascade 4th formant = F4*100/HS) */
	0,				/* B4 (bandwidth in Hz of cascade 4th formant) */
	0,				/* F5 (frequency in Hz of cascade 5th formant = F5*100/HS) */
	0,				/* B5 (bandwidth in Hz of cascaded 5th formant) */
	0,				/* F7 (frequency in Hz of parallel 4th formant = F7) */
	0,				/* F8 (frequency in Hz of parallel 5th formant = F8) */
	0,				/* GF (gain of frication source in dB) */
	0,				/* GH (gain of aspiration source in dB) */
	0,				/* GV (gain of voicing source in dB ) */
	0,				/* GN (gain of input to cascade nasal pole pair in dB) */
	0,				/* G1 (gain of input to cascade 5th formant in dB) */
	0,				/* G2 (gain of input to cascade 4th formant in dB) */
	0,				/* G3 (gain of input to cascade 3rd formant in dB) */
	0,				/* G4 (gain of input to cascade 2nd formant in dB) */
	0,				/* LO (Loudness, gain input to cascade 1st formant in dB) */
	0,				/* FT (f0-dependent spectral tilt in % of max) */
	0,				/* BF (baseline f0 fall in Hz) */
	0,				/* LX (lax folds adjacent to voiceless sound -> breathiness) */
	0,				/* QU (quickness of larynx gestures in % of max quickness) */
	0,				/* HR (hat-pattern fundamental frequency rise in Hz) */
	0,				/* SR (height of max stress-rise impulse of f0 in Hz) */
	0,				/* AGO */
	0,				/* agvo */
	0,				/* aguo */
	0,				/* unvow */
	0,				/* chink area */
	0,				/* open quotient*/
#if PC_SAMPLE_RATE == 22050
	6,				/* Output gain multiplier  */
#else
	0,				/* Output gain multiplier  */
#endif
}; /* URSULA */

const short rita_tune[SPDEF] =
{
	0,				/* SEX */
	0,				/* SM (smoothness in %, actually spectral tilt offset) */
	0,				/* AS (assertiveness, degree of final f0 fall in % */
	0,				/* AP (Average pitch in Hz) */
	0,				/* PR (pitch range in percent of Paul's range) */
	0,				/* BR (breathiness in dB) */
	0,				/* RI (Richness in %, actually nopen is 100-RI % of T0) */
	0,				/* NF (additional fixed number of samples in nopen) */
	0,				/* LA (laryngealization, in percent) */
	0,				/* HS (head size, in percent relative to normal for SEX) */
	0,				/* F4 (frequency in Hz of cascade 4th formant = F4*100/HS) */
	0,				/* B4 (bandwidth in Hz of cascade 4th formant) */
	0,				/* F5 (frequency in Hz of cascade 5th formant = F5*100/HS) */
	0,				/* B5 (bandwidth in Hz of cascaded 5th formant) */
	0,				/* F7 (frequency in Hz of parallel 4th formant = F7) */
	0,				/* F8 (frequency in Hz of parallel 5th formant = F8) */
	0,				/* GF (gain of frication source in dB) */
	0,				/* GH (gain of aspiration source in dB) */
	0,				/* GV (gain of voicing source in dB ) */
	0,				/* GN (gain of input to cascade nasal pole pair in dB) */
	0,				/* G1 (gain of input to cascade 5th formant in dB) */
	0,				/* G2 (gain of input to cascade 4th formant in dB) */
	0,				/* G3 (gain of input to cascade 3rd formant in dB) */
	0,				/* G4 (gain of input to cascade 2nd formant in dB) */
	0,				/* LO (Loudness, gain input to cascade 1st formant in dB) */
	0,				/* FT (f0-dependent spectral tilt in % of max) */
	0,				/* BF (baseline f0 fall in Hz) */
	0,				/* LX (lax folds adjacent to voiceless sound -> breathiness) */
	0,				/* QU (quickness of larynx gestures in % of max quickness) */
	0,				/* HR (hat-pattern fundamental frequency rise in Hz) */
	0,				/* SR (height of max stress-rise impulse of f0 in Hz) */
	0,				/* AGO */
	0,				/* agvo */
	0,				/* aguo */
	0,				/* unvow */
	0,				/* chink area */
	0,				/* open quotient*/
#if PC_SAMPLE_RATE == 22050
	3,				/* Output gain multiplier  */
#else
	-3,				/* Output gain multiplier  */
#endif
}; /* RITA */

const short wendy_tune[SPDEF] =
{
	0,				/* SEX */
	0,				/* SM (smoothness in %, actually spectral tilt offset) */
	0,				/* AS (assertiveness, degree of final f0 fall in % */
	0,				/* AP (Average pitch in Hz) */
	0,				/* PR (pitch range in percent of Paul's range) */
	0,				/* BR (breathiness in dB) */
	0,				/* RI (Richness in %, actually nopen is 100-RI % of T0) */
	0,				/* NF (additional fixed number of samples in nopen) */
	0,				/* LA (laryngealization, in percent) */
	0,				/* HS (head size, in percent relative to normal for SEX) */
	0,				/* F4 (frequency in Hz of cascade 4th formant = F4*100/HS) */
	0,				/* B4 (bandwidth in Hz of cascade 4th formant) */
	0,				/* F5 (frequency in Hz of cascade 5th formant = F5*100/HS) */
	0,				/* B5 (bandwidth in Hz of cascaded 5th formant) */
	0,				/* F7 (frequency in Hz of parallel 4th formant = F7) */
	0,				/* F8 (frequency in Hz of parallel 5th formant = F8) */
	0,				/* GF (gain of frication source in dB) */
	0,				/* GH (gain of aspiration source in dB) */
	0,				/* GV (gain of voicing source in dB ) */
	0,				/* GN (gain of input to cascade nasal pole pair in dB) */
	0,				/* G1 (gain of input to cascade 5th formant in dB) */
	0,				/* G2 (gain of input to cascade 4th formant in dB) */
	0,				/* G3 (gain of input to cascade 3rd formant in dB) */
	0,				/* G4 (gain of input to cascade 2nd formant in dB) */
	0,				/* LO (Loudness, gain input to cascade 1st formant in dB) */
	0,				/* FT (f0-dependent spectral tilt in % of max) */
	0,				/* BF (baseline f0 fall in Hz) */
	0,				/* LX (lax folds adjacent to voiceless sound -> breathiness) */
	0,				/* QU (quickness of larynx gestures in % of max quickness) */
	0,				/* HR (hat-pattern fundamental frequency rise in Hz) */
	0,				/* SR (height of max stress-rise impulse of f0 in Hz) */
	0,				/* AGO */
	0,				/* agvo */
	0,				/* aguo */
	0,				/* unvow */
	0,				/* chink area */
	0,				/* open quotient*/
#if PC_SAMPLE_RATE == 22050
	8,				/* Output gain multiplier  */
#else
	6,				/* Output gain multiplier  */
#endif
}; /* WENDY */

const short dennis_tune[SPDEF] =
{
	0,				/* SEX */
	0,				/* SM (smoothness in %, actually spectral tilt offset) */
	0,				/* AS (assertiveness, degree of final f0 fall in % */
	0,				/* AP (Average pitch in Hz) */
	0,				/* PR (pitch range in percent of Paul's range) */
	0,				/* BR (breathiness in dB) */
	0,				/* RI (Richness in %, actually nopen is 100-RI % of T0) */
	0,				/* NF (additional fixed number of samples in nopen) */
	0,				/* LA (laryngealization, in percent) */
	0,				/* HS (head size, in percent relative to normal for SEX) */
	0,				/* F4 (frequency in Hz of cascade 4th formant = F4*100/HS) */
	0,				/* B4 (bandwidth in Hz of cascade 4th formant) */
	0,				/* F5 (frequency in Hz of cascade 5th formant = F5*100/HS) */
	0,				/* B5 (bandwidth in Hz of cascaded 5th formant) */
	0,				/* F7 (frequency in Hz of parallel 4th formant = F7) */
	0,				/* F8 (frequency in Hz of parallel 5th formant = F8) */
	0,				/* GF (gain of frication source in dB) */
	0,				/* GH (gain of aspiration source in dB) */
	0,				/* GV (gain of voicing source in dB ) */
	0,				/* GN (gain of input to cascade nasal pole pair in dB) */
	0,				/* G1 (gain of input to cascade 5th formant in dB) */
	0,				/* G2 (gain of input to cascade 4th formant in dB) */
	0,				/* G3 (gain of input to cascade 3rd formant in dB) */
	0,				/* G4 (gain of input to cascade 2nd formant in dB) */
	0,				/* LO (Loudness, gain input to cascade 1st formant in dB) */
	0,				/* FT (f0-dependent spectral tilt in % of max) */
	0,				/* BF (baseline f0 fall in Hz) */
	0,				/* LX (lax folds adjacent to voiceless sound -> breathiness) */
	0,				/* QU (quickness of larynx gestures in % of max quickness) */
	0,				/* HR (hat-pattern fundamental frequency rise in Hz) */
	0,				/* SR (height of max stress-rise impulse of f0 in Hz) */
	0,				/* AGO */
	0,				/* agvo */
	0,				/* aguo */
	0,				/* unvow */
	0,				/* chink area */
	0,				/* open quotient*/
#if PC_SAMPLE_RATE == 22050
	-9,				/* Output gain multiplier  */
#else
	-3,				/* Output gain multiplier  */
#endif
}; /* DENNIS */

