﻿#==========================================================
# DO NOT EDIT THIS FILE.
# If you want to configure how your package is uploaded, modify the Config.ps1 file.
# To run this script from inside Visual Studio, right-click on the "RunMeToUploadNuGetPackage.cmd" file and choose "Run".
#==========================================================

# Turn on Strict Mode to help catch syntax-related errors.
# 	This must come after a script's/function's param section.
# 	Forces a function to be the first non-comment code to appear in a PowerShell Module.
Set-StrictMode -Version Latest

# PowerShell v2.0 compatible version of [string]::IsNullOrWhitespace.
function Test-StringIsNullOrWhitespace([string]$string)
{
    if ($string -ne $null) { $string = $string.Trim() }
    return [string]::IsNullOrEmpty($string)
}

# Get the directory that this script is in.
$THIS_SCRIPTS_DIRECTORY_PATH = Split-Path $script:MyInvocation.MyCommand.Path

# Get the path to the Config file and dot source it into this script.
# The variables below should be defined in the Config file, but if they aren't we initialize them with default values.
$CONFIG_FILE_PATH = Join-Path -Path (Split-Path -Path $THIS_SCRIPTS_DIRECTORY_PATH -Parent) -ChildPath 'Config.ps1'
if (Test-Path -Path $CONFIG_FILE_PATH) { . $CONFIG_FILE_PATH } 
else { Write-Warning "Could not find Config file at '$CONFIG_FILE_PATH'. Default values will be used instead." }

# The NuGet gallery to upload to. If not provided, the DefaultPushSource in your NuGet.config file is used (typically nuget.org).
if (!(Test-Path Variable:Private:sourceToUploadTo) -or (Test-StringIsNullOrWhitespace $sourceToUploadTo)) { $sourceToUploadTo = ""; Write-Output "Using default Source To Upload To value."  }
else { Write-Output "Using user-specified Source To Update To value '$sourceToUploadTo'." }

# The API Key to use to upload the package to the gallery. If not provided and a system-level one does not exist for the specified Source, you will be prompted for it.
if (!(Test-Path Variable:Private:apiKey) -or (Test-StringIsNullOrWhitespace $apiKey)) { $apiKey = ""; Write-Output "Using default API Key value."  }
else { Write-Output "Using user-specified API Key value [value not shown here for security purposes]." }

# Specify any NuGet Push options to pass to nuget.exe.
# Do not specify the "-Source" or "-ApiKey" here; use the variables above.
if (!(Test-Path Variable:Private:pushOptions) -or (Test-StringIsNullOrWhitespace $pushOptions)) { $pushOptions = ""; Write-Output "Using default Push Options value."  }
else { Write-Output "Using user-specified Push Options value '$pushOptions'." }

# Add the Source and ApiKey to the Push Options if there were provided.
if (!(Test-StringIsNullOrWhitespace $sourceToUploadTo)) { $pushOptions += " -Source ""$sourceToUploadTo"" " }
if (!(Test-StringIsNullOrWhitespace $apiKey)) { $pushOptions += " -ApiKey ""$apiKey"" " }

# Upload the new NuGet package.
& "$THIS_SCRIPTS_DIRECTORY_PATH\New-NuGetPackage.ps1" -PushOptions "$pushOptions" -Verbose