/*
 * Copyright 2022 Albert Tregnaghi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *		http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 */
package de.jcup.asciidoctoreditor;

import static org.junit.Assert.*;

import org.junit.Before;
import org.junit.Test;

public class SystemAccessTest {

    private SystemAccess accessToTest;

    @Before
    public void before() {
        accessToTest = new SystemAccess();
    }
    
    @Test
    public void user_home_key_returns_system_property_value_use_home() {
        /* prepare */
        String userHomeDirectlyAsProperty = System.getProperty("user.home");
        assertNotNull(userHomeDirectlyAsProperty);
        
        /* execute */
        String result = accessToTest.getProperty("user.home");
        
        /* test */
        assertEquals(userHomeDirectlyAsProperty,result);
    }

}
