/*
 * Copyright 2017 Albert Tregnaghi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *		http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 */
package de.jcup.asciidoctoreditor.script;

public class AsciiDoctorMarker implements ValidationResult {

    private int end;
    private int start;
    private String message;

    public AsciiDoctorMarker(int start, int end, String message) {
        this.start = start;
        this.end = end;
        this.message = message;
    }

    @Override
    public int getStart() {
        return start;
    }

    @Override
    public String getMessage() {
        return message;
    }

    @Override
    public int getEnd() {
        return end;
    }

    @Override
    public String toString() {
        return "AsciiDoctorMarker [message=" + message + ", end=" + end + ", start=" + start + "]";
    }

    @Override
    public Type getType() {
        return Type.ERROR;
    }
}
