/*
 * Decompiled with CFR 0.152.
 */
package de.jcup.eclipse.commons.workspacemodel;

import de.jcup.eclipse.commons.ui.EclipseUtil;
import de.jcup.eclipse.commons.workspacemodel.ModelBuilder;
import de.jcup.eclipse.commons.workspacemodel.ModelBuilderSupportProvider;
import de.jcup.eclipse.commons.workspacemodel.ModelUpdateAction;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class ModelBuilderSupport<M>
implements IResourceChangeListener {
    private ModelBuilderSupportProvider<M> provider;
    private M model;
    private ModelBuilder<M> builder;
    private ReentrantLock oneTimeBuildOnlyLock = new ReentrantLock();

    public ModelBuilderSupport(ModelBuilderSupportProvider<M> provider) {
        if (provider == null) {
            throw new IllegalArgumentException("provider may not be null");
        }
        this.provider = provider;
        this.builder = provider.createBuilder();
        if (this.builder == null) {
            throw new IllegalStateException("Provider returned builder being null!");
        }
        this.model = this.builder.create();
        if (this.model == null) {
            throw new IllegalStateException("Builder did create no model but returned null!");
        }
    }

    public M getModel() {
        return this.model;
    }

    public void install() {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        if (workspace == null) {
            return;
        }
        this.noResourceChangedScan(true);
        workspace.addResourceChangeListener((IResourceChangeListener)this);
    }

    public void fullRebuild() {
        this.noResourceChangedScan(false);
    }

    private boolean isBuildEnabled() {
        return this.provider.isModelBuilderSupportEnabled();
    }

    private void noResourceChangedScan(boolean ignoreFilesWithExistingMarkers) {
        if (!this.isBuildEnabled()) {
            return;
        }
        final ProjectModelBuilderContext initialContext = new ProjectModelBuilderContext();
        final IWorkspace workspace = ResourcesPlugin.getWorkspace();
        if (workspace == null) {
            return;
        }
        Job job = new Job("Initialization of " + this.provider.getModelName()){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    int worked = 0;
                    monitor.beginTask("Fetch and build existing resources", 2);
                    ModelBuilderSupport.this.doNoResourceChangedScan(initialContext, (IContainer)workspace.getRoot());
                    monitor.worked(worked++);
                    ModelBuilderSupport.this.triggerModelBuildIfNecessary(initialContext);
                    monitor.worked(worked++);
                }
                catch (CoreException e) {
                    return new Status(4, ModelBuilderSupport.this.provider.getPluginContextProvider().getPluginID(), "Was not able to fetch and build existing resources for " + ModelBuilderSupport.this.provider.getModelName(), (Throwable)e);
                }
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    void doNoResourceChangedScan(ProjectModelBuilderContext context, IContainer container) throws CoreException {
        IResource[] members;
        if (!container.isAccessible()) {
            return;
        }
        IResource[] iResourceArray = members = container.members();
        int n = members.length;
        int n2 = 0;
        while (n2 < n) {
            IFile file;
            IResource member = iResourceArray[n2];
            if (member instanceof IContainer) {
                this.doNoResourceChangedScan(context, (IContainer)member);
            } else if (member instanceof IFile && this.provider.isFileHandled(file = (IFile)member)) {
                if (!this.provider.isModelBuilderSupportEnabled()) {
                    context.resourcesToClean.add((IResource)file);
                } else {
                    this.visitResource(context, file);
                }
            }
            ++n2;
        }
    }

    public void uninstall() {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        if (workspace == null) {
            return;
        }
        workspace.removeResourceChangeListener((IResourceChangeListener)this);
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if (!this.isBuildEnabled()) {
            return;
        }
        int type = event.getType();
        if (type != 1) {
            return;
        }
        ProjectModelBuilderContext context = new ProjectModelBuilderContext();
        IResource resource = event.getResource();
        this.handleResource(context, resource);
        this.handleDelta(context, event.getDelta());
        this.triggerModelBuildIfNecessary(context);
    }

    private void triggerModelBuildIfNecessary(ProjectModelBuilderContext context) {
        try {
            this.rebuildModel(context);
        }
        catch (CoreException e) {
            this.logError("Was not able to rebuild model", e);
        }
    }

    protected void visitLines(ProjectModelBuilderContext context, String[] lines, IFile file) throws CoreException {
        context.resourcesToClean.add((IResource)file);
        int lineNumber = 0;
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (line != null && line.length() != 0 && this.provider.isLineCheckforModelNessary(line, ++lineNumber, lines)) {
                this.addModelEntry(context, line, lineNumber, file);
            }
            ++n2;
        }
    }

    private void addModelEntry(ProjectModelBuilderContext context, String line, int lineNumber, IFile file) {
        CreateModelEntryAction action = new CreateModelEntryAction((IResource)file);
        action.lineNumber = lineNumber;
        action.line = line;
        context.actions.add(action);
    }

    private void rebuildModel(ProjectModelBuilderContext context) throws CoreException {
        if (!this.isBuildEnabled()) {
            return;
        }
        final List<CreateModelEntryAction> actions = context.actions;
        final List<IResource> resourcesToClean = context.resourcesToClean;
        int totalTasks = actions.size() + resourcesToClean.size();
        if (totalTasks == 0) {
            return;
        }
        Job job = new Job("Rebuild model of type" + this.provider.getModelName()){

            protected IStatus run(IProgressMonitor monitor) {
                ModelBuilderSupport.this.oneTimeBuildOnlyLock.lock();
                try {
                    int totalTasks = actions.size() + resourcesToClean.size();
                    int worked = 0;
                    monitor.beginTask("Updating model", totalTasks);
                    for (IResource resourceToClean : resourcesToClean) {
                        try {
                            ModelBuilderSupport.this.removeFromModel(resourceToClean);
                        }
                        catch (CoreException e) {
                            Status status = new Status(4, ModelBuilderSupport.this.provider.getPluginContextProvider().getPluginID(), "Failed to remove from model:" + resourceToClean, (Throwable)e);
                            ModelBuilderSupport.this.oneTimeBuildOnlyLock.unlock();
                            return status;
                        }
                        monitor.worked(worked++);
                    }
                    for (CreateModelEntryAction action : actions) {
                        try {
                            ModelBuilderSupport.this.addToModel(action);
                        }
                        catch (CoreException e) {
                            Status status = new Status(4, ModelBuilderSupport.this.provider.getPluginContextProvider().getPluginID(), "Failed to add to model:" + action.getResource(), (Throwable)e);
                            ModelBuilderSupport.this.oneTimeBuildOnlyLock.unlock();
                            return status;
                        }
                        monitor.worked(worked++);
                    }
                }
                finally {
                    ModelBuilderSupport.this.oneTimeBuildOnlyLock.unlock();
                }
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    protected void addToModel(CreateModelEntryAction action) throws CoreException {
        this.builder.update(this.model, action);
    }

    protected void removeFromModel(IResource resourceToClean) throws CoreException {
        this.builder.update(this.model, new RemoveModelEntryAction(resourceToClean));
    }

    protected void visitResource(ProjectModelBuilderContext context, IFile file) throws CoreException {
        if (file == null) {
            return;
        }
        if (!file.exists()) {
            context.resourcesToClean.add((IResource)file);
            return;
        }
        if (file.isDerived()) {
            return;
        }
        if (!file.isSynchronized(0)) {
            return;
        }
        int amountOfLinesToCheck = this.provider.getAmountOfLinesToCheck();
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (BufferedReader br = new BufferedReader(new InputStreamReader(file.getContents(), "UTF-8"));){
                String line = null;
                int linesRead = 0;
                ArrayList<String> list = new ArrayList<String>();
                while ((line = br.readLine()) != null) {
                    list.add(line);
                    if (++linesRead == amountOfLinesToCheck) break;
                }
                String[] lines = list.toArray(new String[list.size()]);
                this.visitLines(context, lines, file);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | RuntimeException e) {
            throw new CoreException((IStatus)new Status(4, this.provider.getPluginContextProvider().getPluginID(), "Not able to visit resource", (Throwable)e));
        }
    }

    private void handleResource(ProjectModelBuilderContext context, IResource resource) {
        if (!(resource instanceof IFile)) {
            return;
        }
        IFile file = (IFile)resource;
        if (!this.provider.isFileHandled(file)) {
            return;
        }
        try {
            this.visitResource(context, file);
        }
        catch (CoreException e) {
            this.logError("Cannot visit resource:" + file, e);
        }
    }

    private void logError(String string, Throwable t) {
        EclipseUtil.logError(string, t, this.provider.getPluginContextProvider());
    }

    private void handleDelta(ProjectModelBuilderContext context, IResourceDelta delta) {
        if (delta == null) {
            return;
        }
        int flags = delta.getFlags();
        if (flags == 131072) {
            return;
        }
        IResource resource = delta.getResource();
        if (resource instanceof IFile) {
            this.handleResource(context, resource);
            return;
        }
        IResourceDelta[] iResourceDeltaArray = delta.getAffectedChildren();
        int n = iResourceDeltaArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResourceDelta childDelta = iResourceDeltaArray[n2];
            this.handleDelta(context, childDelta);
            ++n2;
        }
    }

    private abstract class AbstractModelUpdateData
    implements ModelUpdateAction {
        IResource resource;
        String line;
        String message;
        int lineNumber;

        @Override
        public String getLine() {
            return this.line;
        }

        @Override
        public int getLineNumber() {
            return this.lineNumber;
        }

        @Override
        public String getMessage() {
            return this.message;
        }

        AbstractModelUpdateData(IResource resource) {
            this.resource = resource;
        }

        @Override
        public IResource getResource() {
            return this.resource;
        }
    }

    private class CreateModelEntryAction
    extends AbstractModelUpdateData {
        CreateModelEntryAction(IResource resource) {
            super(resource);
        }

        @Override
        public ModelUpdateAction.ActionType getType() {
            return ModelUpdateAction.ActionType.ADD;
        }
    }

    private class ProjectModelBuilderContext {
        List<IResource> resourcesToClean = new ArrayList<IResource>();
        List<CreateModelEntryAction> actions = new ArrayList<CreateModelEntryAction>();

        private ProjectModelBuilderContext() {
        }
    }

    private class RemoveModelEntryAction
    extends AbstractModelUpdateData {
        RemoveModelEntryAction(IResource resource) {
            super(resource);
        }

        @Override
        public ModelUpdateAction.ActionType getType() {
            return ModelUpdateAction.ActionType.DELETE;
        }
    }
}

