/*
 * Decompiled with CFR 0.152.
 */
package de.jcup.eclipse.commons.ui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Control;

public class UIMasterSlaveSupport {
    private static final int INDENT = 20;
    private ArrayList<SlaveSelectionListener> masterSlaveListeners = new ArrayList();

    private static void indent(Control control) {
        ((GridData)control.getLayoutData()).horizontalIndent += 20;
    }

    public void createDependency(Button master, Control slave) {
        Assert.isNotNull((Object)slave);
        UIMasterSlaveSupport.indent(slave);
        MasterButtonSlaveSelectionListener listener = new MasterButtonSlaveSelectionListener(master, slave);
        master.addSelectionListener((SelectionListener)listener);
        this.masterSlaveListeners.add(listener);
    }

    public void createDependency(Combo master, Control slave, List<String> enabledVariants) {
        Assert.isNotNull((Object)slave);
        UIMasterSlaveSupport.indent(slave);
        MasterComboSlaveSelectionListener listener = new MasterComboSlaveSelectionListener(master, slave, enabledVariants);
        master.addSelectionListener((SelectionListener)listener);
        this.masterSlaveListeners.add(listener);
    }

    public void updateSlaveComponents() {
        for (SlaveSelectionListener listener : this.masterSlaveListeners) {
            listener.updateSlaveComponent();
        }
    }

    private class MasterButtonSlaveSelectionListener
    extends SlaveSelectionListener {
        private Button master;
        private Control slave;

        public MasterButtonSlaveSelectionListener(Button master, Control slave) {
            this.master = master;
            this.slave = slave;
        }

        @Override
        protected void updateSlaveComponent() {
            boolean state = this.master.getSelection();
            this.slave.setEnabled(state);
        }
    }

    private class MasterComboSlaveSelectionListener
    extends SlaveSelectionListener {
        private Combo master;
        private Control slave;
        private List<String> enabledVariants;

        public MasterComboSlaveSelectionListener(Combo master, Control slave, List<String> enabledVariants) {
            this.master = master;
            this.slave = slave;
            this.enabledVariants = enabledVariants == null ? Collections.emptyList() : new ArrayList<String>(enabledVariants);
        }

        @Override
        protected void updateSlaveComponent() {
            String[] items;
            int index = this.master.getSelectionIndex();
            boolean enabled = false;
            if (index != -1 && (items = this.master.getItems()) != null && items.length > index) {
                String selected = items[index];
                enabled = this.enabledVariants.contains(selected);
            }
            this.slave.setEnabled(enabled);
        }
    }

    private abstract class SlaveSelectionListener
    implements SelectionListener {
        private SlaveSelectionListener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            this.updateSlaveComponent();
        }

        protected abstract void updateSlaveComponent();
    }
}

