/*
 * Decompiled with CFR 0.152.
 */
package de.jcup.eclipse.commons.ui;

import de.jcup.eclipse.commons.ui.BrowserInformationListener;
import de.jcup.eclipse.commons.ui.DefaultPlainTextToHTMLProvider;
import de.jcup.eclipse.commons.ui.PlainTextToHTMLProvider;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.text.AbstractInformationControl;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.OpenWindowListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Slider;

public class ReducedBrowserInformationControl
extends AbstractInformationControl {
    private static boolean browserAvailabilityChecked;
    private static boolean swtBrowserCanBeUsed;
    private static Point cachedScrollBarSize;
    private String currentHTML;
    private Browser browser;
    private boolean initialized;
    private BrowserInformationListener listener;
    private PlainTextToHTMLProvider plainTextToHTMLProvider;

    public void setListener(BrowserInformationListener listener) {
        this.listener = listener;
    }

    public ReducedBrowserInformationControl(Shell parentShell) {
        this(parentShell, null);
    }

    public ReducedBrowserInformationControl(Shell parentShell, PlainTextToHTMLProvider fallbackHTMLProvider) {
        super(parentShell, new ToolBarManager());
        if (fallbackHTMLProvider == null) {
            fallbackHTMLProvider = new DefaultPlainTextToHTMLProvider(null);
        }
        this.plainTextToHTMLProvider = fallbackHTMLProvider;
        this.create();
    }

    public PlainTextToHTMLProvider getPlainTextToHTMLProvider() {
        return this.plainTextToHTMLProvider;
    }

    public void setBackgroundColor(Color background) {
        super.setBackgroundColor(background);
        if (this.isBrowserNotDisposed()) {
            this.browser.setBackground(background);
        }
    }

    public void setForegroundColor(Color foreground) {
        super.setForegroundColor(foreground);
        if (this.isBrowserNotDisposed()) {
            this.browser.setForeground(foreground);
        }
    }

    public void setInformation(String information) {
        if (this.isBrowserNotDisposed()) {
            boolean hasHtmlElementInside;
            if (!this.initialized && this.listener != null) {
                this.browser.addLocationListener((LocationListener)this.listener);
                this.browser.addOpenWindowListener((OpenWindowListener)this.listener);
            }
            this.currentHTML = !(hasHtmlElementInside = information.startsWith("<html")) ? this.plainTextToHTMLProvider.getHTML(information) : information;
            this.browser.setText(this.currentHTML);
        }
    }

    public void redraw() {
        if (this.isBrowserNotDisposed()) {
            this.browser.redraw();
        }
    }

    public static boolean isAvailableFor(Composite parent) {
        if (!browserAvailabilityChecked) {
            try {
                try {
                    Browser browser = new Browser(parent, 0);
                    browser.dispose();
                    swtBrowserCanBeUsed = true;
                    Slider sliderV = new Slider(parent, 512);
                    Slider sliderH = new Slider(parent, 256);
                    int width = sliderV.computeSize((int)-1, (int)-1).x;
                    int height = sliderH.computeSize((int)-1, (int)-1).y;
                    cachedScrollBarSize = new Point(width, height);
                    sliderV.dispose();
                    sliderH.dispose();
                }
                catch (SWTError er) {
                    swtBrowserCanBeUsed = false;
                    browserAvailabilityChecked = true;
                }
            }
            finally {
                browserAvailabilityChecked = true;
            }
        }
        return swtBrowserCanBeUsed;
    }

    public boolean hasContents() {
        return this.currentHTML != null && this.currentHTML.length() > 0;
    }

    int getToolbarWidth() {
        this.assertAvailable();
        return ReducedBrowserInformationControl.cachedScrollBarSize.x;
    }

    int getToolbarHeight() {
        this.assertAvailable();
        return ReducedBrowserInformationControl.cachedScrollBarSize.x;
    }

    protected void createContent(Composite parent) {
        this.assertAvailable();
        this.browser = new Browser(parent, 4);
        this.browser.setJavascriptEnabled(false);
        this.browser.setMenu(new Menu((Decorations)this.getShell(), 0));
    }

    public void dispose() {
        super.dispose();
        if (this.isBrowserNotDisposed()) {
            this.browser.dispose();
        }
    }

    private boolean isBrowserNotDisposed() {
        return this.browser != null && !this.browser.isDisposed();
    }

    private void assertAvailable() {
        if (!browserAvailabilityChecked) {
            throw new IllegalStateException("Availability not checked before!");
        }
        if (!swtBrowserCanBeUsed) {
            throw new IllegalStateException("Availibility was checked but SWT browser cannot be used!");
        }
    }

    public IInformationControlCreator getInformationPresenterControlCreator() {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                ReducedBrowserInformationControl newControl = new ReducedBrowserInformationControl(parent);
                return newControl;
            }
        };
    }
}

