/*
 * Decompiled with CFR 0.152.
 */
package de.jcup.eclipse.commons.ui;

import de.jcup.eclipse.commons.PluginContextProvider;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;

public class EclipseUtil {
    private static Font monoFont;

    public static void openInEditor(File file) throws PartInitException {
        IFileStore fileStore = EFS.getLocalFileSystem().getStore((IPath)new Path(file.getAbsolutePath()));
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IDE.openEditorOnFileStore((IWorkbenchPage)page, (IFileStore)fileStore);
    }

    public static void openInEditor(IFile file) throws PartInitException {
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IDE.openEditor((IWorkbenchPage)page, (IFile)file);
    }

    public static ImageDescriptor createImageDescriptor(String path, String pluginId) {
        if (path == null) {
            return ImageDescriptor.getMissingImageDescriptor();
        }
        if (pluginId == null) {
            return ImageDescriptor.getMissingImageDescriptor();
        }
        Bundle bundle = Platform.getBundle((String)pluginId);
        if (bundle == null) {
            return ImageDescriptor.getMissingImageDescriptor();
        }
        URL url = FileLocator.find((Bundle)bundle, (IPath)new Path(path), null);
        ImageDescriptor imageDesc = ImageDescriptor.createFromURL((URL)url);
        return imageDesc;
    }

    public static IEditorPart getActiveEditor() {
        IWorkbenchPage page = EclipseUtil.getActivePage();
        IEditorPart activeEditor = page.getActiveEditor();
        return activeEditor;
    }

    public static IWorkbenchPage getActivePage() {
        if (!PlatformUI.isWorkbenchRunning()) {
            return null;
        }
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        return window.getActivePage();
    }

    public static Shell getActiveWorkbenchShell() {
        IWorkbench workbench = EclipseUtil.getWorkbench();
        if (workbench == null) {
            return null;
        }
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        Shell shell = window.getShell();
        return shell;
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        IWorkbench workbench = EclipseUtil.getWorkbench();
        if (workbench == null) {
            return null;
        }
        IWorkbenchWindow workbenchWindow = workbench.getActiveWorkbenchWindow();
        if (workbenchWindow != null) {
            return workbenchWindow;
        }
        WorkbenchWindowRunnable wwr = new WorkbenchWindowRunnable();
        EclipseUtil.getSafeDisplay().syncExec((Runnable)wwr);
        return wwr.workbenchWindowFromUI;
    }

    public static IProject[] getAllProjects() {
        IProject[] projects = EclipseUtil.getWorkspace().getRoot().getProjects();
        return projects;
    }

    public static Image getImage(String path, PluginContextProvider provider) {
        ImageRegistry imageRegistry = EclipseUtil.getImageRegistry(provider);
        if (imageRegistry == null) {
            return null;
        }
        Image image = imageRegistry.get(path);
        if (image == null) {
            ImageDescriptor imageDesc = EclipseUtil.createImageDescriptor(path, provider.getPluginID());
            image = imageDesc.createImage();
            if (image == null) {
                image = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_ERROR_TSK");
            }
            imageRegistry.put(path, image);
        }
        return image;
    }

    public static Display getSafeDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public static void safeAsyncExec(Runnable runnable) {
        EclipseUtil.getSafeDisplay().asyncExec(runnable);
    }

    public static void safeSyncExec(Runnable runnable) {
        EclipseUtil.getSafeDisplay().syncExec(runnable);
    }

    public static void throwCoreException(String message, PluginContextProvider provider) throws CoreException {
        throw new CoreException((IStatus)new Status(4, provider.getPluginID(), message));
    }

    public static void throwCoreException(String message, Exception e, PluginContextProvider provider) throws CoreException {
        throw new CoreException((IStatus)new Status(4, provider.getPluginID(), message, (Throwable)e));
    }

    public static String resolveMessageIfNotSet(String message, Throwable cause) {
        if (message == null) {
            message = cause == null ? "Unknown" : cause.getMessage();
        }
        return message;
    }

    public static final Font getMonospaceFont() {
        if (monoFont == null) {
            monoFont = EclipseUtil.createMonospaceFont();
        }
        return monoFont;
    }

    private static Font createMonospaceFont() {
        int size = 14;
        int style = 0;
        ArrayList<FontData> fontDataList = new ArrayList<FontData>();
        fontDataList.add(new FontData("Consolas", size, style));
        fontDataList.add(new FontData("Monospace", size, style));
        fontDataList.add(new FontData("adobe-courier", size, style));
        fontDataList.add(new FontData("Courier New", size, style));
        Display device = EclipseUtil.getSafeDisplay();
        FontData[] data = fontDataList.toArray(new FontData[fontDataList.size()]);
        return new Font((Device)device, data);
    }

    private static ImageRegistry getImageRegistry(PluginContextProvider provider) {
        if (provider == null) {
            return null;
        }
        AbstractUIPlugin mainActivator = provider.getActivator();
        if (mainActivator == null) {
            return null;
        }
        return mainActivator.getImageRegistry();
    }

    private static IWorkbench getWorkbench() {
        if (!PlatformUI.isWorkbenchRunning()) {
            return null;
        }
        IWorkbench workbench = PlatformUI.getWorkbench();
        return workbench;
    }

    public static void logInfo(String info, PluginContextProvider provider) {
        if (provider == null) {
            return;
        }
        EclipseUtil.getLog(provider).log((IStatus)new Status(1, provider.getPluginID(), info));
    }

    public static void logWarn(String warning, PluginContextProvider provider) {
        if (provider == null) {
            return;
        }
        EclipseUtil.getLog(provider).log((IStatus)new Status(4, provider.getPluginID(), warning));
    }

    public static void logError(String error, Throwable t, PluginContextProvider provider) {
        if (provider == null) {
            return;
        }
        EclipseUtil.getLog(provider).log((IStatus)new Status(4, provider.getPluginID(), error, t));
    }

    private static ILog getLog(PluginContextProvider provider) {
        ILog log = provider.getActivator().getLog();
        return log;
    }

    public static void openInExternalBrowser(URL url, PluginContextProvider provider) {
        if (url == null) {
            return;
        }
        try {
            IWorkbenchBrowserSupport browserSupport = EclipseUtil.getWorkbench().getBrowserSupport();
            IWebBrowser externalBrowser = browserSupport.getExternalBrowser();
            externalBrowser.openURL(url);
        }
        catch (Exception ex) {
            EclipseUtil.logError("Cannot open external browser url", ex, provider);
        }
    }

    private static class WorkbenchWindowRunnable
    implements Runnable {
        IWorkbenchWindow workbenchWindowFromUI;

        private WorkbenchWindowRunnable() {
        }

        @Override
        public void run() {
            IWorkbench workbench = EclipseUtil.getWorkbench();
            if (workbench == null) {
                return;
            }
            this.workbenchWindowFromUI = workbench.getActiveWorkbenchWindow();
        }
    }
}

