/*
 * Decompiled with CFR 0.152.
 */
package de.jcup.eclipse.commons.ui;

import de.jcup.eclipse.commons.ui.EclipseUtil;
import org.eclipse.jface.resource.ColorDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;

public class ColorUtil {
    public static String convertJFaceColorToWeb(String jfaceColorName) {
        ColorDescriptor descriptor = JFaceResources.getColorRegistry().getColorDescriptor(jfaceColorName);
        if (descriptor == null) {
            return null;
        }
        return ColorUtil.convertToHexColor(descriptor);
    }

    public static String convertToHexColor(Color color) {
        if (color == null) {
            return null;
        }
        return ColorUtil.convertToHexColor(color.getRGB());
    }

    public static String convertToHexColor(RGB rgb) {
        if (rgb == null) {
            return null;
        }
        String hex = String.format("#%02x%02x%02x", rgb.red, rgb.green, rgb.blue);
        return hex;
    }

    public static String convertToHexColor(ColorDescriptor descriptor) {
        return ColorUtil.convertToHexColor(ColorUtil.resolveRGB(descriptor));
    }

    public static RGB resolveRGB(ColorDescriptor descriptor) {
        if (descriptor == null) {
            return null;
        }
        Color color = descriptor.createColor((Device)EclipseUtil.getSafeDisplay());
        RGB rgb = color.getRGB();
        descriptor.destroyColor(color);
        return rgb;
    }
}

