/*
 * Decompiled with CFR 0.152.
 */
package de.jcup.eclipse.commons.templates;

import de.jcup.eclipse.commons.PluginContextProvider;
import de.jcup.eclipse.commons.templates.SimpleTemplateCompletionProcessor;
import de.jcup.eclipse.commons.templates.TemplateSupportConfig;
import de.jcup.eclipse.commons.templates.TemplateSupportProvider;
import de.jcup.eclipse.commons.ui.EclipseUtil;
import java.io.IOException;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.templates.ContextTypeRegistry;
import org.eclipse.jface.text.templates.TemplateCompletionProcessor;
import org.eclipse.jface.text.templates.persistence.TemplateStore;
import org.eclipse.ui.editors.text.templates.ContributionContextTypeRegistry;
import org.eclipse.ui.editors.text.templates.ContributionTemplateStore;
import org.osgi.service.prefs.BackingStoreException;

public class TemplateSupport {
    private PluginContextProvider provider;
    private ContributionTemplateStore fStore;
    private ContributionContextTypeRegistry fRegistry;
    private TemplateSupportConfig config;
    private TemplateCompletionProcessor processor;

    TemplateSupport(TemplateSupportProvider supportProvider) {
        if (supportProvider == null) {
            throw new IllegalStateException("supportProvider may never be null!");
        }
        this.provider = supportProvider.getPluginContextProvider();
        if (this.provider == null) {
            throw new IllegalStateException("provider may never be null!");
        }
        this.config = supportProvider.getConfig();
        if (this.config == null) {
            throw new IllegalStateException("config may never be null!");
        }
        this.processor = new SimpleTemplateCompletionProcessor(this);
    }

    public TemplateCompletionProcessor getProcessor() {
        return this.processor;
    }

    public TemplateSupportConfig getConfig() {
        return this.config;
    }

    public TemplateStore getTemplateStore() {
        if (this.fStore == null) {
            this.fStore = new ContributionTemplateStore((ContextTypeRegistry)this.getContextTypeRegistry(), this.provider.getActivator().getPreferenceStore(), this.config.getTemplatesKey());
            try {
                this.fStore.load();
            }
            catch (IOException e) {
                EclipseUtil.logError("Was not able to load template store", e, this.provider);
            }
        }
        return this.fStore;
    }

    public ContributionContextTypeRegistry getContextTypeRegistry() {
        if (this.fRegistry == null) {
            this.fRegistry = new ContributionContextTypeRegistry();
            for (String id : this.config.getContextTypes()) {
                this.fRegistry.addContextType(id);
            }
        }
        return this.fRegistry;
    }

    public void savePluginPreferences() {
        try {
            InstanceScope.INSTANCE.getNode(this.provider.getPluginID()).flush();
        }
        catch (BackingStoreException e) {
            EclipseUtil.logError("Was not able to save plugin preferences", e, this.provider);
        }
    }

    public PluginContextProvider getProvider() {
        return this.provider;
    }

    public void install(ContentAssistant assistant, IInformationControlCreator informationControlCreator) {
        this.installProcessor(assistant);
        this.installUI(assistant, informationControlCreator);
    }

    private void installProcessor(ContentAssistant assistant) {
        for (String id : this.config.getContentTypes()) {
            assistant.setContentAssistProcessor((IContentAssistProcessor)this.processor, id);
        }
    }

    private void installUI(ContentAssistant assistant, IInformationControlCreator informationControlCreator) {
        assistant.setContextInformationPopupOrientation(20);
        assistant.setInformationControlCreator(informationControlCreator);
    }
}

