/*
 * Decompiled with CFR 0.152.
 */
package de.jcup.eclipse.commons.templates;

import de.jcup.eclipse.commons.PluginContextProvider;
import de.jcup.eclipse.commons.codeassist.DefaultRelevanceCalculator;
import de.jcup.eclipse.commons.templates.TemplateStrategy;
import de.jcup.eclipse.commons.templates.TemplateSupport;
import de.jcup.eclipse.commons.templates.TemplateSupportConfig;
import de.jcup.eclipse.commons.ui.EclipseUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateCompletionProcessor;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.TemplateException;
import org.eclipse.jface.text.templates.TemplateProposal;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;

public class SimpleTemplateCompletionProcessor
extends TemplateCompletionProcessor {
    private static final Template[] NO_TEMPLATES = new Template[0];
    private TemplateSupport support;
    private TemplateSupportConfig config;
    private PluginContextProvider provider;
    private TemplateStrategy strategy;
    private static final Comparator<ICompletionProposal> proposalComparator = new ProposalComparator();

    SimpleTemplateCompletionProcessor(TemplateSupport support) {
        if (support == null) {
            throw new IllegalArgumentException("support may not be null!");
        }
        this.support = support;
        this.config = support.getConfig();
        this.provider = support.getProvider();
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        String prefix;
        Region region;
        TemplateContext context;
        ITextSelection selection = (ITextSelection)viewer.getSelectionProvider().getSelection();
        if (selection == null) {
            return new ICompletionProposal[0];
        }
        if (selection.getOffset() == offset) {
            offset = selection.getOffset() + selection.getLength();
        }
        if ((context = this.createContext(viewer, (IRegion)(region = new Region(offset - (prefix = this.extractPrefix(viewer, offset)).length(), prefix.length())))) == null) {
            return new ICompletionProposal[0];
        }
        context.setVariable("selection", selection.getText());
        Template[] templates = this.getTemplates(context.getContextType().getId());
        ArrayList<ICompletionProposal> matches = new ArrayList<ICompletionProposal>();
        Template[] templateArray = templates;
        int n = templates.length;
        int n2 = 0;
        while (n2 < n) {
            block7: {
                int relevance;
                Template template = templateArray[n2];
                try {
                    context.getContextType().validate(template.getPattern());
                }
                catch (TemplateException e) {
                    break block7;
                }
                if (template.matches(prefix, context.getContextType().getId()) && (relevance = this.getRelevance(template, prefix)) > 0) {
                    matches.add(this.createProposal(template, context, (IRegion)region, relevance));
                }
            }
            ++n2;
        }
        Collections.sort(matches, proposalComparator);
        return matches.toArray(new ICompletionProposal[matches.size()]);
    }

    protected String extractPrefix(ITextViewer viewer, int offset) {
        TemplateStrategy strategy = this.getStrategy();
        String prefix = strategy.extractPrefix(viewer, offset);
        if (prefix != null) {
            return prefix;
        }
        return super.extractPrefix(viewer, offset);
    }

    protected int getRelevance(Template template, String prefix) {
        TemplateStrategy strategy = this.getStrategy();
        Integer relevance = strategy.getRelevance(template, prefix);
        if (relevance != null) {
            return relevance;
        }
        if (prefix == null || prefix.isEmpty()) {
            return 70;
        }
        String templateName = template.getName();
        if (templateName == null) {
            templateName = "";
        }
        DefaultRelevanceCalculator c = new DefaultRelevanceCalculator(prefix);
        return c.calculate(templateName);
    }

    protected Template[] getTemplates(String contextTypeId) {
        if (this.config.isCompletionDisabled()) {
            return NO_TEMPLATES;
        }
        return this.support.getTemplateStore().getTemplates(contextTypeId);
    }

    protected TemplateContextType getContextType(ITextViewer viewer, IRegion region) {
        if (this.config.isCompletionDisabled()) {
            return null;
        }
        TemplateStrategy strategy = this.getStrategy();
        IDocument document = viewer.getDocument();
        String id = strategy.getContextType(document, region);
        return this.support.getContextTypeRegistry().getContextType(id);
    }

    private TemplateStrategy getStrategy() {
        if (this.strategy == null) {
            this.strategy = this.config.createStrategy();
            if (this.strategy == null) {
                throw new IllegalStateException(String.valueOf(this.config.getClass().getName()) + " does wrong implement createStrategy()! May never return null. Destroy method (uses default) or implement correctly");
            }
        }
        return this.strategy;
    }

    protected Image getImage(Template template) {
        ImageRegistry registry = this.provider.getActivator().getImageRegistry();
        String imagePath = this.config.getTemplateImagePath(template);
        if (imagePath == null) {
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FILE");
        }
        Image image = registry.get(imagePath);
        if (image == null) {
            ImageDescriptor desc = EclipseUtil.createImageDescriptor(imagePath, this.provider.getPluginID());
            registry.put(imagePath, desc);
            image = registry.get(imagePath);
        }
        return image;
    }

    private static final class ProposalComparator
    implements Comparator<ICompletionProposal> {
        private ProposalComparator() {
        }

        @Override
        public int compare(ICompletionProposal o1, ICompletionProposal o2) {
            int r1 = o1 instanceof TemplateProposal ? ((TemplateProposal)o1).getRelevance() : 0;
            int r2 = o2 instanceof TemplateProposal ? ((TemplateProposal)o2).getRelevance() : 0;
            return r2 - r1;
        }
    }
}

