/*
 * Decompiled with CFR 0.152.
 */
package de.jcup.eclipse.commons.tasktags;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ui.texteditor.MarkerUtilities;

public class TaskTagsSupport
implements IResourceChangeListener {
    private TaskTagSupportProvider provider;

    public TaskTagsSupport(TaskTagSupportProvider provider) {
        if (provider == null) {
            throw new IllegalArgumentException("provider may not be null");
        }
        if (provider.getTodoTaskMarkerId() == null) {
            throw new IllegalArgumentException("provider.getMarkerType() may not result in null");
        }
        if (provider.getTodoTaskMarkerId().isEmpty()) {
            throw new IllegalArgumentException("provider.getMarkerType() may not be empty!");
        }
        if (provider.getTaskTagDefinitions() == null) {
            throw new IllegalArgumentException("provider.getTodoTaskDefinitions() may not result in null");
        }
        this.provider = provider;
    }

    public void install() {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        if (workspace == null) {
            return;
        }
        workspace.addResourceChangeListener((IResourceChangeListener)this);
        this.noResourceChangedScan(true);
    }

    public void fullRebuild() {
        this.noResourceChangedScan(false);
    }

    private void noResourceChangedScan(boolean ignoreFilesWithExistingMarkers) {
        TaskTagContext initialContext = new TaskTagContext();
        initialContext.ignoreFilesWithExistingMarkers = ignoreFilesWithExistingMarkers;
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        if (workspace == null) {
            return;
        }
        try {
            this.doNoResourceChangedScan(initialContext, (IContainer)workspace.getRoot());
            this.triggerTodoTaskJobIfNecessary(initialContext);
        }
        catch (CoreException e) {
            this.provider.logError("was not able to process todos initial", e);
        }
    }

    void doNoResourceChangedScan(TaskTagContext context, IContainer container) throws CoreException {
        IResource[] members;
        if (!container.isAccessible()) {
            return;
        }
        IResource[] iResourceArray = members = container.members();
        int n = members.length;
        int n2 = 0;
        while (n2 < n) {
            IFile file;
            IResource member = iResourceArray[n2];
            if (member instanceof IContainer) {
                this.doNoResourceChangedScan(context, (IContainer)member);
            } else if (member instanceof IFile && this.provider.isFileHandled(file = (IFile)member)) {
                IMarker[] markers;
                if (!this.provider.isTodoTaskSupportEnabled()) {
                    context.resourcesToClean.add((IResource)file);
                } else if (!context.ignoreFilesWithExistingMarkers || (markers = file.findMarkers(this.provider.getTodoTaskMarkerId(), false, 0)) == null || markers.length <= 0) {
                    this.visitResource(context, file);
                }
            }
            ++n2;
        }
    }

    public void uninstall() {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        if (workspace == null) {
            return;
        }
        workspace.removeResourceChangeListener((IResourceChangeListener)this);
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if (!this.provider.isTodoTaskSupportEnabled()) {
            return;
        }
        int type = event.getType();
        if (type != 1) {
            return;
        }
        TaskTagContext context = new TaskTagContext();
        IResource resource = event.getResource();
        this.handleResource(context, resource);
        this.handleDelta(context, event.getDelta());
        this.triggerTodoTaskJobIfNecessary(context);
    }

    private void triggerTodoTaskJobIfNecessary(TaskTagContext context) {
        try {
            this.createTodoMarkers(context);
        }
        catch (CoreException e) {
            this.provider.logError("Was not able to create todo markers", e);
        }
    }

    protected void visitLines(TaskTagContext context, String[] lines, IFile file) throws CoreException {
        context.resourcesToClean.add((IResource)file);
        int lineNumber = 0;
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (line != null && line.length() != 0 && this.provider.isLineCheckforTodoTaskNessary(line, ++lineNumber, lines)) {
                for (TaskTagDefinition task : this.provider.getTaskTagDefinitions()) {
                    this.addCreateMarkerAction(context, task, line, lineNumber, (IResource)file);
                }
            }
            ++n2;
        }
    }

    protected void addCreateMarkerAction(TaskTagContext context, TaskTagDefinition definition, String line, int lineNumber, IResource editorResource) throws CoreException {
        if (context == null) {
            throw new IllegalArgumentException("context may not be null!");
        }
        if (definition == null) {
            return;
        }
        String taskIdentifier = definition.getIdentifier();
        if (taskIdentifier == null) {
            return;
        }
        int taskIdentifierLength = taskIdentifier.length();
        if (taskIdentifierLength == 0) {
            return;
        }
        int todoIndex = line.indexOf(taskIdentifier);
        if (todoIndex == -1) {
            return;
        }
        int end = todoIndex + taskIdentifierLength;
        String message = line.substring(end);
        if (message.length() == 0) {
            return;
        }
        if (Character.isLetterOrDigit(message.charAt(0))) {
            return;
        }
        CreateMarkerAction action = new CreateMarkerAction();
        action.priority = definition.getPriority().getMarkerPriority();
        action.resource = editorResource;
        action.message = String.valueOf(taskIdentifier) + " " + message;
        action.lineNumber = lineNumber;
        context.actions.add(action);
    }

    private void createTodoMarkers(TaskTagContext context) throws CoreException {
        final List<CreateMarkerAction> actions = context.actions;
        final List<IResource> resourcesToClean = context.resourcesToClean;
        int totalTasks = actions.size() + resourcesToClean.size();
        if (totalTasks == 0) {
            return;
        }
        Job job = new Job("Update todos of type" + this.provider.getTodoTaskMarkerId()){

            protected IStatus run(IProgressMonitor monitor) {
                int totalTasks = actions.size() + resourcesToClean.size();
                int worked = 0;
                monitor.beginTask("Updating todo tasks", totalTasks);
                for (IResource resourceToClean : resourcesToClean) {
                    TaskTagsSupport.this.removeMarkers(resourceToClean);
                    monitor.worked(worked++);
                }
                for (CreateMarkerAction action : actions) {
                    try {
                        TaskTagsSupport.this.createTaskMarker(action.resource, action.message, action.lineNumber, action.priority);
                    }
                    catch (CoreException e) {
                        return new Status(4, TaskTagsSupport.this.provider.getTodoTaskPluginId(), "Failed to create task markers", (Throwable)e);
                    }
                    monitor.worked(worked++);
                }
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    private void createTaskMarker(IResource resource, String message, int lineNumber, int priority) throws CoreException {
        if (lineNumber <= 0) {
            lineNumber = 1;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("priority", new Integer(priority));
        map.put("location", resource.getFullPath().toOSString());
        map.put("message", message);
        MarkerUtilities.setLineNumber(map, (int)lineNumber);
        MarkerUtilities.setMessage(map, (String)message);
        IMarker newMarker = resource.createMarker(this.provider.getTodoTaskMarkerId());
        newMarker.setAttributes(map);
    }

    private IMarker[] removeMarkers(IResource resource) {
        if (resource == null) {
            return new IMarker[0];
        }
        IMarker[] tasks = null;
        if (resource != null) {
            try {
                tasks = resource.findMarkers(this.provider.getTodoTaskMarkerId(), true, 0);
                int i = 0;
                while (i < tasks.length) {
                    tasks[i].delete();
                    ++i;
                }
            }
            catch (CoreException e) {
                this.provider.logError("Was not able to delete markers", e);
            }
        }
        if (tasks == null) {
            tasks = new IMarker[]{};
        }
        return tasks;
    }

    protected void visitResource(TaskTagContext context, IFile file) throws CoreException {
        if (file == null) {
            return;
        }
        if (!file.exists()) {
            return;
        }
        if (file.isDerived()) {
            return;
        }
        if (!file.isSynchronized(0)) {
            return;
        }
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (BufferedReader br = new BufferedReader(new InputStreamReader(file.getContents(), "UTF-8"));){
                String line = null;
                ArrayList<String> list = new ArrayList<String>();
                while ((line = br.readLine()) != null) {
                    list.add(line);
                }
                String[] lines = list.toArray(new String[list.size()]);
                this.visitLines(context, lines, file);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | RuntimeException e) {
            throw new CoreException((IStatus)new Status(4, this.provider.getTodoTaskPluginId(), "Not able to visit resource", (Throwable)e));
        }
    }

    private void handleResource(TaskTagContext context, IResource resource) {
        if (!(resource instanceof IFile)) {
            return;
        }
        IFile file = (IFile)resource;
        if (!this.provider.isFileHandled(file)) {
            return;
        }
        try {
            this.visitResource(context, file);
        }
        catch (CoreException e) {
            this.provider.logError("Cannot visit resource:" + file, e);
        }
    }

    private void handleDelta(TaskTagContext context, IResourceDelta delta) {
        if (delta == null) {
            return;
        }
        int flags = delta.getFlags();
        if (flags == 131072) {
            return;
        }
        IResource resource = delta.getResource();
        if (resource instanceof IFile) {
            this.handleResource(context, resource);
            return;
        }
        IResourceDelta[] iResourceDeltaArray = delta.getAffectedChildren();
        int n = iResourceDeltaArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResourceDelta childDelta = iResourceDeltaArray[n2];
            this.handleDelta(context, childDelta);
            ++n2;
        }
    }

    private static class CreateMarkerAction {
        int priority;
        IResource resource;
        String message;
        int lineNumber;

        private CreateMarkerAction() {
        }
    }

    private class TaskTagContext {
        List<IResource> resourcesToClean = new ArrayList<IResource>();
        List<CreateMarkerAction> actions = new ArrayList<CreateMarkerAction>();
        boolean ignoreFilesWithExistingMarkers;

        private TaskTagContext() {
        }
    }

    public static class TaskTagDefinition {
        private TaskTagPriority priority;
        private String identifier;

        public TaskTagDefinition() {
            this(null, null);
        }

        public TaskTagDefinition(String identifier, TaskTagPriority priority) {
            if (identifier == null) {
                identifier = "unknown";
            }
            if (priority == null) {
                priority = TaskTagPriority.LOW;
            }
            this.identifier = identifier;
            this.priority = priority;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.identifier == null ? 0 : this.identifier.hashCode());
            result = 31 * result + (this.priority == null ? 0 : this.priority.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TaskTagDefinition other = (TaskTagDefinition)obj;
            if (this.identifier == null ? other.identifier != null : !this.identifier.equals(other.identifier)) {
                return false;
            }
            return this.priority == other.priority;
        }

        public TaskTagPriority getPriority() {
            if (this.priority == null) {
                this.priority = TaskTagPriority.NORMAL;
            }
            return this.priority;
        }

        public void setPriority(TaskTagPriority priority) {
            this.priority = priority;
        }

        public void setPriority(String priority) {
            try {
                this.priority = TaskTagPriority.valueOf(priority);
            }
            catch (RuntimeException e) {
                this.priority = TaskTagPriority.LOW;
            }
        }

        public String getIdentifier() {
            return this.identifier;
        }

        public void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        public boolean isHighPriority() {
            return TaskTagPriority.HIGH.equals((Object)this.priority);
        }

        public boolean isNormalPriority() {
            return TaskTagPriority.NORMAL.equals((Object)this.priority);
        }

        public boolean isLowPriority() {
            return TaskTagPriority.LOW.equals((Object)this.priority);
        }
    }

    public static enum TaskTagPriority {
        HIGH(2),
        NORMAL(1),
        LOW(0);

        private int markerPriority;

        public int getMarkerPriority() {
            return this.markerPriority;
        }

        private TaskTagPriority(int priority) {
            this.markerPriority = priority;
        }

        public String labelText() {
            return this.name();
        }
    }

    public static interface TaskTagSupportProvider {
        public void logError(String var1, Throwable var2);

        public boolean isFileHandled(IFile var1);

        public List<TaskTagDefinition> getTaskTagDefinitions();

        public boolean isTodoTaskSupportEnabled();

        public boolean isLineCheckforTodoTaskNessary(String var1, int var2, String[] var3);

        public String getTodoTaskMarkerId();

        public String getTodoTaskPluginId();
    }
}

