/*
 * Decompiled with CFR 0.152.
 */
package de.jcup.eclipse.commons.tasktags;

import de.jcup.eclipse.commons.tasktags.TaskTagsSupport;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

class TaskTagDialog
extends TitleAreaDialog {
    private Text txtIdentifier;
    private Button btnPrioHigh;
    private Button btnPrioNormal;
    private Button btnPrioLow;
    private TaskTagsSupport.TaskTagDefinition definition;

    public TaskTagDialog(Shell parentShell, TaskTagsSupport.TaskTagDefinition definition) {
        super(parentShell);
        if (definition == null) {
            definition = new TaskTagsSupport.TaskTagDefinition("XXX", TaskTagsSupport.TaskTagPriority.NORMAL);
        }
        this.definition = definition;
    }

    public void create() {
        super.create();
        this.setTitle("Define Todo Task");
        this.setMessage("Create or change your task definition", 1);
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout layout = new GridLayout(2, false);
        container.setLayout((Layout)layout);
        this.createPrioritySelection(container);
        this.createIdentifierTextfields(container);
        return area;
    }

    private void createPrioritySelection(Composite container) {
        GridData data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        data.horizontalSpan = 2;
        Group prioGroup = new Group(container, 0);
        prioGroup.setText("Priority:");
        prioGroup.setLayout((Layout)new RowLayout(512));
        prioGroup.setLayoutData((Object)data);
        this.btnPrioHigh = new Button((Composite)prioGroup, 16);
        this.btnPrioHigh.setText(TaskTagsSupport.TaskTagPriority.HIGH.labelText());
        this.btnPrioHigh.setSelection(this.definition.isHighPriority());
        this.btnPrioHigh.setToolTipText("High priority");
        this.btnPrioNormal = new Button((Composite)prioGroup, 16);
        this.btnPrioNormal.setText(TaskTagsSupport.TaskTagPriority.NORMAL.labelText());
        this.btnPrioNormal.setToolTipText("Normal priority");
        this.btnPrioNormal.setSelection(this.definition.isNormalPriority());
        this.btnPrioLow = new Button((Composite)prioGroup, 16);
        this.btnPrioLow.setText(TaskTagsSupport.TaskTagPriority.LOW.labelText());
        this.btnPrioLow.setToolTipText("Low priority");
        this.btnPrioLow.setSelection(this.definition.isLowPriority());
    }

    private void createIdentifierTextfields(Composite container) {
        Label lblIdentifier = new Label(container, 0);
        lblIdentifier.setText("Identifier");
        GridData data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        this.txtIdentifier = new Text(container, 2048);
        this.txtIdentifier.setLayoutData((Object)data);
        this.txtIdentifier.setText(this.definition.getIdentifier());
    }

    protected boolean isResizable() {
        return true;
    }

    private void saveInput() {
        String identifier = this.txtIdentifier.getText();
        this.definition.setIdentifier(identifier);
        if (this.btnPrioHigh.getSelection()) {
            this.definition.setPriority(TaskTagsSupport.TaskTagPriority.HIGH);
        } else if (this.btnPrioNormal.getSelection()) {
            this.definition.setPriority(TaskTagsSupport.TaskTagPriority.NORMAL);
        } else if (this.btnPrioLow.getSelection()) {
            this.definition.setPriority(TaskTagsSupport.TaskTagPriority.LOW);
        }
    }

    protected void okPressed() {
        this.saveInput();
        super.okPressed();
    }

    public TaskTagsSupport.TaskTagDefinition getDefinition() {
        return this.definition;
    }
}

