/*
 * Decompiled with CFR 0.152.
 */
package de.jcup.eclipse.commons.tasktags;

import de.jcup.eclipse.commons.tasktags.AbstractConfigurableTaskTagsSupportProvider;
import de.jcup.eclipse.commons.tasktags.TaskTagDefinitionDefaults;
import de.jcup.eclipse.commons.tasktags.TaskTagDialog;
import de.jcup.eclipse.commons.tasktags.TaskTagsSupport;
import de.jcup.eclipse.commons.ui.SWTFactory;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class AbstractTaskTagsPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    static final String PREFERENCE_KEY_TODOS_DEFINITIONS = "todo.tasks.definitons";
    static final String PREFERENCE_KEY_TODOS_ENABLED = "todo.tasks.enabled";
    private AbstractConfigurableTaskTagsSupportProvider provider;
    private Button btnTodosEnabled;
    private boolean todosEnabled;
    protected TableViewer propertiesTable;
    protected String[] propertyTableColumnHeaders = new String[]{"Identifier", "Priority"};
    protected static final String P_VARIABLE = "variable";
    protected static final String P_VALUE = "value";
    protected Button propertyAddButton;
    protected Button propertyEditButton;
    protected Button propertyRemoveButton;
    private List<TaskTagsSupport.TaskTagDefinition> definitionWorkingCopy;
    private static final Object[] NO_OBJECTS = new Object[0];

    public AbstractTaskTagsPreferencePage(AbstractConfigurableTaskTagsSupportProvider provider, String title, String description) {
        this.setPreferenceStore(provider.getPreferenceStore());
        this.setDescription(description);
        this.setTitle(title);
        this.provider = provider;
        this.definitionWorkingCopy = new ArrayList<TaskTagsSupport.TaskTagDefinition>(provider.getTaskTagDefinitions());
        this.todosEnabled = provider.isTodoTaskSupportEnabled();
    }

    protected void performDefaults() {
        this.definitionWorkingCopy = new ArrayList<TaskTagsSupport.TaskTagDefinition>(TaskTagDefinitionDefaults.get());
        this.updateTable();
    }

    public boolean performOk() {
        boolean enabledStateAsBefore = this.todosEnabled == this.provider.isTodoTaskSupportEnabled();
        boolean sameContentAsBefore = this.checkSameDefinitionsAsBefore();
        if (!sameContentAsBefore || !enabledStateAsBefore) {
            String convertListTostring = this.provider.getConverter().convertListTostring(this.definitionWorkingCopy);
            this.getPreferenceStore().setValue(PREFERENCE_KEY_TODOS_ENABLED, this.todosEnabled);
            this.getPreferenceStore().setValue(PREFERENCE_KEY_TODOS_DEFINITIONS, convertListTostring);
            this.provider.resetTaskTagDefinitions();
            this.provider.getTodoTaskSupport().fullRebuild();
        }
        return super.performOk();
    }

    private boolean checkSameDefinitionsAsBefore() {
        HashSet<TaskTagsSupport.TaskTagDefinition> freshCopy = new HashSet<TaskTagsSupport.TaskTagDefinition>(this.provider.getTaskTagDefinitions());
        HashSet<TaskTagsSupport.TaskTagDefinition> copiedDefinitionsAsSet = new HashSet<TaskTagsSupport.TaskTagDefinition>(this.definitionWorkingCopy);
        return copiedDefinitionsAsSet.equals(freshCopy);
    }

    protected void performApply() {
        super.performApply();
    }

    public void dispose() {
        super.dispose();
    }

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite parent) {
        Composite mainComposite = SWTFactory.createComposite(parent, 2, 2, 1808);
        this.createCheckBox(mainComposite);
        this.createTable(mainComposite);
        this.createTableButtons(mainComposite);
        return mainComposite;
    }

    private void createCheckBox(Composite mainComposite) {
        this.btnTodosEnabled = new Button(mainComposite, 32);
        this.btnTodosEnabled.setText("Todo tasks enabled");
        this.btnTodosEnabled.setSelection(this.todosEnabled);
        this.btnTodosEnabled.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractTaskTagsPreferencePage.this.updateTable();
                AbstractTaskTagsPreferencePage.this.todosEnabled = AbstractTaskTagsPreferencePage.this.btnTodosEnabled.getSelection();
            }
        });
        GridData layoutData = new GridData();
        layoutData.verticalSpan = 2;
        this.btnTodosEnabled.setLayoutData((Object)layoutData);
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
    }

    protected void createTable(Composite parent) {
        Font font = parent.getFont();
        SWTFactory.createLabel(parent, "Definitions:", 2);
        Composite tableComposite = SWTFactory.createComposite(parent, font, 1, 1, 1808, 0, 0);
        this.propertiesTable = new TableViewer(tableComposite, 68354);
        Table table = this.propertiesTable.getTable();
        table.setLayout((Layout)new GridLayout());
        table.setLayoutData((Object)new GridData(1808));
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        table.setFont(font);
        this.propertiesTable.setContentProvider((IContentProvider)new TaskTagDefinitionsContentProvider());
        this.propertiesTable.setLabelProvider((IBaseLabelProvider)new TaskTagDefinitionLabelProvider());
        this.propertiesTable.setColumnProperties(new String[]{P_VARIABLE, P_VALUE});
        this.propertiesTable.setComparator(new ViewerComparator(){

            public int compare(Viewer iviewer, Object e1, Object e2) {
                if (e1 == null) {
                    return -1;
                }
                if (e2 == null) {
                    return 1;
                }
                return ((TaskTagsSupport.TaskTagDefinition)e1).getIdentifier().compareToIgnoreCase(((TaskTagsSupport.TaskTagDefinition)e2).getIdentifier());
            }
        });
        this.propertiesTable.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                AbstractTaskTagsPreferencePage.this.handleTableSelectionChanged(event);
            }
        });
        this.propertiesTable.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (!AbstractTaskTagsPreferencePage.this.propertiesTable.getSelection().isEmpty()) {
                    AbstractTaskTagsPreferencePage.this.handlePropertiesEditButtonSelected();
                }
            }
        });
        final TableColumn tc1 = new TableColumn(table, 0, 0);
        tc1.setText(this.propertyTableColumnHeaders[0]);
        final TableColumn tc2 = new TableColumn(table, 0, 1);
        tc2.setText(this.propertyTableColumnHeaders[1]);
        final Table tref = table;
        final Composite comp = tableComposite;
        tableComposite.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Rectangle area = comp.getClientArea();
                Point size = tref.computeSize(-1, -1);
                ScrollBar vBar = tref.getVerticalBar();
                int width = area.width - tref.computeTrim((int)0, (int)0, (int)0, (int)0).width - 2;
                if (size.y > area.height + tref.getHeaderHeight()) {
                    Point vBarSize = vBar.getSize();
                    width -= vBarSize.x;
                }
                Point oldSize = tref.getSize();
                if (oldSize.x > area.width) {
                    tc1.setWidth(width / 2 - 1);
                    tc2.setWidth(width - tc1.getWidth());
                    tref.setSize(area.width, area.height);
                } else {
                    tref.setSize(area.width, area.height);
                    tc1.setWidth(width / 2 - 1);
                    tc2.setWidth(width - tc1.getWidth());
                }
            }
        });
        this.propertiesTable.setInput(this.definitionWorkingCopy);
        this.propertiesTable.refresh();
    }

    protected void handleTableSelectionChanged(SelectionChangedEvent event) {
        int size = ((IStructuredSelection)event.getSelection()).size();
        this.propertyEditButton.setEnabled(size == 1);
        this.propertyRemoveButton.setEnabled(size > 0);
    }

    protected void createTableButtons(Composite parent) {
        Composite buttonComposite = SWTFactory.createComposite(parent, parent.getFont(), 1, 1, 130, 0, 0);
        this.propertyAddButton = SWTFactory.createPushButton(buttonComposite, "N&ew...", null);
        this.propertyAddButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                AbstractTaskTagsPreferencePage.this.handlePropertiesAddButtonSelected();
            }
        });
        this.propertyEditButton = SWTFactory.createPushButton(buttonComposite, "E&dit...", null);
        this.propertyEditButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                AbstractTaskTagsPreferencePage.this.handlePropertiesEditButtonSelected();
            }
        });
        this.propertyEditButton.setEnabled(false);
        this.propertyRemoveButton = SWTFactory.createPushButton(buttonComposite, "Rem&ove", null);
        this.propertyRemoveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                AbstractTaskTagsPreferencePage.this.handlePropertiesRemoveButtonSelected();
            }
        });
        this.propertyRemoveButton.setEnabled(false);
    }

    protected void handlePropertiesAddButtonSelected() {
        TaskTagDialog dialog = new TaskTagDialog(this.getShell(), null);
        if (dialog.open() != 0) {
            return;
        }
        TaskTagsSupport.TaskTagDefinition definition = dialog.getDefinition();
        String name = definition.getIdentifier();
        if (name != null && name.length() > 0) {
            this.addVariable(definition);
        }
    }

    protected boolean addVariable(TaskTagsSupport.TaskTagDefinition definition) {
        String identifier = definition.getIdentifier();
        TableItem[] items = this.propertiesTable.getTable().getItems();
        int i = 0;
        while (i < items.length) {
            TaskTagsSupport.TaskTagDefinition existingVariable = (TaskTagsSupport.TaskTagDefinition)items[i].getData();
            if (existingVariable.getIdentifier().equals(identifier)) {
                boolean overWrite = MessageDialog.openQuestion((Shell)this.getShell(), (String)"Overwrite task definition?", (String)MessageFormat.format("A task definition named {0} already exists. Overwrite?", identifier));
                if (!overWrite) {
                    return false;
                }
                this.definitionWorkingCopy.remove(existingVariable);
                break;
            }
            ++i;
        }
        this.definitionWorkingCopy.add(definition);
        this.updateTable();
        return true;
    }

    private void updateTable() {
        this.propertiesTable.getContentProvider().inputChanged((Viewer)this.propertiesTable, null, this.definitionWorkingCopy);
        boolean todosEnabled = this.btnTodosEnabled.getSelection();
        this.propertiesTable.getControl().setEnabled(todosEnabled);
        this.propertyAddButton.setEnabled(todosEnabled);
        if (!todosEnabled) {
            this.propertiesTable.setSelection(null);
        }
    }

    private void handlePropertiesEditButtonSelected() {
        IStructuredSelection sel = (IStructuredSelection)this.propertiesTable.getSelection();
        TaskTagsSupport.TaskTagDefinition var = (TaskTagsSupport.TaskTagDefinition)sel.getFirstElement();
        if (var == null) {
            return;
        }
        TaskTagDialog dialog = new TaskTagDialog(this.getShell(), var);
        if (dialog.open() != 0) {
            return;
        }
        this.updateTable();
    }

    private void handlePropertiesRemoveButtonSelected() {
        IStructuredSelection sel = (IStructuredSelection)this.propertiesTable.getSelection();
        for (TaskTagsSupport.TaskTagDefinition var : sel) {
            this.definitionWorkingCopy.remove(var);
        }
        this.updateTable();
    }

    public class TaskTagDefinitionLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        public String getColumnText(Object element, int columnIndex) {
            String result = null;
            if (element != null) {
                TaskTagsSupport.TaskTagDefinition var = (TaskTagsSupport.TaskTagDefinition)element;
                switch (columnIndex) {
                    case 0: {
                        result = var.getIdentifier();
                        break;
                    }
                    case 1: {
                        result = var.getPriority().name();
                    }
                }
            }
            return result;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }
    }

    protected class TaskTagDefinitionsContentProvider
    implements IStructuredContentProvider {
        protected TaskTagDefinitionsContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof List) {
                Object[] result = ((List)inputElement).toArray();
                return result;
            }
            return NO_OBJECTS;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            if (newInput == null) {
                return;
            }
            if (viewer instanceof TableViewer) {
                TableViewer tableViewer = (TableViewer)viewer;
                if (tableViewer.getTable().isDisposed()) {
                    return;
                }
                tableViewer.refresh();
            }
        }
    }
}

