/*
 * Decompiled with CFR 0.152.
 */
package de.jcup.eclipse.commons.tasktags;

import de.jcup.eclipse.commons.PluginContextProvider;
import de.jcup.eclipse.commons.tasktags.TaskTagDefinitionConverter;
import de.jcup.eclipse.commons.tasktags.TaskTagsSupport;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public abstract class AbstractConfigurableTaskTagsSupportProvider
implements TaskTagsSupport.TaskTagSupportProvider {
    private List<TaskTagsSupport.TaskTagDefinition> cachedTaskTagDefinitions;
    private TaskTagDefinitionConverter converter;
    private AbstractUIPlugin plugin;
    private String pluginId;
    private TaskTagsSupport todoTaskSupport;

    public AbstractConfigurableTaskTagsSupportProvider(PluginContextProvider provider) {
        this.plugin = provider.getActivator();
        this.pluginId = provider.getPluginID();
        this.converter = new TaskTagDefinitionConverter();
        this.todoTaskSupport = new TaskTagsSupport(this);
    }

    public TaskTagsSupport getTodoTaskSupport() {
        return this.todoTaskSupport;
    }

    @Override
    public void logError(String error, Throwable t) {
        this.plugin.getLog().log((IStatus)new Status(4, this.pluginId, error, t));
    }

    TaskTagDefinitionConverter getConverter() {
        return this.converter;
    }

    @Override
    public List<TaskTagsSupport.TaskTagDefinition> getTaskTagDefinitions() {
        if (this.cachedTaskTagDefinitions == null) {
            String string = this.getPreferenceStore().getString("todo.tasks.definitons");
            this.cachedTaskTagDefinitions = this.converter.convertStringToList(string);
        }
        return this.cachedTaskTagDefinitions;
    }

    protected void resetTaskTagDefinitions() {
        this.cachedTaskTagDefinitions = null;
    }

    @Override
    public boolean isTodoTaskSupportEnabled() {
        return this.getPreferenceStore().getBoolean("todo.tasks.enabled");
    }

    @Override
    public String getTodoTaskPluginId() {
        return this.pluginId;
    }

    public IPreferenceStore getPreferenceStore() {
        return this.plugin.getPreferenceStore();
    }
}

