/*
 * Decompiled with CFR 0.152.
 */
package de.jcup.eclipse.commons.source;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;

public class SourceCodeBuilder {
    public static final String CURSOR_TAG = "####___cursor____####";
    private static final Pattern CURSOR_TAG_PATTERN = Pattern.compile("####___cursor____####");

    public List<String> buildClosureTemplate(String before) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(String.valueOf(before) + " {");
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < 4) {
            sb.append(" ");
            ++i;
        }
        sb.append(CURSOR_TAG);
        list.add(sb.toString());
        list.add("}");
        return list;
    }

    public int calculateNextSelection(int zeroOffset, String code) {
        int index = code.indexOf(CURSOR_TAG);
        if (index == -1) {
            return zeroOffset + code.length();
        }
        return zeroOffset + index;
    }

    public String buildCode(String indentionStringBefore, List<String> proposalLines, boolean replaceCursorTag, boolean addNewLineAtEnd) {
        if (proposalLines == null || proposalLines.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        boolean mustIndent = false;
        Iterator<String> it = proposalLines.iterator();
        while (it.hasNext()) {
            String proposalLine = it.next();
            if (mustIndent) {
                sb.append(indentionStringBefore);
            }
            String line = null;
            line = replaceCursorTag ? CURSOR_TAG_PATTERN.matcher(proposalLine).replaceFirst("") : proposalLine;
            sb.append(line);
            if (it.hasNext() || addNewLineAtEnd) {
                sb.append("\n");
            }
            mustIndent = true;
        }
        return sb.toString();
    }

    public List<String> buildSingleLineTemplate(String content) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(content);
        return list;
    }
}

