/*
 * Decompiled with CFR 0.152.
 */
package de.jcup.eclipse.commons.replacetabbyspaces;

import java.util.ArrayList;

public class TabReplaceBySpacesStringBuilder {
    public String createBlockReplacement(boolean doIndent, int numSpaces, String lineBlock) {
        String tabReplacement = this.createTabReplacement(numSpaces);
        String[] lines = lineBlock.split("\\r?\\n");
        ArrayList<String> replacement = new ArrayList<String>();
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            String newLine = null;
            newLine = doIndent ? this.indent(line, tabReplacement) : this.outdent(line, numSpaces);
            replacement.add(newLine);
            ++n2;
        }
        String strReplacement = String.join((CharSequence)"\n", replacement);
        return strReplacement;
    }

    public String createTabReplacement(int spaces) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < spaces) {
            sb.append(' ');
            ++i;
        }
        return sb.toString();
    }

    public String outdent(String line, int spaces) {
        if (line == null) {
            return "";
        }
        int numLeadingSpaces = this.calculateAmountOfLeadingSpaces(line, spaces);
        int index = Math.min(numLeadingSpaces, spaces);
        if (index < 0) {
            return line;
        }
        if (index >= line.length()) {
            return "";
        }
        return line.substring(index);
    }

    private int calculateAmountOfLeadingSpaces(String line, int spaces) {
        int numLeadingSpaces = 0;
        int i = 0;
        while (i < spaces && i < line.length()) {
            if (line.charAt(i) != ' ') break;
            ++numLeadingSpaces;
            ++i;
        }
        return numLeadingSpaces;
    }

    private String indent(String line, String toInsert) {
        return String.valueOf(toInsert) + line;
    }
}

