/*
 * Decompiled with CFR 0.152.
 */
package de.jcup.eclipse.commons.replacetabbyspaces;

import de.jcup.eclipse.commons.CaretInfoProvider;
import de.jcup.eclipse.commons.replacetabbyspaces.ReplaceTabBySpacesProvider;
import de.jcup.eclipse.commons.replacetabbyspaces.TabReplaceBySpacesStringBuilder;
import de.jcup.eclipse.commons.ui.EclipseUtil;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

class ReplaceTabBySpacesVerifyKeyListener
implements VerifyKeyListener {
    private final ITextEditor editor;
    private TabReplaceBySpacesStringBuilder stringBuilder;
    private ReplaceTabBySpacesProvider replaceTabBySpaceProvider;
    private CaretInfoProvider caretInfoProvider;

    ReplaceTabBySpacesVerifyKeyListener(ITextEditor editor, ReplaceTabBySpacesProvider replaceTabBySpaceProvider, CaretInfoProvider caretInfoProvider) {
        if (editor == null) {
            throw new IllegalArgumentException("editor may not be null");
        }
        this.stringBuilder = new TabReplaceBySpacesStringBuilder();
        this.editor = editor;
        this.replaceTabBySpaceProvider = replaceTabBySpaceProvider;
        this.caretInfoProvider = caretInfoProvider;
    }

    public void verifyKey(VerifyEvent event) {
        if (event.character != '\t') {
            return;
        }
        if (!this.replaceTabBySpaceProvider.isReplaceTabBySpacesEnabled()) {
            return;
        }
        event.doit = false;
        boolean doIndent = event.stateMask == 0;
        boolean doOutdent = (event.stateMask & 0x20000) == 131072;
        EclipseUtil.safeAsyncExec(() -> {
            boolean isMultiline;
            ISelection selection = this.editor.getSelectionProvider().getSelection();
            if (!(selection instanceof ITextSelection)) {
                return;
            }
            ITextSelection ts = (ITextSelection)selection;
            IDocumentProvider dp = this.editor.getDocumentProvider();
            IDocument doc = dp.getDocument((Object)this.editor.getEditorInput());
            int offset = ts.getOffset();
            if (offset == -1) {
                offset = this.caretInfoProvider.getLastCaretPosition();
            }
            boolean bl3 = isMultiline = ts.getStartLine() != -1 && ts.getEndLine() > ts.getStartLine();
            if (!doIndent && !doOutdent) {
                return;
            }
            this.handleIndentOutdent(ts, doc, offset, isMultiline, doIndent);
        });
    }

    private void handleIndentOutdent(ITextSelection ts, IDocument doc, int offset, boolean isMultiline, boolean doIndent) {
        try {
            int numSpaces = this.replaceTabBySpaceProvider.getAmountOfSpacesToReplaceTab();
            if (numSpaces < 1) {
                return;
            }
            if (isMultiline) {
                this.handleMultiLineSelection(ts, doc, doIndent, numSpaces);
            } else {
                this.handleSingleLineSelection(ts, doc, offset, doIndent, numSpaces);
            }
        }
        catch (BadLocationException e) {
            EclipseUtil.logError("Cannot insert tab replacement at " + offset, e, this.replaceTabBySpaceProvider.getPluginContextProvider());
        }
    }

    private void handleSingleLineSelection(ITextSelection ts, IDocument doc, int offset, boolean doIndent, int numSpaces) throws BadLocationException {
        int newCaretPosition;
        if (doIndent) {
            String tabReplacement = this.stringBuilder.createTabReplacement(numSpaces);
            doc.replace(offset, ts.getLength(), tabReplacement);
            newCaretPosition = offset + numSpaces;
        } else {
            int offsetBlockStart = doc.getLineOffset(ts.getStartLine());
            int offsetBlockEnd = doc.getLineOffset(ts.getEndLine()) + doc.getLineLength(ts.getEndLine());
            int lengthBlock = offsetBlockEnd - offsetBlockStart;
            if (lengthBlock <= 0) {
                return;
            }
            String line = doc.get(offsetBlockStart, lengthBlock);
            String replacement = this.stringBuilder.outdent(line, numSpaces);
            doc.replace(offsetBlockStart, lengthBlock, replacement);
            newCaretPosition = offset > offsetBlockStart + numSpaces ? offset - numSpaces : offsetBlockStart;
        }
        Control control = (Control)this.editor.getAdapter(Control.class);
        if (control instanceof StyledText) {
            StyledText t = (StyledText)control;
            t.setCaretOffset(newCaretPosition);
        }
    }

    private void handleMultiLineSelection(ITextSelection ts, IDocument doc, boolean doIndent, int numSpaces) throws BadLocationException {
        int offsetBlockStart = doc.getLineOffset(ts.getStartLine());
        int offsetBlockEnd = doc.getLineOffset(ts.getEndLine()) + doc.getLineLength(ts.getEndLine());
        int lengthBlock = offsetBlockEnd - offsetBlockStart;
        if (lengthBlock <= 0) {
            return;
        }
        String lineBlock = doc.get(offsetBlockStart, lengthBlock);
        String strReplacement = this.stringBuilder.createBlockReplacement(doIndent, numSpaces, lineBlock);
        doc.replace(offsetBlockStart, lengthBlock - 1, strReplacement);
        this.editor.selectAndReveal(offsetBlockStart, strReplacement.length());
    }
}

