/*
 * Decompiled with CFR 0.152.
 */
package de.jcup.eclipse.commons.preferences;

import de.jcup.eclipse.commons.preferences.PreferenceDataReader;
import de.jcup.eclipse.commons.preferences.PreferenceDataWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class AbstractPreferenceValueConverter<T> {
    public String convertListTostring(List<T> list) {
        StringBuilder sb = new StringBuilder();
        for (T element : list) {
            String converted = this.convertOneToString(element);
            sb.append(converted);
            sb.append(this.getListDelimeter());
        }
        return sb.toString();
    }

    public List<T> convertStringToList(String data) {
        String[] delimiteds;
        ArrayList<T> list = new ArrayList<T>();
        if (data == null || data.isEmpty()) {
            return list;
        }
        String[] stringArray = delimiteds = data.split("\\" + this.getListDelimeter());
        int n = delimiteds.length;
        int n2 = 0;
        while (n2 < n) {
            String delimited = stringArray[n2];
            T converted = this.convertOneFromString(delimited);
            if (converted != null) {
                list.add(converted);
            }
            ++n2;
        }
        return list;
    }

    protected abstract void write(T var1, PreferenceDataWriter var2);

    protected abstract T read(PreferenceDataReader var1);

    protected String getListDelimeter() {
        return "|";
    }

    protected String getValueDelimeter() {
        return ",";
    }

    protected final String convertOneToString(T oneEntry) {
        DataWriterImpl context = new DataWriterImpl();
        this.write(oneEntry, context);
        return context.toSingleString();
    }

    protected final T convertOneFromString(String oneEntry) {
        DataReaderImpl context = new DataReaderImpl(oneEntry);
        return this.read(context);
    }

    protected class DataReaderImpl
    implements PreferenceDataReader {
        private List<String> data = new ArrayList<String>();
        private Iterator<String> iterator;

        public DataReaderImpl(String string) {
            String[] dataArray;
            String[] stringArray = dataArray = string.split("\\" + AbstractPreferenceValueConverter.this.getValueDelimeter());
            int n = dataArray.length;
            int n2 = 0;
            while (n2 < n) {
                String dataArrayPart = stringArray[n2];
                this.data.add(dataArrayPart);
                ++n2;
            }
            this.iterator = this.data.iterator();
        }

        @Override
        public int readInt() {
            String asString = this.readString();
            if (asString == null) {
                return -1;
            }
            try {
                return Integer.parseInt(asString);
            }
            catch (NumberFormatException e) {
                return -1;
            }
        }

        @Override
        public String readString() {
            if (this.iterator.hasNext()) {
                return this.iterator.next();
            }
            return null;
        }
    }

    protected class DataWriterImpl
    implements PreferenceDataWriter {
        private List<String> data = new ArrayList<String>();

        protected DataWriterImpl() {
        }

        @Override
        public void writeInt(int integer) {
            this.data.add("" + integer);
        }

        @Override
        public void writeString(String string) {
            if (string == null) {
                string = "";
            }
            this.data.add(string);
        }

        public String toSingleString() {
            StringBuilder sb = new StringBuilder();
            Iterator<String> it = this.data.iterator();
            while (it.hasNext()) {
                sb.append(it.next());
                if (!it.hasNext()) continue;
                sb.append(AbstractPreferenceValueConverter.this.getValueDelimeter());
            }
            return sb.toString();
        }
    }
}

