/*
 * Decompiled with CFR 0.152.
 */
package de.jcup.eclipse.commons.keyword;

import de.jcup.eclipse.commons.resource.ResourceInputStreamProvider;
import de.jcup.eclipse.commons.ui.ColorUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Map;
import java.util.TreeMap;

public class TooltipTextSupport {
    static final String DIV_HTML_DESCRIPTION = "<div class='htmlDescription'>";
    private static final TooltipTextSupport INSTANCE = new TooltipTextSupport();
    private Map<String, String> idToTooltipCache = new TreeMap<String, String>();
    private String loaded_tooltip_css;
    private ResourceInputStreamProvider resourceInputStreamProvider;

    public static String getTooltipText(String id) {
        return INSTANCE.get(id);
    }

    TooltipTextSupport() {
    }

    public static void setTooltipInputStreamProvider(ResourceInputStreamProvider resourceInputStreamProvider) {
        INSTANCE.setResourceInputStreamProvider(resourceInputStreamProvider);
    }

    public void setResourceInputStreamProvider(ResourceInputStreamProvider resourceInputStreamProvider) {
        this.resourceInputStreamProvider = resourceInputStreamProvider;
    }

    public static boolean isHTMLToolTip(String tooltip) {
        if (tooltip == null) {
            return false;
        }
        return tooltip.startsWith(DIV_HTML_DESCRIPTION);
    }

    public static final String getTooltipCSS() {
        return INSTANCE.getCSS();
    }

    public String getCSS() {
        this.ensureTooltipCSSFileLoaded();
        return this.createTooltipCSSString();
    }

    protected void ensureTooltipCSSFileLoaded() {
        if (this.loaded_tooltip_css == null) {
            String path = this.createPathWithoutFileEnding("_tooltips");
            String loaded = this.loadFrom(String.valueOf(path) + ".css");
            this.loaded_tooltip_css = loaded == null ? "" : loaded;
        }
    }

    private String createTooltipCSSString() {
        String linkColor = ColorUtil.convertJFaceColorToWeb("HYPERLINK_COLOR");
        String activeLinkColor = ColorUtil.convertJFaceColorToWeb("ACTIVE_HYPERLINK_COLOR");
        StringBuilder sb = new StringBuilder();
        if (linkColor != null) {
            sb.append("\na:link,a:visited {");
            sb.append(" color:").append(linkColor);
            sb.append("}\n");
        }
        if (activeLinkColor != null) {
            sb.append("\na:hover,a:active {");
            sb.append(" color:").append(activeLinkColor);
            sb.append("}\n");
        }
        sb.append(this.loaded_tooltip_css);
        return sb.toString();
    }

    public String get(String id) {
        if (id == null) {
            return "";
        }
        String tooltip = this.idToTooltipCache.get(id);
        if (tooltip == null) {
            tooltip = this.load(id);
            this.idToTooltipCache.put(id, tooltip);
        }
        return tooltip;
    }

    String load(String id) {
        if (id == null) {
            throw new IllegalArgumentException("id may not be null");
        }
        String path = this.createPathWithoutFileEnding(id);
        String loaded = this.loadFrom(String.valueOf(path) + ".html");
        if (loaded != null) {
            return this.markAsHTMLContent(loaded);
        }
        loaded = this.loadFrom(String.valueOf(path) + ".txt");
        if (loaded != null) {
            return loaded;
        }
        return "";
    }

    protected String createPathWithoutFileEnding(String id) {
        return "/tooltips/" + id;
    }

    private String markAsHTMLContent(String content) {
        StringBuilder sb = new StringBuilder();
        sb.append(DIV_HTML_DESCRIPTION);
        sb.append(content);
        sb.append("</div>");
        return sb.toString();
    }

    private String loadFrom(String path) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (InputStream inputStream = this.getInputStream(path);){
                return this.loadFromStreamAsUTF_8(inputStream);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            return null;
        }
    }

    private InputStream getInputStream(String path) throws IOException {
        if (this.resourceInputStreamProvider == null) {
            return null;
        }
        return this.resourceInputStreamProvider.getStreamFor(path);
    }

    private String loadFromStreamAsUTF_8(InputStream stream) throws IOException {
        if (stream == null) {
            return null;
        }
        BufferedReader br = new BufferedReader(new InputStreamReader(stream, "UTF-8"));
        StringBuilder sb = new StringBuilder();
        String line = null;
        while ((line = br.readLine()) != null) {
            sb.append(line);
            sb.append("\n");
        }
        return sb.toString();
    }
}

