/*
 * Decompiled with CFR 0.152.
 */
package de.jcup.eclipse.commons.codeassist;

import de.jcup.eclipse.commons.codeassist.ContentAssistSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ContentAssistEvent;
import org.eclipse.jface.text.contentassist.ICompletionListener;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;

public class SupportableContentAssistProcessor
implements IContentAssistProcessor,
ICompletionListener {
    private List<ContentAssistSupport> supports = new ArrayList<ContentAssistSupport>();
    private String errorMessage;

    public SupportableContentAssistProcessor(ContentAssistSupport ... supports) {
        this.supports.addAll(Arrays.asList(supports));
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        IDocument document = viewer.getDocument();
        if (document == null) {
            return null;
        }
        ArrayList<? extends ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
        for (ContentAssistSupport support : this.supports) {
            proposals.addAll(support.calculate(document, offset));
        }
        return proposals.toArray(new ICompletionProposal[proposals.size()]);
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        return null;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return null;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }

    public ICompletionListener getCompletionListener() {
        return this;
    }

    public void assistSessionStarted(ContentAssistEvent event) {
        for (ContentAssistSupport support : this.supports) {
            support.startAssistSession();
        }
    }

    public void assistSessionEnded(ContentAssistEvent event) {
        for (ContentAssistSupport support : this.supports) {
            support.endAssistSession();
        }
    }

    public void selectionChanged(ICompletionProposal proposal, boolean smartToggle) {
    }
}

