/*
 * Decompiled with CFR 0.152.
 */
package de.jcup.eclipse.commons.codeassist;

import de.jcup.eclipse.commons.WordListBuilder;
import de.jcup.eclipse.commons.codeassist.AbstractWordCodeCompletition;
import de.jcup.eclipse.commons.codeassist.ProposalProvider;
import de.jcup.eclipse.commons.codeassist.ProposalProviderSupport;
import de.jcup.eclipse.commons.codeassist.SimpleWordListBuilder;
import de.jcup.eclipse.commons.codeassist.SimpleWordProposalProvider;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public class SimpleWordCodeCompletion
extends AbstractWordCodeCompletition
implements ProposalProviderSupport {
    private Set<ProposalProvider> additionalWordsCache = new HashSet<ProposalProvider>();
    private SortedSet<ProposalProvider> allWordsCache = new TreeSet<ProposalProvider>();
    private WordListBuilder wordListBuilder;

    public void add(String word) {
        if (word == null) {
            return;
        }
        if (!this.allWordsCache.isEmpty()) {
            this.allWordsCache.clear();
        }
        this.additionalWordsCache.add(new SimpleWordProposalProvider(word.trim()));
    }

    @Override
    public Set<ProposalProvider> calculate(String source, int offset) {
        this.rebuildCacheIfNecessary(source);
        if (offset == 0) {
            return Collections.unmodifiableSet(this.allWordsCache);
        }
        String wanted = this.getTextbefore(source, offset);
        return this.filter(this.allWordsCache, wanted);
    }

    @Override
    public void reset() {
        this.allWordsCache.clear();
        this.additionalWordsCache.clear();
    }

    Set<ProposalProvider> filter(SortedSet<ProposalProvider> allWords, String wanted) {
        if (allWords == null) {
            return Collections.emptySet();
        }
        if (wanted == null || wanted.isEmpty()) {
            return allWords;
        }
        LinkedHashSet<ProposalProvider> filtered = new LinkedHashSet<ProposalProvider>();
        LinkedHashSet<ProposalProvider> addAfterEnd = new LinkedHashSet<ProposalProvider>();
        String wantedLowerCase = wanted.toLowerCase();
        for (ProposalProvider info : allWords) {
            String label;
            if (info == null || (label = info.getLabel()) == null) continue;
            String wordLowerCase = label.toLowerCase();
            if (wordLowerCase.equalsIgnoreCase(wantedLowerCase)) {
                filtered.remove(info);
                continue;
            }
            if (wordLowerCase.startsWith(wantedLowerCase)) {
                filtered.add(info);
                continue;
            }
            if (wordLowerCase.indexOf(wantedLowerCase) == -1) continue;
            addAfterEnd.add(info);
        }
        filtered.addAll(addAfterEnd);
        return filtered;
    }

    private void rebuildCacheIfNecessary(String source) {
        if (this.allWordsCache.isEmpty()) {
            this.allWordsCache.addAll(this.additionalWordsCache);
            List<String> allWordsBuild = this.getWordListBuilder().build(source);
            for (String word : allWordsBuild) {
                if (word.isEmpty()) continue;
                this.allWordsCache.add(new SimpleWordProposalProvider(word));
            }
        }
    }

    public WordListBuilder getWordListBuilder() {
        if (this.wordListBuilder == null) {
            this.wordListBuilder = new SimpleWordListBuilder();
        }
        return this.wordListBuilder;
    }

    public void setWordListBuilder(WordListBuilder wordListBuilder) {
        this.wordListBuilder = wordListBuilder;
    }
}

