/*
 * Decompiled with CFR 0.152.
 */
package de.jcup.eclipse.commons.codeassist;

import de.jcup.eclipse.commons.PluginContextProvider;
import de.jcup.eclipse.commons.codeassist.ProposalInfoProvider;
import de.jcup.eclipse.commons.codeassist.ProposalProvider;
import de.jcup.eclipse.commons.codeassist.ProposalProviderSupport;
import de.jcup.eclipse.commons.source.SourceCodeBuilder;
import de.jcup.eclipse.commons.ui.EclipseUtil;
import java.util.List;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.BoldStylerProvider;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension6;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension7;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

public class SimpleCompletionProposal
implements ICompletionProposal,
ICompletionProposalExtension6,
ICompletionProposalExtension7 {
    private int offset;
    private ProposalProvider proposalProvider;
    private int nextSelection;
    private StyledString styledString;
    private String textBefore;
    private PluginContextProvider provider;
    private ProposalInfoProvider proposalInfoProvider;
    private SourceCodeBuilder sourceCodeBuilder = new SourceCodeBuilder();

    public SimpleCompletionProposal(ProposalProviderSupport completion, PluginContextProvider provider, IDocument document, int offset, ProposalProvider proposalProvider, ProposalInfoProvider proposalInfo) {
        this.offset = offset;
        this.proposalProvider = proposalProvider;
        this.provider = provider;
        this.proposalInfoProvider = proposalInfo;
        String source = document.get();
        this.textBefore = completion.getTextbefore(source, offset);
    }

    public void apply(IDocument document) {
        List<String> template = this.proposalProvider.getCodeTemplate();
        int zeroOffset = this.offset - this.textBefore.length();
        int offsetBefore = zeroOffset - 1;
        String indentionStringBefore = this.createIndentionString(document, zeroOffset, offsetBefore);
        try {
            String codeWithCursorTag = this.sourceCodeBuilder.buildCode(indentionStringBefore, template, false, this.isAddingNewLineAtEnd());
            String codeWithoutCursorTag = this.sourceCodeBuilder.buildCode(indentionStringBefore, template, true, this.isAddingNewLineAtEnd());
            document.replace(zeroOffset, this.textBefore.length(), codeWithoutCursorTag);
            this.nextSelection = this.sourceCodeBuilder.calculateNextSelection(zeroOffset, codeWithCursorTag);
        }
        catch (BadLocationException e) {
            EclipseUtil.logError("Not able to replace by proposal:" + this.proposalProvider + ", zero offset:" + zeroOffset + ", textBefore:" + this.textBefore, e, this.provider);
        }
    }

    protected boolean isAddingNewLineAtEnd() {
        return false;
    }

    protected String createIndentionString(IDocument document, int zeroOffset, int offsetBefore) {
        StringBuilder indentionStringBefore = new StringBuilder();
        while (offsetBefore > 0) {
            char b;
            try {
                b = document.getChar(offsetBefore);
            }
            catch (BadLocationException e) {
                EclipseUtil.logError("Not able to create indention string for proposal:" + this.proposalProvider + ", zero offset:" + zeroOffset + ", textBefore:" + this.textBefore, e, this.provider);
                return "";
            }
            if (b == '\n' || b == '\r' || b != ' ' && b != '\t') break;
            indentionStringBefore.append(b);
            --offsetBefore;
        }
        return indentionStringBefore.toString();
    }

    public Point getSelection(IDocument document) {
        Point point = new Point(this.nextSelection, 0);
        return point;
    }

    public String getAdditionalProposalInfo() {
        Object info = this.proposalInfoProvider.getProposalInfo(null, this.proposalProvider.getLabel());
        if (info != null) {
            return info.toString();
        }
        return "";
    }

    public String getDisplayString() {
        return this.proposalProvider.getLabel();
    }

    public Image getImage() {
        if (this.proposalInfoProvider == null) {
            return null;
        }
        return this.proposalInfoProvider.getImage(this.proposalProvider.getLabel());
    }

    public IContextInformation getContextInformation() {
        return null;
    }

    public StyledString getStyledDisplayString(IDocument document, int offset, BoldStylerProvider boldStylerProvider) {
        if (this.styledString != null) {
            return this.styledString;
        }
        this.styledString = new StyledString();
        this.styledString.append(this.proposalProvider.getLabel());
        try {
            int enteredTextLength = this.textBefore.length();
            int indexOfTextBefore = this.proposalProvider.getLabel().toLowerCase().indexOf(this.textBefore.toLowerCase());
            if (indexOfTextBefore != -1) {
                this.styledString.setStyle(indexOfTextBefore, enteredTextLength, boldStylerProvider.getBoldStyler());
            }
        }
        catch (RuntimeException e) {
            EclipseUtil.logError("Not able to set styles for proposal:" + this.proposalProvider.getLabel(), e, this.provider);
        }
        return this.styledString;
    }

    public StyledString getStyledDisplayString() {
        return null;
    }
}

