/*
 * Decompiled with CFR 0.152.
 */
package de.jcup.eclipse.commons.codeassist;

import de.jcup.eclipse.commons.PluginContextProvider;
import de.jcup.eclipse.commons.codeassist.ContentAssistSupport;
import de.jcup.eclipse.commons.codeassist.ProposalInfoProvider;
import de.jcup.eclipse.commons.codeassist.ProposalProvider;
import de.jcup.eclipse.commons.codeassist.ProposalProviderSupport;
import de.jcup.eclipse.commons.codeassist.SimpleCompletionProposal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.ICompletionProposal;

public abstract class ProposalProviderContentAssistSupport
implements ContentAssistSupport {
    protected ProposalProviderSupport completion;
    protected PluginContextProvider pluginContextProvider;

    public ProposalProviderContentAssistSupport(PluginContextProvider provider, ProposalProviderSupport completion) {
        this.completion = completion;
        this.pluginContextProvider = provider;
    }

    protected PluginContextProvider getPluginContextProvider() {
        return this.pluginContextProvider;
    }

    @Override
    public void startAssistSession() {
        this.completion.reset();
        this.prepareCompletion(this.completion);
    }

    protected void prepareCompletion(ProposalProviderSupport completion) {
    }

    protected ProposalInfoProvider createProposalInfoBuilder() {
        return null;
    }

    @Override
    public void endAssistSession() {
        this.completion.reset();
    }

    @Override
    public Collection<? extends ICompletionProposal> calculate(IDocument document, int offset) {
        String source = document.get();
        Set<ProposalProvider> proposalProviders = this.completion.calculate(source, offset);
        if (proposalProviders == null) {
            return Collections.emptyList();
        }
        ProposalInfoProvider proposalInfoProvider = this.createProposalInfoBuilder();
        ArrayList<SimpleCompletionProposal> result = new ArrayList<SimpleCompletionProposal>(proposalProviders.size());
        for (ProposalProvider proposalProvider : proposalProviders) {
            result.add(new SimpleCompletionProposal(this.completion, this.pluginContextProvider, document, offset, proposalProvider, proposalInfoProvider));
        }
        return result;
    }
}

