/*
 * Decompiled with CFR 0.152.
 */
package de.jcup.eclipse.commons.codeassist;

import de.jcup.eclipse.commons.codeassist.DisplayStringMultipleContentAssistSorter;
import de.jcup.eclipse.commons.codeassist.MultipleContentAssistSorter;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;

public class MultipleContentAssistProcessor
implements IContentAssistProcessor,
IContextInformationValidator {
    private List<IContentAssistProcessor> assistProcessors = new ArrayList<IContentAssistProcessor>();
    private IContentAssistProcessor validatingAssistProcessor;
    private char[] completionProposalsAutoActivationCharacers;
    private char[] contextInformationAutoActivationCharacters;
    private MultipleContentAssistSorter sorter;

    public MultipleContentAssistProcessor(IContentAssistProcessor validatingAssistProcessor, IContentAssistProcessor ... others) {
        this.validatingAssistProcessor = validatingAssistProcessor;
        this.assistProcessors.add(validatingAssistProcessor);
        IContentAssistProcessor[] iContentAssistProcessorArray = others;
        int n = others.length;
        int n2 = 0;
        while (n2 < n) {
            IContentAssistProcessor o = iContentAssistProcessorArray[n2];
            this.assistProcessors.add(o);
            ++n2;
        }
        this.completionProposalsAutoActivationCharacers = this.createCompletionProposalAutoActivationCharacters();
        this.contextInformationAutoActivationCharacters = this.createContextInformationAutoActivationCharacters();
        this.sorter = this.createSorter();
    }

    protected MultipleContentAssistSorter createSorter() {
        return new DisplayStringMultipleContentAssistSorter();
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        List<ICompletionProposal> list = new ArrayList<ICompletionProposal>();
        for (IContentAssistProcessor proc : this.assistProcessors) {
            ICompletionProposal[] computed;
            ICompletionProposal[] iCompletionProposalArray = computed = proc.computeCompletionProposals(viewer, offset);
            int n = computed.length;
            int n2 = 0;
            while (n2 < n) {
                ICompletionProposal p = iCompletionProposalArray[n2];
                list.add(p);
                ++n2;
            }
        }
        if (this.sorter != null) {
            list = this.sorter.sortProposals(viewer, offset, list);
        }
        return list.toArray(new ICompletionProposal[list.size()]);
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        ArrayList<IContextInformation> list = new ArrayList<IContextInformation>();
        for (IContentAssistProcessor proc : this.assistProcessors) {
            IContextInformation[] computed = proc.computeContextInformation(viewer, offset);
            if (computed == null) continue;
            IContextInformation[] iContextInformationArray = computed;
            int n = computed.length;
            int n2 = 0;
            while (n2 < n) {
                IContextInformation p = iContextInformationArray[n2];
                list.add(p);
                ++n2;
            }
        }
        return (IContextInformation[])list.toArray();
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return this.completionProposalsAutoActivationCharacers;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return this.contextInformationAutoActivationCharacters;
    }

    private char[] createCompletionProposalAutoActivationCharacters() {
        LinkedHashSet<Character> list = new LinkedHashSet<Character>();
        for (IContentAssistProcessor proc : this.assistProcessors) {
            char[] computed = proc.getCompletionProposalAutoActivationCharacters();
            if (computed == null || computed.length < 1) continue;
            char[] cArray = computed;
            int n = computed.length;
            int n2 = 0;
            while (n2 < n) {
                char p = cArray[n2];
                list.add(Character.valueOf(p));
                ++n2;
            }
        }
        return this.fromSetToArray(list);
    }

    private char[] createContextInformationAutoActivationCharacters() {
        LinkedHashSet<Character> list = new LinkedHashSet<Character>();
        for (IContentAssistProcessor proc : this.assistProcessors) {
            char[] computed = proc.getContextInformationAutoActivationCharacters();
            if (computed == null || computed.length < 1) continue;
            char[] cArray = computed;
            int n = computed.length;
            int n2 = 0;
            while (n2 < n) {
                char p = cArray[n2];
                list.add(Character.valueOf(p));
                ++n2;
            }
        }
        return this.fromSetToArray(list);
    }

    private char[] fromSetToArray(Set<Character> list) {
        char[] result = new char[list.size()];
        int i = 0;
        for (Character c : list) {
            result[i++] = c.charValue();
        }
        return result;
    }

    public String getErrorMessage() {
        for (IContentAssistProcessor proc : this.assistProcessors) {
            String message = proc.getErrorMessage();
            if (message == null) continue;
            return message;
        }
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return this.validatingAssistProcessor.getContextInformationValidator();
    }

    public void install(IContextInformation info, ITextViewer viewer, int offset) {
        for (IContentAssistProcessor proc : this.assistProcessors) {
            proc.getContextInformationValidator().install(info, viewer, offset);
        }
    }

    public boolean isContextInformationValid(int offset) {
        boolean valid = false;
        for (IContentAssistProcessor proc : this.assistProcessors) {
            boolean bl = valid = valid || proc.getContextInformationValidator().isContextInformationValid(offset);
            if (valid) break;
        }
        return valid;
    }
}

